
/*! responsive-nav.js 1.0.32
 * https://github.com/viljamis/responsive-nav.js
 * http://responsive-nav.com
 *
 * Copyright (c) 2014 @viljamis
 * Available under the MIT license
 */
(function(a,d,b){var c=function(e,g){var f=!!d.getComputedStyle;if(!f){d.getComputedStyle=function(x){this.el=x;this.getPropertyValue=function(z){var y=/(\-([a-z]){1})/g;if(z==="float"){z="styleFloat"}if(y.test(z)){z=z.replace(y,function(){return arguments[2].toUpperCase()})}return x.currentStyle[z]?x.currentStyle[z]:null};return this}}var q=function(A,y,z,x){if("addEventListener" in A){try{A.addEventListener(y,z,x)}catch(B){if(typeof z==="object"&&z.handleEvent){A.addEventListener(y,function(C){z.handleEvent.call(z,C)},x)}else{throw B}}}else{if("attachEvent" in A){if(typeof z==="object"&&z.handleEvent){A.attachEvent("on"+y,function(){z.handleEvent.call(z)})}else{A.attachEvent("on"+y,z)}}}},r=function(A,y,z,x){if("removeEventListener" in A){try{A.removeEventListener(y,z,x)}catch(B){if(typeof z==="object"&&z.handleEvent){A.removeEventListener(y,function(C){z.handleEvent.call(z,C)},x)}else{throw B}}}else{if("detachEvent" in A){if(typeof z==="object"&&z.handleEvent){A.detachEvent("on"+y,function(){z.handleEvent.call(z)})}else{A.detachEvent("on"+y,z)}}}},h=function(z){if(z.children.length<1){throw new Error("The Nav container has no containing elements")}var y=[];for(var x=0;x<z.children.length;x++){if(z.children[x].nodeType===1){y.push(z.children[x])}}return y},s=function(z,x){for(var y in x){z.setAttribute(y,x[y])}},l=function(y,x){if(y.className.indexOf(x)!==0){y.className+=" "+x;y.className=y.className.replace(/(^\s*)|(\s*$)/g,"")}},o=function(z,x){var y=new RegExp("(\\s|^)"+x+"(\\s|$)");z.className=z.className.replace(y," ").replace(/(^\s*)|(\s*$)/g,"")},t=function(A,z,y){for(var x=0;x<A.length;x++){z.call(y,x,A[x])}};var j,n,i,w=a.createElement("style"),k=a.documentElement,v,p,u;var m=function(z,x){var y;this.options={animate:true,transition:284,label:"Menu",insert:"before",customToggle:"",closeOnNavClick:false,openPos:"relative",navClass:"nav-collapse",navActiveClass:"js-nav-active",jsClass:"js",init:function(){},open:function(){},close:function(){}};for(y in x){this.options[y]=x[y]}l(k,this.options.jsClass);this.wrapperEl=z.replace("#","");if(a.getElementById(this.wrapperEl)){this.wrapper=a.getElementById(this.wrapperEl)}else{if(a.querySelector(this.wrapperEl)){this.wrapper=a.querySelector(this.wrapperEl)}else{throw new Error("The nav element you are trying to select doesn't exist")}}this.wrapper.inner=h(this.wrapper);n=this.options;j=this.wrapper;this._init(this)};m.prototype={destroy:function(){this._removeStyles();o(j,"closed");o(j,"opened");o(j,n.navClass);o(j,n.navClass+"-"+this.index);o(k,n.navActiveClass);j.removeAttribute("style");j.removeAttribute("aria-hidden");r(d,"resize",this,false);r(a.body,"touchmove",this,false);r(i,"touchstart",this,false);r(i,"touchend",this,false);r(i,"mouseup",this,false);r(i,"keyup",this,false);r(i,"click",this,false);if(!n.customToggle){i.parentNode.removeChild(i)}else{i.removeAttribute("aria-hidden")}},toggle:function(){if(v===true){if(!u){this.open()}else{this.close()}}},open:function(){if(!u){o(j,"closed");l(j,"opened");l(k,n.navActiveClass);l(i,"active");j.style.position=n.openPos;s(j,{"aria-hidden":"false"});u=true;n.open()}},close:function(){if(u){l(j,"closed");o(j,"opened");o(k,n.navActiveClass);o(i,"active");s(j,{"aria-hidden":"true"});if(n.animate){v=false;setTimeout(function(){j.style.position="absolute";v=true},n.transition+10)}else{j.style.position="absolute"}u=false;n.close()}},resize:function(){if(d.getComputedStyle(i,null).getPropertyValue("display")!=="none"){p=true;s(i,{"aria-hidden":"false"});if(j.className.match(/(^|\s)closed(\s|$)/)){s(j,{"aria-hidden":"true"});j.style.position="absolute"}this._createStyles();this._calcHeight()}else{p=false;s(i,{"aria-hidden":"true"});s(j,{"aria-hidden":"false"});j.style.position=n.openPos;this._removeStyles()}},handleEvent:function(y){var x=y||d.event;switch(x.type){case"touchstart":this._onTouchStart(x);break;case"touchmove":this._onTouchMove(x);break;case"touchend":case"mouseup":this._onTouchEnd(x);break;case"click":this._preventDefault(x);break;case"keyup":this._onKeyUp(x);break;case"resize":this.resize(x);break}},_init:function(){this.index=b++;l(j,n.navClass);l(j,n.navClass+"-"+this.index);l(j,"closed");v=true;u=false;this._closeOnNavClick();this._createToggle();this._transitions();this.resize();var x=this;setTimeout(function(){x.resize()},20);q(d,"resize",this,false);q(a.body,"touchmove",this,false);q(i,"touchstart",this,false);q(i,"touchend",this,false);q(i,"mouseup",this,false);q(i,"keyup",this,false);q(i,"click",this,false);n.init()},_createStyles:function(){if(!w.parentNode){w.type="text/css";a.getElementsByTagName("head")[0].appendChild(w)}},_removeStyles:function(){if(w.parentNode){w.parentNode.removeChild(w)}},_createToggle:function(){if(!n.customToggle){var y=a.createElement("a");y.innerHTML=n.label;s(y,{href:"#","class":"nav-toggle"});if(n.insert==="after"){j.parentNode.insertBefore(y,j.nextSibling)}else{j.parentNode.insertBefore(y,j)}i=y}else{var x=n.customToggle.replace("#","");if(a.getElementById(x)){i=a.getElementById(x)}else{if(a.querySelector(x)){i=a.querySelector(x)}else{throw new Error("The custom nav toggle you are trying to select doesn't exist")}}}},_closeOnNavClick:function(){if(n.closeOnNavClick&&"querySelectorAll" in a){var y=j.querySelectorAll("a"),x=this;t(y,function(z,A){q(y[z],"click",function(){if(p){x.toggle()}},false)})}},_preventDefault:function(x){if(x.preventDefault){x.preventDefault();x.stopPropagation()}else{x.returnValue=false}},_onTouchStart:function(x){x.stopPropagation();if(n.insert==="after"){l(a.body,"disable-pointer-events")}this.startX=x.touches[0].clientX;this.startY=x.touches[0].clientY;this.touchHasMoved=false;r(i,"mouseup",this,false)},_onTouchMove:function(x){if(Math.abs(x.touches[0].clientX-this.startX)>10||Math.abs(x.touches[0].clientY-this.startY)>10){this.touchHasMoved=true}},_onTouchEnd:function(y){this._preventDefault(y);if(!this.touchHasMoved){if(y.type==="touchend"){this.toggle();if(n.insert==="after"){setTimeout(function(){o(a.body,"disable-pointer-events")},n.transition+300)}return}else{var x=y||d.event;if(!(x.which===3||x.button===2)){this.toggle()}}}},_onKeyUp:function(y){var x=y||d.event;if(x.keyCode===13){this.toggle()}},_transitions:function(){if(n.animate){var x=j.style,y="max-height "+n.transition+"ms";x.WebkitTransition=y;x.MozTransition=y;x.OTransition=y;x.transition=y}},_calcHeight:function(){var z=0;for(var y=0;y<j.inner.length;y++){z+=j.inner[y].offsetHeight}var x="."+n.jsClass+" ."+n.navClass+"-"+this.index+".opened{max-height:"+z+"px !important}";if(w.styleSheet){w.styleSheet.cssText=x}else{w.innerHTML=x}x=""}};return new m(e,g)};d.responsiveNav=c}(document,window,0));