# Elementor Developer Edition - by Elementor.com

#### 3.12.0-dev3 - 2023-02-07
* Add Niv to the approved list (#21183)
* Fix: Adjusted right-click menu dark mode for blocked options [ED-9554] (#21186)
* Tweak: Added 'vw' unit to margin and padding [ED-9574] (#21187)
* Tweak: Update minimum required WordPress version to 5.3 [ED-9466] (#21192)
* Tweak: Added a vertical alignment control to icons in Icon List widget [ED-9265] (#21199)
* Fix: Button Widget - Inline editing and icon space [ED-9569] (#21185)
* Tweak: Extracted Stretch Section handler to more generic Stretch Element [ED-9454] (#21184)
* Fix: Nested tab changes sizes when direction set to row or column in Container [ED-9515] (#21228)
* Fix: Can't rollback Elementor to older Core version [ED-9525] (#21247)

#### 3.12.0-dev2 - 2023-01-26
* Fix: Keyboard actions are not blocked in Nested Tabs [ED-9355] (#21106)

#### 3.12.0-dev1 - 2023-01-24
* Fix: Justify Content icons are inverted Dir = "Column" & RTL [ED-8458] (#20866)
* Fix: Pro Gallery widget won't load unless set to 100% (#20669) [ED-9020] (#20814)
* Tweak: Remove 'kit by plan' filtering [ED-9138] (#20853)
* Tweak: Added filter for kits GET request args [ED-9259] (#20891)
* Fix: Various Carousel widgets are not working in Nested Tabs [ED-9149] (#20845)
* Fix: Multiple issues when using the converter to convert sections to containers [ED-8880] (#20908)
* Fix: UI glitch when switching between navigation position options in Loop Carousel [ED-9255] (#20942)
* Fix: Pro Gallery widget won't load unless set to 100% (#20669) [ED-9020] (#20945)
* Tweak: Added correlation between starting and ending date in Date and Time rule in Popup [ED-9266] (#20898)
* Fix: Lazyload not working on loop builder items that fetched after 'load more' action [ED-9183] (#20860)
* Tweak: Added `generator` meta tag to identify active performance settings & experiments [ED-8870] (#20877)
* New: Added background image size [ED-2108] (#20786)
* Tweak: Update site logo widget behavior [ED-9135] (#20925)
* Fix: Added WC filter to prevent duplicate pages in WC kits [ED-9140] (#20907)
* Fix: Divider widget disappears when container set to row  [ED-9287] (#20918)
* Fix: Tab toggle is not working as expected [...] in Tabs widget [ED-9177] (#20972)
* Tweak: Make the popup more accessible by adding a focus after opening the popup [ED-9067] (#20937)
* Fix: Admin top bar layout when the WP menu is folded (#21034)
* New: Upgraded Swiper Library to 8.x.x (Experiment) (#18724) [ED-9242] (#20947)
* Tweak: Update error messages when replacing URLs [ED-9295] (#20926)
* Tweak: Update error messages on imports/export processes [ED-9358] (#20985)
* Tweak: Added a responsive control to the custom image spacing of the Image Carousel [ED-9213] (#20987)
* Revert "Internal: Add support for disabling lazyload at the document level [ED-8993]" (#21059)
* Fix: Swiper 5.x minified CSS isn't generated ED-9434 (#21074)
* Tweak: Updated Google Fonts list with 125 new fonts [ED-9333] (#21073)
* Tweak: Promote experiments to advanced statuses [ED-9402] (#21048)
* New: Added copy/paste between sites (cross-domain) [ED-9332] (#21041)
* Fix: PHP 8.x deprecated features [ED-9480] (#21109)
* New: Nested Tabs - Refactor show/hide tab content callbacks to be more generic [ED-9454] (#21107)
* Tweak: Adjusted the increments of `em` and `rem` when scrubbing (#19399) [ED-8551] (#21096)
* Tweak: Removed PHP deprecation notices [ED-9467] (#21100)

#### 3.11.0-dev3 - 2022-12-28
* Tweak: Changed tabs' initial container Content Width to Full Width in Tabs widget [ED-9069] (#20788)
* Fix: Editor - Fix deps in scripts (#20818)
* Fix: Hover animation on tabs is not working as expected in Tabs widget (#20795) [ED-9162] (#20804)
* Fix: Added main and third category in kit library taxonomies [ED-9139] (#20854)
* Tweak: Nested Elements - Prevent copying the tab container [ED-9128] (#20791)
* Tweak: Prevent dragging widgets to the "Drag widget here" area from a container [ED-8939] (#20763)
* Tweak: Editor V2 - Integrating the UI library [ED-8996] (#20856)

#### 3.11.0-dev2 - 2022-12-19
* Fix: Container background overlay background image does not load [ED-8985] (#20639)
* Fix: The font looks blurry in the Admin Top Bar (#15930) (#20740)
* Tweak: Add chevron for units dropdown for better UX [ED-9046] (#20741)
* Tweak: Use `aspect-ratio` property instead of history CSS trick [ED-8875] (#20718)
* Tweak: Added Hover Animation control to Tabs Hover in Tabs widget (#20733) [ED-9040] (#20745)
* Fix: Wrong share URL for XING network [ED-9049] [ED-9048] (#20759)
* Fix: Lazy Load Background Images not loading for Template widget in the editor [ED-8994] (#20742)
* Fix: Kits Defaults - Responsive values are not saved [ED-8987] (#20657)
* Tweak: Media control return image url from WP in style css [ED-9031] (#20715)
* Fix: Rename `e-action-hash` attribute to a valid `data-elementor-action-hash` name [ED-9060] (#20514)
* Tweak: I/E - break down import process into chunks [HTS-36] (#20777)
* New: Add Mega Menu icon to eicons [ED-8920] (#20773)
* Tweak: Reorder Library Categories [HTS-80] (#20710)
* Fix: Rename `data-elementor-action-hash` attribute to a valid `data-e-action-hash` name (#20781)
* Tweak: Added more sections on System info [ED-8741] (#20662)
* New: Editor V2 - Backend experiment + loading the scripts (#20562)

#### 3.11.0-dev1 - 2022-12-13
* Tweak: Add missing default unit for controls using angel units [ED-8683] (#20344)
* Tweak: Added compatibility for Yoast Duplicate Post [ED-8677] (#20349)
* Tweak: Changed Typography control position ... [ED-8327] (#20348)
* Fix: Unnecessary "non-existing control" errors are thrown (#20027) [ED-8590] (#20358)
* Tweak: New hook action when element handler ready [ED-8581] (#20253)
* Fix: Nested Elements - Cannot drag widget inside the tab to the outside [ED-7665] (#20386)
* Tweak: Added Transform section to Advanced tab in Flexbox Container element [ED-6956] (#18803)
* Tweak: Fix escaping on button control [ED-8742] (#20413)
* Tweak: Remove the Folder icon when using a nested tab [ed-8314] (#20353)
* Fix: Sticky - Change the default transform: perspective value to initial [ED-8738] (#20408)
* Tweak: Adjusted the initial design of tabs [ED-8536] (#20378)
* Fix: Editor - Revert breaking changes of slider units [ED-8744] (#20411)
* Fix: Lazy load is not working on widgets when using motion effects [ED-8709] (#20385)
* Internal : Actions permission (#20427)
* Fix: Some widgets disappear in Flexbox Containers in certain scenarios [ED-8733] (#20397)
* Tweak: Updated the content in nested tabs [ED-8546] (#20366)
* Fix: Title Alignment is not working in Nested Tabs widget [ed-8317] (#20403)
* Tweak: Removed various elements from Nested Tabs widget [ed-8639] (#20352)
* Fix: Transform section is not working inside Container [ed-8779] (#20441)
* Tweak: Promoted "Save as Default" to beta status [ED-8773] (#20442)
* New: Nested Tabs - Change prefix for selectors [ed-7540] (#20451)
* Tweak: Merged several experiments to core [ED-8769] (#20462)
* Fix: Lazy load is not working on Container/Section when using motion effects [ED-8715] (#20398)
* New: Nested Tabs - Change prefix for selectors (v2) [ED-7540] (#20466)
* Fix: Some Ajax request doesn't work as expected after ED-8756 [ED-8800] (#20469)
* Fix: Post type is overridden on autosave for library documents (#19941) [ED-8591] (#20421)
* Fix: Translatable button in the experiments page [ED-8805] (#20482)
* New: Nested Tabs - Change prefix for selectors v3 [ed-7540] (#20485)
* Tweak: Added information note to Transform section inside Container widget [ED-8786] (#20481)
* Tweak: Don't use i18n function when throwing dependency exceptions [ED-8808] (#20488)
* Fix: Icon change position not centered & SVG icon is not visible in FE [ED-8316] (#20463)
* Fix: Title Alignment is not working in Nested Tabs widget v2 [ed-8317] (#20491)
* Tweak: Fix unit control when no have ranges on the current unit [ED-8812] (#20493)
* New: Nested Tabs - Nested Elements experiment [ED-7533] (#20399)
* New: Nested Tabs - Responsive section [ED-7331] (#20417)
* Tweak: Don't use i18n function when throwing exceptions [ED-8808] (#20490)
* New: Nested tabs - adjust spacing controls in responsive mode [ED-7558] (#20489)
* Tweak: Add `em` unit to Word Spacing control in Text Path widget (#20196)
* Fix: Changed lazy load implementation [ED-8701] (#20407)
* Tweak: Added support for various background images on the same control for Lazy Load [ED-8705] (#20540)
* Tweak: Added Loop Carousel icon widget to e-icons [ED-8739] (#20552)
* Fix: Container - Sticky Notice control triggers PHP Error in Element-rendering Ajax calls [ED-8882] (#20545)
* Fix: Elementor Overview > Recently Edited date and time not relevant [ED-8884] (#20553)
* Tweak: Add `preload` attribute to self hosted videos in Video widget [ED-8872] (#20554)
* Fix: Nested tabs - Typography hover color is not working [ED-8842] (#20538)
* Fix: Styles of child nested tabs are affected by parent nested tabs styles [ed-8835] (#20530)
* Fix: Nested tabs styling issues regarding icons [ED-8843] (#20548)
* Tweak: New units selector with custom math functions [ED-8491] (#20433)
* Fix: Add RTL support for some control glitches (#20579)
* Fix: Icons are disappearing in Nested Tabs widget [ED-8844] (#20560)
* Tweak: Nested Tabs - Disabled delete and duplicate a tab container with editing handles [ED-8893] (#20574)
* Fix: Hover over tabs is not working as expected in Nested Tabs [ed-8845] (#20572)
* Fix: Nested Tabs - Align Title isn't working well with Icon Position Top and Bottom [ed-8915] (#20590)
* Fix: Nested Tabs - Avoid jump in tab width [ed-8914] (#20594)
* Fix: Lazy Load - Performance_Labs issues [ED-8960] (#20616)
* Fix: Import/Export: SVG files are not importing when a kit is manually imported [ED-8958] (#20610)
* Tweak: Expanding existing area for editing columns, sections and containers [HTS-55] (#20484)
* New: Add an option to disable Google Fonts integration from font-family control [ED-8749] (#20492)
* Fix: Lazy Load experiment caused the background not working some cases [ED-8898] (#20561)
* Tweak: Added support to Container based template library and Kit Library [HTS-17] (#20518)
* Tweak: Added `loading=“lazy”` to Google Map widget [ED-8981] (#20630)
* Revert "Tweak: Added support to Container based template library and Kit Library [HTS-17]" (#20653)
* Fix: Nested Tabs styling issues on tabs section [ED-8841] (#20573)
* Fix: Nested Tabs - Priorititise Active state over Hover state [ed-8979] (#20628)
* Fix: Nested Tabs - Fix default alignment of Icon position top [ed-8989] (#20650)
* Fix: Nested Tabs - Icons aren't visible in mobile view [ed-8980] (#20641)
* Tweak: Add `accent-color` support to Form fields in Site Settings panel [ED-8579] (#20694)
* Fix: The not active tab in the media modal is missing [ED-8950] (#20688)
* Tweak: Added units to Icon List widget style (#20697)
* Fix: Rankmath 'wp_print_media_templates' bug [HTS-130] (#20663)
* Tweak: Added `loading="lazy"` for custom size in media control [ED-8871] (#20698)
* Revert 20653 revert 20518 tweak/hts 17 support container in libraries (#20706)
* Fix: Auto detection of dark mode not working in Theme Builder [ED-8135] (#20642)
* Tweak: Added Undo option in "Save as Default" experiment [ED-8785] (#20511)
* Fix: Copy-Paste Style prevents saving the page when Repeaters exist in "non-content" tabs [ED-8548] (#20709)
* Fix: Nested Tabs - Tabs width is pushed by content width [ed-9011] (#20675)
* Tweak: Changed Tabs widget location on the widgets panel [ED-8909] (#20668)
* Fix: Nested Tabs - Normal Tabs normal styling overrides active tab's styling [ed-9013] (#20680)
* Fix: Motion effect on background image disables background overlay in Container [ED-8466] (#20704)

#### 3.10.0-dev1 - 2022-11-08
* Fix: Separate "Default" and "None" values in "Border Type" [ED-8511] (#20145)
* Tweak: Add more units to border width controls in various elements [ED-8465] (#20037)
* Fix: Clear cache on plugin update only once (#20154)
* Fix: Can't drag widgets into a Column after it's being emptied [ED-8499] (#20152)
* Fix: Predefined container structure with default padding is not working [ED-8400] (#20171)
* Fix: First container handle is not centered on an RTL page  [ED-7788] (#20036)
* Fix: Repeater controls in "non-content" tabs cause JS errors when running Copy-Paste Style [ED-8548] (#20199)
* New: Kit Elements Default Values [ED-8357] (#20113)
* Fix: Background appearing around widgets when using the Lazy load experiment [ED-8564] (#20225)
* Fix: Image thumbnails glitch on front when using the Lazy Load experiment [ED-8563] (#20233)
* Fix: RTL text is printed backwards in Text path widget (#17309) [ED-7661] (#20230)
* Tweak: Replace the remaining 'Go Pro' labels [ED-8566] (#20204)
* Tweak: Adjusted Dark Mode in Navigator when using Container [ED-7578] (#20190)
* Tweak: Remove unneeded CSS vendor prefixes [ED-8633] (#20287)
* Tweak: Changed the confirmation modal content in Save as Default experiment [ED-8624] (#20286)
* Tweak: Update recommended PHP version in system-info [ED-8567] (#20205)
* Tweak: Added `rel="preconnect"` tag to Google Fonts to improve performance [ED-8054] (#20251)
* Tweak: Escape translation strings for safe use in HTML output [ED-8565] (#20188)
* Tweak: Remove redundant labels from group controls [ED-8558] (#20163)
* Tweak: Add angle units to rotate/skew controls in various elements [ED-8449] (#20081)
* Tweak: Add new styling controls to Post/Page Settings [ED-8483] (#20181)
* Tweak: Update privacy mode control description about Vimeo support (#20308)
* Tweak: Allow saving and reloading while in-place editing of documents [ED-8477] (#20150)
* New: Kit defaults - Import/Export runner [ED-8179] (#20099)
* Fix: Kits Defaults - Support for inner section [ED-8585] (#20261)
* Fix: PHP errors caused by deprecation module [ED-8650] (#20063)

#### 3.9.0-dev4 - 2022-10-27
* Tweak: Remove duplicate queries on admin page [ED-8346] (#20098)
* Fix: Container Full Width values are disappearing after latest version update [ED-8468] (#20111)
* Fix: Responsive controls with responsive conditions don't always apply in the front end [ED-8471] (#20112)
* Tweak: Make responsive all instances for border radius (#19896)
* Fix: Transitions functionality is not working as expected in Container (#19913) [ED-8387] (#20127)
* Fix: Build action not working [ED-8492] (#20128)
* Fix: Progress Bar layout is breaking when the direction is set to row in a container [ED-8167] (#20126)
* Fix: Broken site layout on plugin upgrade [ED-8202] (#19974)
* Revert "Fix: Broken site layout on plugin upgrade [ED-8202]" (#20136)
* Fix: Broken site layout on plugin upgrade [ED-8202] (#20137)
* Tweak: Added `dnt` param to Vimeo embed background and Video widget [ED-8191] (#20133)
* New: Introducing Background images lazy load experiment [ED-7846] (#19706)
* Fix: Pasting an element into the Preview Container throws a JS error [ED-8181] (#20118)

#### 3.9.0-dev3 - 2022-10-23
* Tweak: Add `rem` to gap between elements control [ED-8343] (#20008)
* Fix: Change all browser behavior by dark mode [ED-8212] (#20013)
* Tweak: Background video should have a background color [ED-8437] (#9885)
* Tweak: Consistent border radius units [ED-8436] (#20033)
* Fix: Container isolation: isolate issues (#19834, #19845, #19705) [ED-8353] (#20014)
* Fix: Kit Library order on WP dashboard menu was changed [ED-8221] (#19969)
* Tweak: Add `s` & `ms` units to transition-duration controls [ED-8427] (#20042)
* Fix: Swiper functionality is not working as expected [...] (#19891) [ED-7916] (#19919)
* Fix: Custom background position not inherited on mobile and front end [ED-8329] (#19883)
* Fix: Page should scroll to the loop area and not to the top of the page [ED-8447] (#20075)
* Tweak: Changed container class names to shorter names (markup changes!) [ED-8392] (#20073)
* Tweak: Upgrade the autoprefixer package to better minify CSS files [ED-8404] (#20000)

#### 3.9.0-dev2 - 2022-10-03
* Fix: Error on connect with `WP_DEBUG` = true [ED-8252] (#19862)
* Fix: Error after connecting from a promotion page and refreshing the page [ED-8259] (#19863)
* Fix: Template Library - Empty view jumps when searching [ED-8288] (#19859)
* Tweak: Button widget - responsive control for border radius [ED-7544] (#19884)
* Tweak: Add responsive option for caption to images widgets (#19852)
* Fix: Container - Apply inner container class to widgets inside the container [ED-8137] (#19686)
* Tweak: Add responsive capability to BG image opacity [ED-8344] (#19940)
* Fix: Import/Export - Not importing the relations between terms [ED-8265] (#19875)
* Tweak: Add responsive capability to BG image hover opacity [ED-8344] (#19947)
* Fix: Import/Export - Can't import on a new site [ED-8240] (#19850)
* Fix: Control Conditions - Using respon. values in selector placeholders causes fatal error [ED-8355] (#19934)
* Fix: Core - Loop template does not change live when editing the design in-place [ED-8371] (#19951)
* Tweak: Make Elementor compatible to WebP [ED-7895] (#19558)
* Tweak: Changed container class names to shorter names (markup changes!) [ED-8347] (#19962)
* Fix: See-it-live button missing on import kit summery [ED-8258] (#19937)
* Fix: Container - apply new inner container class [ED-8392] (#19970)
* Revert "Tweak: Changed container class names to shorter names (markup changes!) [ED-8347]" (#19972)
* Revert "Fix: Container - apply new inner container class [ED-8392]" (#19971)

#### 3.9.0-dev1 - 2022-09-20
* Fix: Page is not loading due to errors in the deprecation module (#19390, #19562) [ED-8031] (#19571)
* Tweak: Update pro promotion button in plugin Core onboarding [ED-7959] (#19507)
* Tweak: Increase inputs in Replace URL tool to support long URLs [ED-8030] (#19565)
* Fix: The title of editor control are not responsive [ED-8034] (#19577)
* Fix: User shouldn't be able to press THEME BUILDER logo [ED-7923]  (#19508)
* Fix: Element Base - Pass $overwrite correctly in `add_link_attributes()`. Closes #11498 [ED-8039] (#19152)
* Fix: Theme Builder - Add New popup is not working properly [ED-8044] (#19593)
* Tweak: Add Dynamic Tags for Global Colors [ED-8050] (#19598)
* Fix: Import/Export - WooCommerce products are not being imported [ED-7932] (#19603)
* Tweak: Improve the UX of dependencies between experiments [ED-7494] (#19037)
* Fix: Kit Library & Theme Builder are not loading [ED-8058] (#19610)
* Fix: Import/Export CLI - Import not overriding all templates conditions [ED-8045] (#19607)
* Fix: Changed link to https (#19630)
* Fix: Error message appears on front if WooCommerce is activated (#19533) [ED-8032] (#19631)
* Fix: Web CLI requires jQuery [ED-8059] (#19619)
* Tweak: Added clarification for the 'a' tag to the container element (#19599)
* Fix: Translation (#19652)
* Tweak: Add more units to icon and icon-box widgets [ED-8103] (#19651)
* Tweak: Added em unit for border radius to layout elements (#19491)
* Tweak: Redundant code in widgets having image (#12329)
* Tweak: Synchronous elements initialization may produce long JavaScript tasks (#15229)
* Tweak: Update bug report template (#19606)
* Tweak: Update bug report template (#19675)
* Tweak: Improved performance of Inline Fonts Icons experiment [ED-8118] (#19672)
* Fix: Background Image Custom Position/Size controls not shown for Mobile/Tablet [ED-8126] (#19677)
* Tweak: Changed Full-width and Boxed content width functionality in Container [ed-7867] (#19385)
* Tweak: Responsive text-align in Columns & Sections [ED-6803] (#16215)
* Fix: `is_current_user_can_edit` not working correctly when `$post_id` missing [ED-8136] (#19683)
* Tweak: Added text stroke for some widgets [ED-6780] (#18533)
* Tweak: Add more units to testimonial and image-box widgets (#19694)
* Tweak: Add labels to font weight numeric values [ED-7670] (#18990)
* Fix: Kit Library Connect doesn't work in 3.8.0 with production Pro [ED-8156] (#19712)
* Tweak: Change default Google fonts loading method to "Swap" [ED-7896] (#19692)
* Tweak: Allow removing the last imported Kit [ED-6987] (#19510)
* Fix: Import resolver page is being displayed on empty import conflict [ED-8106] (#19661)
* Tweak: Soft deprecation for the wrong using with widgets API [ED-8171] (#19736)
* Fix: Posts widget - query is not being imported correctly when importing a Kit [ED-4687] (#19636)
* Fix: Custom Width on tablet/mobile generates wrong value when desktop is set to default [ED-8122] (#19700)
* Tweak: Add size units to "Typography" > "Letter Spacing" [ED-8184] (#19745)
* Tweak: Added custom logo button [ED-8116] (#19740)
* Revert "Tweak: Soft deprecation for the wrong using with widgets API [ED-8171]" (#19755)
* Fix: Custom Image Size generates a fatal error after updating to PHP 8+ [ED-8165] (#19722)
* Fix: Improter WordPress root write permissions check causes import failures [ED-5913] (#19380)
* Fix: Import Export admin page - revert button causing JS console error [ED-8196] (#19767)
* Fix: CSS minified files not generated on build [ED-8199] (#19768)
* Fix: Editor menu items not working [ED-8168] (#19733)
* Tweak: Added migrate script to handle PHP8 type error on custom image size [ED-8166] (#19725)
* Tweak: Container - Move editor code to an editor scss file [ED-7940] (#19421)
* Tweak: Change the Container experiment status to Beta [ED-8085] (#19788)
* Fix: Empty state placeholder is not displayed in various widgets (#19446) [ED-7957] (#19674)
* Fix: Experiments - Status change callback not working [ED-8201] (#19781)
* Fix: When copy-pasting a widget on a page, the widget is being pasted in a Section (..) [ed-7790] (#19451)
* Tweak: Changed right-click functionality when adding a new Container [ED-7870] (#19684)
* Fix: Replaced link for better clarity in Site Settings (#19817)
* Fix: On import - replace dynamic content fix [ED-8280] (#19847)
* Fix: Can't activate or connect to the library on some languages [ED-8275] (#19848)
* Tweak:  Adjust the tag display in the experiments screens [ED-8277] (#19846)
* Tweak: Remove an option to create a custom logo in Site Settings [ED-8290] (#19860)
* Fix: Background Image - Custom X  Position doesn't work for non-desktop devices [ED-8224] (#19818)
* Fix: Connect - Connect notice appearing in a wrong place [ED-8249] (#19849)

#### 3.8.0-dev4 - 2022-08-21
* Fix: Default Flex Grow affects the layout [ed-7869] (#19437)
* Fix: Widget width is not working as expected (#19398) [ed-7915] (#19438)
* Fix: Kit sort select doesn't change from asc to desc [ED-7976] (#19490)
* Fix: Background Fallback image is hiding the background video in Container [ED-7944] (#19499)
* Fix: Motion Effects in Column in any Theme Builder template prevents Editor from loading [ED-7943] (#19435)
* Fix: Admin Menu Manager not working as expected [ED-7989] (#19517)
* Fix: Importing fails when post type file is missing [ED-8002] (#19518)

#### 3.8.0-dev3 - 2022-08-15
* Fix: Notes - Promotion dialog not opening in Panel menu [ED-7744] (#19192)
* Fix: Align notices to RTL sites [ED-4809] (#19337)
* Fix: Export kit doesn't work in a Multisite Network [ED-7696] (#19146)
* Tweak: Add to the GoPro link URL from the Kit Library more UTM parameters [ED-7745] (#19336)
* Fix: Theme Builder - Close window button isn't working [ED-7920] (#19379)
* Fix: Breakpoints manager shouldn't run deprecated hook [ED-7929] (#19404)
* Fix: Dynamic fields are missing in any number input field (#19419) [ED-7945] (#19429)
* Fix: Controls do not implement a value of 0 [ED-7935] (#19411)
* Fix: Importing and exporting duplicated posts [ED-7796] (#19381)
* Fix: Experiments - Learn more button does not open the Help center in the notice (#19448) [ED-7963] (#19467)
* Tweak: Import/Export CLI and UI mechanisms were merged into a unified service [ED-7157] (#19044)
* Fix: Width and Elements gap values (ED-7694) (#19354)

#### 3.8.0-dev2 - 2022-08-15
* Fix: Go pro link is too wide in export kit tool [ED-7575] (#19317)
* Fix: Notice Bar can't be closed in the editor [ED-7854] (#19321)
* Tweak: PHP 5.6 is deprecated [ED-7778] (#19313)
* New: Loop builder - Page should scroll to the loop area and not to the top of the page [ED-7862] (#19314)
* Tweak: Don't show exit-to modal if exit-to value was changed [ED-7484] (#19279)
* Fix: Widget width is not working as expected In Container [ED-7723] (#19286)
* Fix: Container outputs redundant CSS lines [ed-7727] (#19294)
* Fix: Import Kit wizard doesn't close the app when triggered from the Kit Library [ED-6900] (#18436)
* Tweak: Add a hook to get manifest data in import CLI command [ED-7671] (#19211)
* Fix: Add documentation for deprecated `Control_Icon` class [ED-7763] (#19303)

#### 3.7.0-dev10 - 2022-06-15
* Add more thousands separators (#18026)
* Fix: Responsive state is not working correctly in Container (#18551) [ED-7314] (#18789)
* Tweak: Merged similar translation strings (i18n) [ED-7154] (#18618)
* Fix: Critical error appeared in external apps when no page is selected as "Homepage" in Reading Settings [ED-7349] (#18801)
* Fix: Element is attached to the right instead of its original position when dragging it into a container [ED-7302] (#18802)
* Fix: Anchor Widget - Enforced better security policies [ED-7250] (#18806)
* Tweak: Added custom icons to various core widgets and features [OBXT-493] (#18231)
* Tweak: Added "em" unit for some widgets for border radius [ED-6775] (#17904)
* Tweak: Information sharing checkbox in onboarding flow was removed [ED-7316] (#18782)
* Fix: "Exit to" is not working after prompting the user to exit [ED-6927] (#18399)
* Tweak: Add "Skip and Deactivate" text button to deactivation survey (#18779)
* Fix: Overlay background is not visible [...] in Container (#18433, #18391) [ED-7315] (#18804)
* Tweak: Updated HTML A tag note in Container [ED-7368] (#18850)
* Fix: Columns control not pre-selected when choosing "Column" from the pre-designed container structures (#18390) [ED-7355]
* Tweak: Rearrange the Container panel for better discoverabilty [ED-7151] (#18788)
* Revert "Internal: Better handling file reading [ED-7104]" [ED-7396] (#18872)
* Fix: Site Settings - Gradient background doesn't work in the Editor using global colors [ED-6994] (#18419)
* Tweak: Uploads Manager - Added filters to allow modifying upload temp paths (#18565) [ED-7410] (#18566)
* Fix: Inline SVG Icons experiment does not behave correctly due to `file_get_contents()` optimization [ED-7395] (#18924)
* Fix: Control WYSIWYG - Enforced better security policies [ED-7249] (#18856)

#### 3.7.0-dev9 - 2022-05-29
*  Internal: Docs - Container [ED-7047] (#18614)
* Fix: Shortcode doesn't work in popups or templates [ED-7126] (#18654)
* New: Notes - Promotion [ED-5523] (#18377)
*  Tweak: Notes - Promotion to Core users [ED-5523]  (#18664)
* Fix: Images - Thumbnail files not deleted upon deleting its main image/attachment [ED-6973] (#18560)
* Fix: Onboarding - Playwright "Create Account" popup test fails [ED-7270] (#18712)
* Tweak: Tag viewed Kit based on UTM [ED-7139] (#18688)
* Revert "Internal: DevTools - JS Deprecation Utility [ED-7003] (#18421)" (#18753)

#### 3.7.0-dev8 - 2022-05-15
* Tweak: Tools - Change font awesome migration process [ED-6935] (#18491)
* Fix: Repeater default value was counted as a value (#18622)
* Tweak: Controls - Added option to Number Scrubbing in numeric fields [ED-6910] (#18429)

#### 3.7.0-dev7 - 2022-05-08
* New: Modules/Usage - Add page settings to tracking data [ED-1229] (#13408)
* Tweak: Custom size in image widget can no longer accept non-numeric characters [ED-7101] (#18570)
* Tweak: Added WooCommerce CSS variables (#18571)
* Fix: Container - Sometimes changing a control breaks the Editor [ED-7100] (#18569)

#### 3.7.0-dev6 - 2022-05-01
* Fix: Missing escaping translation to module onboarding (#18445) [ED-7022]
* Fix: Template library - Clear leftovers [ED-7030] (#18507)
* Fix: PHP Error when fetching System Info report for Experiments that don't have a title [ED-6879] (#18233)

#### 3.7.0-dev5 - 2022-04-17
* Tweak: Onboarding [ED-6991] (#18417)
* Tweak: Onboarding fixes and tweaks [ED-6924, ED-6832] (#18411)
* Tweak: Nested Elements - Infra [ED-6591] (#17957)
* Tweak: Update Onboarding module (#18440)

#### 3.7.0-dev4 - 2022-04-10
* Fix: Container is not functioning as expected [ED-6845] (#18339)
* Tweak: Onboarding - Updated copy for Hello screen, added footnote [ED-6817] (#18342)
* Fix: Import Export fail when trying to import unregister taxonomies [ED-6919] (#18322)
* Tweak: Add plugins support to the CLI import process [ED-6902] (#18316)
* Closes 18155 - verify if svg file exists before updating _elementor_inline_svg (#18162) [ED-6872]
* Fix: Favorites in Template Library doesn't work properly [ED-6528] (#18102)
* Tweak: Theme Builder - Open "Go Pro" link in new tab [ED-6396] (#18350)
* Fix: Nested Infra - Display Conditions window is blank [ED-6874] (#18301)
* Fix: PHP 8.1 - Throws warnings in System info [ED-6869] (#18277)
* Tweak: Allowing manual insertion of negative values to numeric fields [ED-6909] (#18371)

#### 3.7.0-dev3 - 2022-04-03
* Tweak: Nested Infra - Select repeater item command [ED-6682] (#18039)
* Fix: Container is not functioning as expected [ED-6747] (#18199)
* Tweak: Added the Revisions link to Import/Export intro screen [ED-2696] (#18200)
* Fix: Editor Panel - Pasting a term in the widget search doesn't show the results [ED-5823] (#18004)
* Fix: Revert - ED-2696 [ED-6844] (#18198)
* Fix: Custom icons disappear at frontend if name contains numbers [ED-1040] (#18110)
* Fix : Custom Fonts - the font disappears if the name contains only numbers [ED-6760] (#18116)
* Fix: Tabs a11y is not performing as expected [ED-5409] (#17491)
* Nullish operator added to e-select2 library (#18203)
* Fix: Issues in the CLI Import command which caused the import failure [ED-6857] (#18206)
* Fix: JS API - Partial refactor history versions are not clickable [ED-6588] (#18219)
* Fix: Review requests (#18221)
* Fix: Merge issue cancelling 6509 and fixing call to `get_elementor_home_page_url()` [ED-6861] (#18225)
* Fix: Editor - Not loading with some 3rd party plugins [ED-6882] (#18237)
* Tweak: Updated changelog to v3.6.1 (#18239)
* Fix: Alignment didn't respond to additional custom breakpoints in Icon List widget [ED-4966] (#18250)
* Tweak: Allow exiting to different WP screens [ED-6238] (#17637)
* Fix: Container is not functioning as expected [ED-6904] (#18292)
* Tweak: Added another preset to include option for both row and column single container directions [ED-6493] (#18214)
* Fix: Nav Menu Hamburger - Menu missing on iOS 14 or macOS 13 [ED-6886] (#18276)
* Revert "Internal: Nested Elements - Infra fixes & tests [ED-6591] (#18297)" (#18320)
* Fix: Word spacing in Global Font Typography affects all texts on the site [ED-5749] (#18287)
* Fix: Missing esc translations (#17923)

#### 3.7.0-dev2 - 2022-03-17
* Fix: Issues in the CLI Import command which caused the import failure [ED-6805] (#18171)

#### 3.7.0-dev1 - 2022-03-16
* Fix: Overlay of image upload appeared as dark mode even when editor was set to light mode [ED-5870] (#17903)
* New: Added container element [ED-2609] (#16926)
* Fix: Container - Widget width control is broken when Container experiment is active [ED-6565] (#18033)
* Fix: Posts, Archive Posts - Widget appears empty while using PHP 8.1 [ED-6466] (#17869)
* Fix: Container is not functioning as expected [ED-6592] (#18078)
* Fix: PHP 8.1 throws errors and notices [ED-6708] (#18076)
* Fix: JS API Refactor Backward Compatibility [ED-6692] (#18068)
* Fix: Visit site link when finishing the import process leads to the wrong place [ED-6509] (#18080)
* Tweak: Added the Revisions link to Import/Export intro screen [ED-2696] (#18082)
* Fix: Edit areas - Error is thrown when changing edit mode [ED-6745] (#18101)
* Fix: Container is not functioning as expected [ED-6709] (#18085)
* Fix: Import export from kit library [ED-6684] (#18047)
* Fix: Import export from kit library [ED-6684] (#18122)
* Fix: Web-CLI was not loaded in the React app [ED-6768] (#18119)
* Fix: Container - Direction control selection is not being reflected in responsive devices [ED-6710] (#18129)
* Tweak: Add the ability to identify a kit [ED-6511] (#18024)
* Tweak: Added previous active kit to the site options for future restore option [ED-6751] (#18088)
* Fix: Accordion/toggle Widget with sticky caused the page to scroll after clicking [ED-6766] (#18114)
* Fix: CSS render is delayed in the Editor [ED-6767] (#18148)
* Fix: Imported kit doesn't contain the global design [ED-6783] (#18150)
* Tweak: Admin Dashboard - Open the Go Pro link in a new tab [ED-6347] (#18112)
* New: Onboarding Analytics [ED-6162] (#18049)
* Fix: Menu Cart Widget with 3.6.4 Pro - The icon moved to the left [ED-6797] (#18158)
* Revert "Fix: Image size with a link shrunk in Image widget [ED-3397] (#17245)" (#18159)
* Tweak: Import All command should skip the Plugins screen and start import process[ED-6510] (#18131)

#### 3.6.0-dev45 - 2022-03-03
* Fix: Initial site name loads incorrectly in input, selecting image for logo causes JS error (#18036)
* Fix: Revert `elementSettingsModel` deprecation from #17374 [ED-6575] (#18044)

#### 3.6.0-dev44 - 2022-03-02
* Fix: Lower custom breakpoints didn't inherits upper breakpoints values in frontend [ED-6235] (#17475)
* New: Updated Elementor Icons library to v5.15.0 (#17632)
* Fix: Elementor React App - Back to Dashboard and Close (x) button can lead to wrong page [ED-6443] (#17752)

#### 3.6.0-dev43 - 2022-03-01
* Tweak: Added focus state and description on play icon in Video widget (#17559)
* Tweak: Added new variables colors to variables.scss file [OBXT-361] (#17560)
* Tweak: Added dynamic tag control to various core widgets and features [OBXT-384] (#17588)
* Tweak: Adjusted the inline icon control for design flexibility [OBXT-… (#17696)
* Tweak: Add Lazy load to all the widgets using Swiper [ED-2409] (#17734)
* Fix: Hash Commands [ED-6664] (#18018)
* Fix: Mobile browser background didn't work (#16566) [ED-6612] (#17972)
* New: Onboarding [ED-6175, PRDH-871] (#17605)

#### 3.6.0-dev42 - 2022-02-28
* Tweak: Added responsive capability to Icon Position control in Icon Box widget (#3040) [OBXT-573] (#17781)
* Tweak: Updated changelog for v3.5.6 (#18003)
* Tweak: One click site [ED-6569] (#17947)

#### 3.6.0-dev41 - 2022-02-24
* Fix: GitHub issue creation minor fixes [ED-6376] (#17918)
* Fix: GitHub issue creation minor fixes (#2) [ED-6376]
* Fix: GitHub issue creation minor fixes (#3) [ED-6376] (#17936)
* Tweak: Lightbox [ED-6517] (#17847)
* Tweak: Nested Infra - Allow dependencies for experiments [ED-6421] (#17663)

#### 3.6.0-dev40 - 2022-02-22
* Fix: Navigator keeps opening when dragging in a new widget [Dev edition] [ED-5776] (#17905)

#### 3.6.0-dev39 - 2022-02-17
* Fix: `remove_responsive_control()` doesn't remove controls for additional Custom breakpoints [ED-6294] (#17529)
