<?php


/**
 * Remove VC Default Templates
 *
 * @return    array
 *
 * @access    private
 * @since     4.0
 *
 */
 
function _ut_remove_default_vc_templates( $data ) {
    
    $data = array();
            
    return $data;
    
}

add_filter( 'vc_load_default_templates', '_ut_remove_default_vc_templates', 10 ); 


/**
 * Theme Default Templates
 *
 * @return    array
 *
 * @access    private
 * @since     4.0
 *
 */
 
function ut_vc_templates() {
        
    $templates = array(
        
        /* Demo 1 - Classic */
        array(
            'name'      => esc_html__( 'Demo 01 - Classic', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="About"][vc_row][vc_column][ut_header style="global" title="ABOUT BROOKLYN"]We are a creative agency located in <b>Brooklyn, New York.</b>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_service_column shape="round" animate_once="yes" delay="true" headline="APP DEVELOPMENT" effect="fadeInUp" delay_timer="50" imageicon="158"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][ut_service_column shape="round" animate_once="yes" delay="true" headline="BRAND &amp; IDENTITY" effect="fadeInUp" delay_timer="100" imageicon="152"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/2"][ut_service_column shape="round" animate_once="yes" delay="true" headline="UI DESIGN" effect="fadeInUp" delay_timer="50" imageicon="156"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][ut_service_column shape="round" animate_once="yes" delay="true" headline="CONSULTANCY" effect="fadeInUp" delay_timer="100" imageicon="154"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496960719965{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/classic/wp-content/uploads/2017/06/1.jpg?id=345) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.6)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Raleway%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:600%20bold%20regular%3A600%3Anormal" cite="UNITED THEMES – THEME DEVELOPMENT BROOKLYN" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE, PERFORMANCE LEADS TO <ins>SUCCESS!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Our Team"][vc_row][vc_column][ut_header title="OUR TEAM"]We believe in a diverse range of personel to bring <b>creative skills,</b>
<b>thoughts</b>, and <b>ideas</b> to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_person_module name_font_weight="" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="345" name="Walther White" occupation="FOUNDER" name_color="#ffffff" name_decoration_line_color="#ffffff" ocupation_color="#ffbf00" icon_color="#ffffff" icon_color_hover="#ffbf00" overlay_color="rgba(20,22,24,0.8)"][/vc_column][vc_column width="1/3"][ut_person_module name_font_weight="" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="345" overlay_color="rgba(20,22,24,0.8)" name="Skyler White" occupation="DESIGNER" name_color="#ffffff" name_decoration_line_color="#ffffff" ocupation_color="#ffbf00" icon_color="#ffffff" icon_color_hover="#ffbf00"][/vc_column][vc_column width="1/3"][ut_person_module name_font_weight="" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-steam-square%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" avatar="345" overlay_color="rgba(20,22,24,0.8)" name="Mike Ehrmantraut" occupation="DEVELOPER" name_color="#ffffff" name_decoration_line_color="#ffffff" ocupation_color="#ffbf00" icon_color="#ffffff" icon_color_hover="#ffbf00"][/vc_column][/vc_row][vc_row parallax="content-moving" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" css=".vc_custom_1496963158336{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/classic/wp-content/uploads/2017/06/1.jpg?id=345) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.6)"][vc_column][ut_header title="SOME FUN FACTS" title_color="#ffffff" lead_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a <ins>better web experience.</ins>[/ut_header][vc_row_inner equal_height="yes" content_placement="top" gap="40" css=".vc_custom_1496963081739{margin-top: 60px !important;}"][vc_column_inner width="1/4" css=".vc_custom_1496920613516{background-color: rgba(255,255,255,0.1) !important;*background-color: rgb(255,255,255) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter sep="true" caption_font_weight="" to="1270" counter_color="#ffbf00" desccolor="#ffffff"] Twinkies Eaten [/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1496920617673{background-color: rgba(255,255,255,0.1) !important;*background-color: rgb(255,255,255) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter sep="true" caption_font_weight="" to="75" counter_color="#ffbf00" desccolor="#ffffff"] Clients Worked With [/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1496920621586{background-color: rgba(255,255,255,0.1) !important;*background-color: rgb(255,255,255) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter sep="true" caption_font_weight="" to="90" counter_color="#ffbf00" desccolor="#ffffff"] Completed Projects[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1496920625824{background-color: rgba(255,255,255,0.1) !important;*background-color: rgb(255,255,255) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter sep="true" caption_font_weight="" to="4" counter_color="#ffbf00" desccolor="#ffffff"] Winning Awards[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1496877833417{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #ffbf00 !important;}"][vc_column][ut_fancy_link url="#section-contact" link_color="#ffffff" line_color="#ffffff"]Drop us a line[/ut_fancy_link][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Services"][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" bklyn_overlay_color="rgba(44,62,80,0.6)" css=".vc_custom_1496960619240{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/classic/wp-content/uploads/2017/06/1.jpg?id=345) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][ut_header title="OUR SERVICES" title_color="#ffffff" lead_color="#ffffff"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <ins>know-how</ins> and <ins>experience</ins> in your <ins>daily business</ins>.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_box headline="CONSULTING" background="rgba(255,255,255,0.10)" headline_color="#ffbf00" text_color="#ffffff" imageicon="183"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod. [/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box headline="SYSTEMS INTEGRATION" background="rgba(255,255,255,0.10)" headline_color="#ffbf00" text_color="#ffffff" imageicon="185"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod. [/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box headline="SUPPORT" background="rgba(255,255,255,0.10)" headline_color="#ffbf00" text_color="#ffffff" imageicon="189"] Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod. [/ut_service_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_custom_shortcode css=".vc_custom_1496931407672{margin-bottom: 0px !important;}"][ut_showcase id="101" name="Demo-1-Classic-Portfolio"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center bottom" background_attachment="fixed" css=".vc_custom_1496960755864{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/classic/wp-content/uploads/2017/06/1.jpg?id=345) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.6)"][vc_column][ut_header title="GET CONNECTED" title_color="#ffffff" lead_color="#ffffff"]The NSA already takes care of our social media profiles, for everyone else who wants
to get connected with us regularly, do not hesitate, <ins>we are waiting for you!</ins>[/ut_header][vc_row_inner][vc_column_inner width="1/4"][ut_big_icon icon_size="50" slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan="Follow us on Twitter" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon icon_size="50" slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon icon_size="50" slogan_text_transform="uppercase" icon="fa fa-google-plus" title="Google Plus" slogan="Join Our Circle" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon icon_size="50" slogan_text_transform="uppercase" icon="fa fa-youtube" title="Youtube" slogan="View Exclusive Videos" icon_color="#ffffff" icon_background="rgba(255,255,255,0.1)" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="clients"][vc_row][vc_column][ut_header title="HAPPY CLIENTS"]The comments below are just a sample of the <b>26.000 clients</b> worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_qtrotator_2 arrow_color="#151515" arrow_color_hover="#ffbf00"][ut_qt_2 author="GlyphConcepts" avatar="345" origin="BROOKLYN CUSTOMER"]Love the whole theme and it\'s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_qt_2][ut_qt_2 author="DerMoki" origin="BROOKLYN CUSTOMER" avatar="345"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content !
Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_qt_2][ut_qt_2 author="CodeBound" origin="BROOKLYN CUSTOMER" avatar="345"]Amazing theme - just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them.
[/ut_qt_2][ut_qt_2 author="Dori84" origin="BROOKLYN CUSTOMER" avatar="345"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box.
But even more important: I experienced outstanding support from UnitedThemes, when I came up with indiviudual questions resulting from my customization work!
[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row css=".vc_custom_1496898365662{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #ffbf00 !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="210,353,354,355,356" effect="fadeIn" delay_timer="50"][/vc_column][/vc_row][/vc_section]',

        ),
        
        /* Demo 2 - Extended */
        array(
            'name'      => esc_html__( 'Demo 02 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" bklyn_section_anchor="true" css=".vc_custom_1477932937851{margin-bottom: 0px !important;padding-top: 120px !important;padding-bottom: 0px !important;background-color: #090909 !important;}" bklyn_section_anchor_id="About Brooklyn"][vc_column css=".vc_custom_1477390682192{padding-top: 0px !important;}"][vc_row_inner css=".vc_custom_1477586581339{padding-top: 0px !important;}"][vc_column_inner css=".vc_custom_1477586586610{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="About Brooklyn" css=".vc_custom_1477949410043{margin-bottom: 60px !important;}" title_color="#ffffff" lead_accent_color="#ffffff"]We are a creative agency located in <ins>Brooklyn, New York.</ins>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInLeft" delay_timer="200"][ut_service_column shape="round" align="right" headline="APP DEVELOPMENT" icon="fa fa-cloud" color="#ffffff" background="#ff6e00" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInRight" delay_timer="200"][ut_service_column shape="round" headline="UI DESIGN" icon="fa fa-th-large" color="#ffffff" background="#151515" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477921839851{margin-top: 20px !important;}"][vc_column_inner effect="none"][ut_animated_image size="full" align="center" animate_once="yes" css=".vc_custom_1477976848241{margin-bottom: 0px !important;}" effect="zoomIn"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477930732853{margin-top: 120px !important;padding-top: 60px !important;padding-bottom: 60px !important;background-color: #080808 !important;}"][vc_column_inner css=".vc_custom_1477932362431{padding-top: 0px !important;}"][ut_fancy_link link_color="#e5e5e5" line_color="#666666" url="#contact-section" class="ut-scroll-to-section"]Get in touch with us![/ut_fancy_link][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" parallax="content-moving" parallax_image="4825" parallax_speed_bg="2.5" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" css=".vc_custom_1477971766656{padding-top: 200px !important;padding-bottom: 200px !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477932895246{padding-top: 0px !important;}"][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" quote_color="#ffffff" cite="United Themes – Theme Development Brooklyn" cite_color="#ffffff" icon="fa fa-quote-left" icon_color="#ffffff" quote_ins_color="#ff6e00"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE, PERFORMANCE LEADS TO <ins>SUCCESS</ins>![/ut_parallax_quote][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477658545595{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #090909 !important;}" bklyn_section_anchor_id="Our Service"][vc_column css=".vc_custom_1477484140481{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415810648{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="Our Services" css=".vc_custom_1477949990979{margin-bottom: 60px !important;}" title_color="#ffffff" lead_accent_color="#ffffff"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <ins>know-how</ins> and <ins>experience</ins> in your <ins>daily business</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" effect="zoomIn"][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column headline="RETINA READY &amp; RESPONSIVE" icon="fa fa-tablet" color="#ffffff" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="ONE CLICK DEMO INSTALLER" icon="fa fa-download" color="#ffffff" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="DRAG &amp; DROP PAGE BUILDER" icon="fa fa-object-ungroup" color="#ffffff" headline_color="#e5e5e5" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_section_anchor="true" css=".vc_custom_1477661373779{padding-top: 120px !important;padding-bottom: 0px !important;background-color: #080808 !important;}" bklyn_section_anchor_id="Our Work"][vc_column css=".vc_custom_1477484344871{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415836145{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="OUr Work" css=".vc_custom_1477951558952{margin-bottom: 60px !important;}" title_color="#ffffff" lead_accent_color="#ffffff"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <ins>handmade work</ins> with love for every detail.[/ut_header][ut_custom_shortcode css=".vc_custom_1477491082574{margin-bottom: 0px !important;}"][ut_showcase id="4272"][/ut_custom_shortcode][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477922623762{background-color: #080808 !important;}"][vc_column_inner css=".vc_custom_1477922635866{padding-top: 0px !important;}"][ut_image_gallery thumbnail_size="full" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816,4818,4820,4819" effect="zoomIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477960456411{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #090909 !important;}" bklyn_section_anchor_id="Clients"][vc_column css=".vc_custom_1477491736456{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="The Clients" css=".vc_custom_1477951778426{margin-bottom: 60px !important;}" lead_accent_color="#ffffff" title_color="#ffffff"]The comments below are just a sample of the <ins>22.500 clients</ins> worldwide
who transformed their business website with Brooklyn.[/ut_header][ut_qtrotator_2 quote_custom_font="yes" origin_font_weight="normal" name_color="#e5e5e5" origin_color="#ff6e00" quote_color="#666666" arrow_color="#ffffff" arrow_color_hover="#ff6e00" arrow_background_color="#080808" arrow_background_color_hover="#080808" quote_font="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="17px" quote_line_height="27px"][ut_qt_2 author="RON SCHMIDT" avatar="4825" origin="BROOKLYN CUSTOMER" imageicon="4798"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point.

Really looking forward to the upcoming demos, United Themes, you guys do a great job!”[/ut_qt_2][ut_qt_2 author="JOHN AREUS" avatar="4825" origin="BROOKLYN CUSTOMER" imageicon="4799"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 author="HENRIK SCHWARZ" avatar="4825" origin="BROOKLYN CUSTOMER" imageicon="4800"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477663286597{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #080808 !important;}" bklyn_section_anchor_id="Team"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477586544362{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="normal" title="The Crew" css=".vc_custom_1477951911579{margin-bottom: 60px !important;}" lead_accent_color="#ffffff" title_color="#ffffff"]We believe in a diverse range of personel to bring <ins>creative skills</ins>,
<ins>thoughts</ins>, and <ins>ideas</ins> to the table.
[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MARCEL M." occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#e5e5e5" ocupation_color="#ff6e00" icon_color="#e5e5e5" icon_color_hover="#ff6e00" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo2%2Fteam-single-page-1%2F|||" line_color="#111111" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MATTHIAS N." occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff6e00" name_color="#e5e5e5" description_color="#666666" line_color="#111111" icon_color="#e5e5e5" icon_color_hover="#ff6e00" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo2%2Fteam-single-page-2%2F|||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="Andreea B." occupation="SUPPORT" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff6e00" name_color="#e5e5e5" icon_color="#e5e5e5" icon_color_hover="#ff6e00" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo2%2Fteam-single-page-3%2F|||" line_color="#111111" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1477971787364{padding-top: 120px !important;padding-bottom: 80px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477586797526{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="normal" title="WE ARE GOOD AT" css=".vc_custom_1477952286209{margin-bottom: 60px !important;}" lead_accent_color="#ff6e00" lead_color="#e5e5e5" title_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a <ins>better web experience</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="95" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="Web Design" info_color="#e5e5e5" color="#ff6e00" background_color="#81d742" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="98" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="HTML / CSS" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="96" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="WORDPRESS DEVELOPMENT" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="99" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="LOGO DESIGN" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="97" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="PHP DEVELOPMENT" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="100" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="CUSTOMER SUPPORT" info_color="#e5e5e5" color="#ff6e00" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477499086415{padding-top: 120px !important;padding-bottom: 120px !important;background-color: #090909 !important;}"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="normal" title="Get Brooklyn Now" css=".vc_custom_1477952895803{margin-bottom: 60px !important;}" lead_accent_color="#ffffff" title_color="#ffffff"]Get yourself ready for an <ins>awesome experience</ins> with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner effect="none"][vc_column_inner effect="none"][vc_icon icon_fontawesome="fa fa-download" color="custom" size="xl" align="center" custom_color="#252525"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_weight="900" text_transform="uppercase" button_text="Buy Now" button_text_color="#000000" button_background="#ffffff" button_text_color_hover="#ffffff" button_background_hover="#ff6e00"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477926378383{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 1" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933051608{margin-bottom: 10px !important;}"][ut_header align="left" title="Street View" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Porsche Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816,4818,4819"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" animate_once="yes" css=".vc_custom_1477934139431{padding-right: 30px !important;padding-left: 30px !important;}" effect="fadeIn"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 2" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933233245{margin-bottom: 10px !important;}"][ut_header align="left" title="Running is a way of life" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Running for Kids" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_gallery_slider autoplay="true" loop="true" effect_in="fadeIn" effect_out="fadeOut" slides="4817,4816,4818,4819" arrow_color="#252525" arrow_color_hover="#ff6e00" dot_color="#252525" dot_color_hover="#ff6e00"][/vc_column][/vc_row]',

        ),

        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="top" css=".vc_custom_1477934526560{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 3" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477926125194{margin-bottom: 10px !important;}"][ut_header align="left" title="Winter Time" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Brooklyn in Winter" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_animated_image size="full" link_type="image" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477933557094{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1477675051837{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477934630458{margin-bottom: 10px !important;}"][ut_header align="left" lead_accent_font_weight="bold" title="Wake up and smell the coffee" title_color="#252525" lead_accent_color="#252525"]Flexibility starts with a colour! Our integrated colour picker lets you choose your desired one for several different elements to give your <ins>Brooklyn</ins> powered website and individual touch!

The art and technique of arranging type in order to make language visible. With our build in Font Manager you can give your website the final touch.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Wake Up" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="I like Coffee" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1477975104137{margin-bottom: 120px !important;padding-top: 200px !important;padding-bottom: 200px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.3)"][vc_column][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" icon="fa fa-quote-left" icon_color="#ffffff" quote_color="#ffffff" cite="Somebody" cite_color="#ffffff"]MORNING HAS BROKEN
AND THE COFFEE HAS SPOKEN[/ut_parallax_quote][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1477934909720{padding-top: 0px !important;}"][vc_custom_heading text="Start each day with a cup of positivity" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477934914183{padding-top: 0px !important;}"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477916391920{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935187461{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935014472{margin-bottom: 10px !important;}"][ut_header align="left" title="HAPPINESS IS SUN, SAND AND A DRINK IN MY HAND" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/2" css=".vc_custom_1477935191889{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477916398261{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935232537{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Take a silly selfie with your friends" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477935236742{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Salt in the air and sand in our hair" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column css=".vc_custom_1477935263955{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935030368{margin-bottom: 10px !important;}"][ut_header align="center" title="Each Demo looks different and can be imported in seconds!" title_color="#252525" css=".vc_custom_1477935035668{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="large" align="center" animate_once="yes" css=".vc_custom_1477994508471{margin-bottom: 60px !important;}" effect="fadeIn"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How we build this APP" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22App%20Development%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477925906808{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935336020{margin-bottom: 10px !important;}"][ut_header align="left" title="SENNHEISER HD 598" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="OVERVIEW" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Characteristics" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Sennheiser%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="4817,4816,4818"][ut_media_slider slides="%5B%7B%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F76850650%22%2C%22poster%22%3A%224825%22%7D%5D"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row"][vc_column][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935419748{margin-bottom: 10px !important;}"][ut_header align="center" title="Just What You Need " title_color="#252525" css=".vc_custom_1477935468275{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1477505777253{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][vc_column width="1/2" css=".vc_custom_1475504625537{padding-left: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663877638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935429458{margin-bottom: 10px !important;}"][ut_header align="left" title="Endless Possibilities" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Create One-Page or Multi-Page websites easily by using the Visual Composer per Drag & Drop or use shortcodes. It’s up to you!
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1477976012124{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663884237{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935605405{margin-bottom: 10px !important;}"][ut_header align="left" title="Powerful Admin Panel" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]That will cover all your basic needs! You don’t need to touch a single line of code, perfect for people without any coding knowledge. Individualize Layouts, Colours & Styles within minutes.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1477976022692{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2/wp-content/uploads/2016/11/replace-normal.jpg?id=4825) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935536739{margin-bottom: 10px !important;}"][ut_header align="center" title="Thank You" title_color="#252525" css=".vc_custom_1477935532710{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How We Work" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2026%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" share_text_color="#252525" icon_color="#999999" border="true" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_media_slider dots="false" slides="%5B%7B%22title%22%3A%22Slide%201%22%2C%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F10089801%22%2C%22poster%22%3A%224825%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Portfolio Style 8" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477662215938{margin-bottom: 10px !important;}"][ut_header align="left" title="Hello Brooklyn" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="2/3"][vc_custom_heading text="We love Brooklyn" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/3"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Team Single 1', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Marcel M." title_color="#252525"]Hello, Im Marcel Designer at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="MARCEL M." occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing.[/vc_column_text][ut_probar_thin width="99" animate_once="yes" info_font_weight="" info="Project Management" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="97" animate_once="yes" info_font_weight="" info="Web Design" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477939841961{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column css=".vc_custom_1477939807253{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_custom_heading text="my recent work" font_container="tag:h3|text_align:center|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][ut_custom_shortcode css=".vc_custom_1477939724912{margin-bottom: 0px !important;}"][ut_showcase id="4642"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477939326326{margin-bottom: 0px !important;background-color: #080808 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 2 - Team Single 2', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Matthias N." title_color="#252525"]Hello, Im Matthias Coder at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Matthias N." occupation="Coder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477930077660{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #080808 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 02 - Team Single 3', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Andreea B." title_color="#252525"]Hello, Im Andreea Support Guru at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Andreea B." occupation="Support Guru" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477947493614{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #ff6e00 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        
        /* Demo 3 */
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 1', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Across </b> all Devices" color="#ffffff" background="#00aeef" imageicon="263" effect="zoomIn" delay_timer="100"]Duo ei ornatus disputando. His ei eros deserunt.[/ut_service_column_vertical][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Ultra</b> Responsive Layout" color="#ffffff" background="#ffa2ad" imageicon="324" effect="zoomIn" delay_timer="200"]Qui deleniti dissentiet complectitur ad. Sit eros habeo.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Ready</b> for all Browsers" background="#fecf39" color="#ffffff" imageicon="343" effect="zoomIn" delay_timer="150"]Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column_vertical][ut_service_column_vertical shape="rounded" align="left" animate_once="yes" delay="true" headline="<b>Timeless</b> Unique Design" color="#ffffff" background="#8781bd" imageicon="348" effect="zoomIn" delay_timer="250"]Ex nonumy aperiri sea, has at augue postea.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_video_player video_shadow="on" icon_type="" url="https://vimeo.com/155900013" caption="SPIKE DDB BROOKLYN MADE" poster="32" play_bg_color="#0267c1"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387481789{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="970" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="496"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="505"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387519865{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#71787e"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387530000{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="<b>Creating</b> ideas and building
brands that truly matter to people.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="full" align="center" animate_once="yes" image="1285" css=".vc_custom_1497864408798{margin-bottom: 0px !important;}" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387539640{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn,</b> a webmaster\'s best friend.
Our vision, your future."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Cean Design" color="#00aeef" effect="fadeInUp" delay_timer="50" imageicon="496"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Ultra</b> Responsive Design " color="#ffa2ad" effect="fadeInUp" delay_timer="50" imageicon="502"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Easy</b> to Customize" color="#fecf39" effect="fadeInUp" delay_timer="50" imageicon="500"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeInUp" delay_timer="50" imageicon="505"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>115+</b> Page Templates" color="#8781bd" effect="fadeInUp" delay_timer="100" imageicon="577"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>One Click</b> Installation" color="#ffa2ad" effect="fadeInUp" delay_timer="100" imageicon="584"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>70+</b> Theme Updates" color="#fecf39" effect="fadeInUp" delay_timer="100" imageicon="581"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Power Elite</b> Support" color="#00aeef" effect="fadeInUp" delay_timer="100" imageicon="575"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497478235653{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>26.000</b> customers transforms
already their website with Brooklyn."]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_qtrotator_2 arrow_color="#393c3e" arrow_color_hover="#71787e" name_color="#393c3e" quote_color="#71787e" origin_color="#393c3e"][ut_qt_2 avatar="186" author="EmCarkh" origin="Brooklyn Customer" imageicon="563"]â€œGenuinely love this theme. So sick of trawling through endless menus and options on other themes. Brooklyn is so intuitive with where all its settings are located and is just a pleasure to use. Also, the sheer number of demos and ability to mix elements from different demos means it works well for so many purposes.â€[/ut_qt_2][ut_qt_2 avatar="187" author="CMPhoto" origin="Brooklyn Customer" imageicon="565"]â€œGreat theme with great flexibility. A lot of ready-to-go demos which can be installed with a single click. Really great support if needed. With most updates, there is a new demo added to the bundle.â€[/ut_qt_2][ut_qt_2 avatar="188" author="CodeBound" origin="Brooklyn Customer" imageicon="560"]â€œAmazing theme â€“ just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them.â€[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498240706039{padding-top: 80px !important;padding-bottom: 80px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" lightbox="no" animate_once="yes" delay_animation="true" gallery="199,195,196,197,198" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 2', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row 0=""][vc_column width="1/3"][ut_service_icon_box headline="<b>Ready</b> for all Browsers" imageicon="343" color="#0267c1" hovercolor="#0267c1"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box headline="<b>Ultra</b> Responsive Layout" imageicon="324" color="#0267c1" hovercolor="#0267c1"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box headline="<b>Timeless</b> Unique Design" imageicon="348" color="#0267c1" hovercolor="#0267c1"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_icon_box][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387481789{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="970" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497387519865{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497478235653{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497867331748{padding-bottom: 0px !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn,</b> a webmaster\'s best
friend. Our vision, your future."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Fresh</b> &amp; Cean Design" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Ultra</b> Responsive Design " imageicon="1339"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Easy</b> to Customize" imageicon="1340"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>27+</b> Beautiful Demos" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column 0=""][ut_gallery_slider type="carousel" number="4" number_tablet="4" nav="false" hover_caption="on" slides="1300,1349,1351,1350" css=".vc_custom_1497876686586{margin-bottom: 0px !important;}" hover_caption_color="#ffffff"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498240836016{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 3', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row 0=""][vc_column width="1/3"][vc_single_image image="1300" img_size="large"][ut_service_column headline="<b>Ready</b> for all Browsers" link="url:%23|title:Learn%20More||"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column][/vc_column][vc_column width="1/3"][vc_single_image image="1349" img_size="large"][ut_service_column headline="<b>Ultra</b> Responsive Layout" link="url:%23|title:Learn%20More||"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column][/vc_column][vc_column width="1/3"][vc_single_image image="1351" img_size="large"][ut_service_column headline="<b>Timeless</b> Unique Design" link="url:%23|title:Learn%20More||"]Duo ei ornatus disputando. His ei eros deserunt. Quando moderatius reprimique at sed, id vel partiendo.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877361169{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="970" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877305645{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877415878{background-color: #f7f8fa !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn,</b> a webmaster\'s best
friend. Our vision, your future."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Fresh</b> &amp; Cean Design" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Ultra</b> Responsive Design " imageicon="1339"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Easy</b> to Customize" imageicon="1340"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>27+</b> Beautiful Demos" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497877399527{border-top-width: 1px !important;border-top-color: #dddddd !important;border-top-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498241105883{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_border_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 4', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497387491552{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Fresh</b> &amp; Cean Design" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Ultra</b> Responsive Design " imageicon="1339"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>Easy</b> to Customize" imageicon="1340"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_service_column_vertical align="left" headline="<b>27+</b> Beautiful Demos" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497882604910{border-bottom-width: 1px !important;background-color: #fcfcfc !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="right" animate_once="yes" image="1456" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="<b>Innovation</b> needs to be
part of your website.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>Fresh</b> &amp; Clean Design" color="#00aeef" effect="fadeIn" delay_timer="50" imageicon="1338"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_service_column size="medium" animate_once="yes" delay="true" headline="<b>27+</b> Beautiful Demos" color="#8781bd" effect="fadeIn" delay_timer="100" imageicon="1341"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_service_column][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497883176000{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating ideas</b> and building
brands that truly matter to people."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="97" title_text_font="on" title="Creative Thinking"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="90" title_text_font="on" title="Web Design"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="82" title_text_font="on" title="HTML / CSS"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_progress_circle percent="69" title_text_font="on" title="UI Design"][ut_service_column]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497882483945{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #fcfcfc !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="right" title="<b>Creative</b> solutions and
results that grow brands.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_social_follow align="right" size="24" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" animate_once="yes" image="1458" effect="fadeIn" css=".vc_custom_1497942327124{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497883485277{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" caption="yes" animate_once="yes" gallery="705,707,706,708,709,710" effect="zoomIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497950175762{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #fcfcfc !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Weâ€™ll design experiences,</b>
we do not copy them."]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Learn More" button_text_color="#ffffff" button_background="#0267c1" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e"][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="full" align="center" animate_once="yes" image="1461" css=".vc_custom_1497950034520{margin-bottom: 0px !important;}" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>26.000</b> customers transforms
already their website with Brooklyn."]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="188" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="187" title="<b>Customer</b> Support" author="Dori84" company="Brooklyn Customer" rating_color="#fec42d"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box. But even more important: I experienced outstanding support from UnitedThemes, when I came up with indiviudual questions resulting from my customization work!
[/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Awesome</b> Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d"]Love the whole theme and it\'s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="1388" title="<b>Customer</b> Support" author="dpassudetti" company="Brooklyn Customer" rating_color="#fec42d"]Very prompt, friendly and knowledgeable support... both pre and post sale. Well done people!! [/ut_single_quote][/vc_column][/vc_row][vc_row css=".vc_custom_1497883067054{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #393c3e !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="199,198,197,196,195" delay_timer="50" effect="zoomIn"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498241230650{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#ffffff" text_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)" text_color_hover="rgba(255,255,255,0.5)"][vc_custom_heading text="Follow us" font_container="tag:h3|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1497942660135{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#ffffff" icon_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 5', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498042120570{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="left" title="About <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_video_player icon_type="" url="https://vimeo.com/155900013" caption="He has a vision and he\'s not afraid to share." poster="1640" play_bg_color="#0267c1"][/vc_column][vc_column width="1/2" background_position="center center" background_attachment="scroll" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_single_quote rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums![/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" lightbox="no" animate_once="yes" delay_animation="true" gallery="678,676,677,674,675" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498042097485{background-color: #f7f8fa !important;}"][vc_row][vc_column][ut_header align="left" title="What We <b>Do.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1635" img_size="large" alignment="center"][ut_service_column size="medium" headline="Getting a look into the morning meeting" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1636" img_size="large" alignment="center"][ut_service_column size="medium" headline="Attitude reflects leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1637" img_size="large" alignment="center"][ut_service_column size="medium" headline="Develop work skills and leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498124042898{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/p-10.jpg?id=1635) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="left" title="Our <b>Services.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498241598859{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" headline="Template Installer" imageicon="1338" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.5)" link="url:%23|title:Learn%20More||" background="#ffffff"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498241608357{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" headline="Template Builder" imageicon="1341" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.5)" link="url:%23|title:Learn%20More||" background="#ffffff"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498241615894{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical shape="rounded" align="left" headline="Customize Everything" imageicon="1339" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.5)" link="url:%23|title:Learn%20More||" background="#ffffff"]All parts of Brooklyn can be customized! From header to footer and everything whatâ€™s in between![/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498042689042{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="left" title="Our <b>Projects.</b>
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_showcase_shortcode showcase_id="1614" css=".vc_custom_1498045267629{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498143356175{background-color: #f7f8fa !important;}"][vc_row][vc_column][ut_header align="left" title="<b>26.000</b> customers transforms
already their website with Brooklyn."]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498241623555{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;background-color: #ffffff !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_single_quote style="style-2" rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d" date="Brooklyn | Creative Multi-Purpose Theme"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ![/ut_single_quote][/vc_column][vc_column width="1/3" css=".vc_custom_1498241630405{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;background-color: #ffffff !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_single_quote style="style-2" rating="5" avatar="188" title="Awesome Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d" date="Brooklyn | Creative Multi-Purpose Theme"]Love the whole theme and itâ€™s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/3" css=".vc_custom_1498241638257{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;background-color: #ffffff !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_single_quote style="style-2" rating="5" avatar="187" title="Customer Suppor" author="Saraballarin" company="Brooklyn Customer" rating_color="#fec42d" date="Brooklyn | Creative Multi-Purpose Theme"]I purchased this theme and let me say I\'m really glad I did! The design is great, the theme is flexible and I\'m having excellent customer support. [/ut_single_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498241445418{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="left" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_align="bklyn-btn-left" button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][vc_row_inner equal_height="yes" content_placement="middle" gap="40" css=".vc_custom_1498123970255{margin-top: 40px !important;}"][vc_column_inner width="1/4" css=".vc_custom_1498241641821{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="Any Question at" imageicon="872" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1498241464201{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="1399 Beverley Rd" imageicon="877" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1498241471819{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="Monday - Saturday" imageicon="348" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]8 am â€“ 8 pm[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/4" css=".vc_custom_1498241478968{background-color: rgba(2,103,193,0.7) !important;*background-color: rgb(2,103,193) !important;}" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical size="medium" align="left" headline="Send your mail at" imageicon="875" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 6', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="What We <b>Do.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1635" img_size="large" alignment="center"][ut_service_column size="medium" headline="Getting a look into the morning meeting" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12"][vc_single_image image="1636" img_size="large" alignment="center"][ut_service_column size="medium" headline="Attitude reflects leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="1637" img_size="large" alignment="center"][ut_service_column size="medium" headline="Develop work skills and leadership" link="url:%23|title:Learn%20More||" link_color="#393c3e" link_hover_color="#71787e"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498124042898{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/p-10.jpg?id=1635) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="Our <b>Services.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_box icon_type="bklynicons" size="small" headline="Template Installer" background="rgba(2,103,193,0.7)" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)" icon_bklyn="BklynIcons-Rocket-Launch"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_box icon_type="bklynicons" size="small" icon_bklyn="BklynIcons-Computer-Network-2" headline="Template Builder" background="rgba(2,103,193,0.7)" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_box][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_box icon_type="bklynicons" size="small" icon_bklyn="BklynIcons-Rotate-2" headline="Customize Everything" background="rgba(2,103,193,0.7)" headline_color="#ffffff" text_color="rgba(255,255,255,0.8)"]All parts of Brooklyn can be customized! From header to footer and everything whatâ€™s in between![/ut_service_box][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="Our <b>Projects.</b>
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_showcase_shortcode showcase_id="1849" css=".vc_custom_1498214154072{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498220999278{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="The <b>Team.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="886" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)" description_color="rgba(255,255,255,0.8)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="887" name="Sven Grim" occupation="CTO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="888" name="Richard Cremer" occupation="CHRO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="911" name="Harald Ehrenfeld" occupation="Backend Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)" description_color="rgba(255,255,255,0.8)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="889" name="Regina Schoenen" occupation="Graphic Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][vc_column width="1/6" offset="vc_col-lg-2 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member style="member-style-2" line="off" avatar="890" name="Ben Schwarz" occupation="Graphic Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#ffffff" name_color="#ffffff" ocupation_color="rgba(255,255,255,0.8)" description_color="rgba(255,255,255,0.8)" icon_color_hover="rgba(255,255,255,0.5)"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498242037346{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Home Variant 7', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="<b>Innovation</b> needs to
be part of <b>your website.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" imageicon="101" headline="Template Installer" link="url:%23|title:Learn%20More||" background="#0267c1" link_color="#393c3e"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" imageicon="343" headline="Template Builder" link="url:%23|title:Learn%20More||" background="#0267c1" link_color="#393c3e"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" imageicon="263" headline="Customize Everything" link="url:%23|title:Learn%20More||" background="#0267c1" link_color="#393c3e"]All parts of Brooklyn can be customized! From header to footer and everything whatâ€™s in between![/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498228556063{padding-bottom: 0px !important;background-color: #f7f8fa !important;}"][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="Creative solutions and
results that grow brands."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="1838" css=".vc_custom_1498228038692{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498228521415{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row 0=""][vc_column 0=""][ut_header align="center" title="<b>Brooklyn</b> will <b>make</b> you
more <b>proud</b> of your <b>business.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1784" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="1774" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1766" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1784" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="1774" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1766" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498242253892{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497391360783{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="Achievements of <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" caption_font_weight="" to="94" suffix="%" counter_color="#0267c1" icon_bklyn="BklynIcons-Hearts-Empty" color="#393c3e"]<b>Positive</b> Feedback [/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" caption_font_weight="" to="27" counter_color="#0267c1" icon_bklyn="BklynIcons-Computer-Network-2" color="#393c3e"]<b>Demos</b> Released[/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" sep="true" caption_font_weight="" to="42000" counter_color="#0267c1" icon_bklyn="BklynIcons-Navigation-1" color="#393c3e"]<b>Happy</b> Buyers[/ut_number_counter][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_number_counter icon_spacing="20" sep="true" caption_font_weight="" to="59" prefix="$" counter_color="#0267c1" icon_bklyn="BklynIcons-Financial-Care-2" color="#393c3e"]<b>Average Cost</b> Per Hour[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497391445516{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="The History Story of <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_icon_tabs][ut_icon_tab icon_source="bklynicons" label="2013" icon_bklyn="BklynIcons-Lens-1" label_color="#393c3e" icon_color="#393c3e" icon_hover_color="#0267c1" label_hover_color="#393c3e"]<img class="wp-image-959 size-full aligncenter" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/m4.png" alt="" width="955" height="720" />
<h3><strong>Brooklyn </strong>first release was end in 2013</h3>
Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.

Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues. It va esser tam simplic quam Occidental in fact, it va esser Occidental.[/ut_icon_tab][ut_icon_tab icon_source="bklynicons" label="2015" icon_bklyn="BklynIcons-Office-Chair" label_color="#393c3e" icon_color="#393c3e" icon_hover_color="#0267c1" label_hover_color="#393c3e"]<img class="aligncenter size-large wp-image-956" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/m1-1160x720.png" alt="" width="1160" height="720" />
<h3><strong>Among the top 5</strong> best selling themes of all time</h3>
Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.

Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues.[/ut_icon_tab][ut_icon_tab icon_source="bklynicons" label="2017" icon_bklyn="BklynIcons-Hand-cargo" label_color="#393c3e" icon_color="#393c3e" icon_hover_color="#0267c1" label_hover_color="#393c3e"]<img class="aligncenter size-large wp-image-958" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/m3-1160x720.png" alt="" width="1160" height="720" />
<h3><strong>Never ending</strong> fight against the whole marketplace</h3>
Li Europan lingues es membres del sam familie. Lor separat existentie es un myth. Por scientie, musica, sport etc, litot Europa usa li sam vocabular. Li lingues differe solmen in li grammatica, li pronunciation e li plu commun vocabules. Omnicos directe al desirabilite de un nov lingua franca: On refusa continuar payar custosi traductores. At solmen va esser necessi far uniform grammatica, pronunciation e plu sommun paroles.

Ma quande lingues coalesce, li grammatica del resultant lingue es plu simplic e regulari quam ti del coalescent lingues. Li nov lingua franca va esser plu simplic e regulari quam li existent Europan lingues.[/ut_icon_tab][/ut_icon_tabs][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497391456933{border-bottom-width: 1px !important;padding-bottom: 0px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header title="Transform your website with <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily. [/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_text="Start Now" button_text_color="#ffffff" button_background="#0267c1" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179%3Fref%3DUnitedThemes||target:%20_blank|"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" animate_once="yes" image="1285" css=".vc_custom_1497962533544{margin-bottom: 0px !important;}" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497391467213{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="The Team of <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_team_member style="member-style-2" icon_size="18" line_width="1" avatar="886" name="John Brooklyn" occupation="Founder &amp; CEO" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi sagittis, sem quis lacinia faucibus, orci ipsum.[/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12"][ut_team_member style="member-style-2" icon_size="18" line_width="1" avatar="887" name="Sven Grim" occupation="CTO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi sagittis, sem quis lacinia faucibus, orci ipsum.[/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_team_member style="member-style-2" icon_size="18" line_width="1" avatar="888" name="Richard Cremer" occupation="CHRO / Co Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi sagittis, sem quis lacinia faucibus, orci ipsum.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498242362629{padding-bottom: 120px !important;background-color: #f7f8fa !important;}"][vc_row][vc_column][ut_header align="center" title="Awesome Clients using <b>Brooklyn.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily. [/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_client_group carousel="true" deco_line_color_top="#dddddd" deco_line_color_bottom="#dddddd" arrow_color="#ffffff" arrow_color_hover="#ffffff" arrow_border_color="#0267c1" arrow_border_color_hover="#0267c1" arrow_background="#0267c1" arrow_background_hover="#0267c1"][ut_client logo="673"][ut_client logo="674"][ut_client logo="675"][ut_client logo="676"][ut_client logo="677"][ut_client logo="678"][/ut_client_group][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Services Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497455841382{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="We keep our <b>word.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle circle_style="two" title="We are <b>on Time</b>" imageicon="1050" css=".vc_custom_1497460611196{margin-bottom: 20px !important;}"][ut_service_column css=".vc_custom_1497460714875{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ffffff !important;}" link="url:%23|title:Learn%20More||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle circle_style="two" percent="90" title="We are <b>Satisfactory</b>" imageicon="1042" css=".vc_custom_1497460422799{margin-bottom: 20px !important;}"][ut_service_column css=".vc_custom_1497460722219{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ffffff !important;}" link="url:%23|title:Learn%20More||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle circle_style="two" percent="95" title="We are <b>Experienced</b>" css=".vc_custom_1497460625719{margin-bottom: 20px !important;}" imageicon="1051"][ut_service_column css=".vc_custom_1497460732038{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ffffff !important;}" link="url:%23|title:Learn%20More||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="Our <b>Services.</b> "]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1467781577280{margin-bottom: 40px !important;}"][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="710" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>Fresh</b> &amp; Clean Design"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][vc_single_image image="708" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>115+</b> Page Templates"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="709" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>Ultra</b> Responsive Design "]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][vc_single_image image="707" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>One Click</b> Installation"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_single_image image="705" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>Easy</b> to Customize"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][vc_single_image image="706" img_size="large" alignment="center"][ut_service_column link="url:%23|title:Learn%20More||" headline="<b>70+</b> Theme Updates"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.
[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498242542362{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Product Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][vc_single_image image="972" img_size="full" alignment="center"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497479046407{border-top-width: 1px !important;border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will boost your
website to an amazing web tool."]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption_below="yes" animate_once="yes" delay_animation="true" gallery="1174,1175,970,958,956,1197" delay_timer="50" effect="fadeIn"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player video_shadow="on" icon_type="" url="https://vimeo.com/155900013" caption="SPIKE DDB BROOKLYN MADE" poster="32" play_bg_color="#0267c1" css=".vc_custom_1497479657429{margin-bottom: 20px !important;}"][vc_custom_heading text="We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily." font_container="tag:p|text_align:left" use_theme_fonts="yes" css=".vc_custom_1497860902896{margin-bottom: 20px !important;}"][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="1" button_text="Free Trail Version" button_text_color="#393c3e" button_background="rgba(2,103,193,0)" button_text_color_hover="#0267c1" button_background_hover="rgba(2,103,193,0)" button_border_color_hover="#0267c1" button_border_color="#393c3e"][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="Available for:" font_container="tag:div|font_size:10px|text_align:center|line_height:10px" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1497860784352{margin-bottom: 10px !important;}"][ut_social_follow align="center" gap="40 Pixel" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#71787e"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1498243327516{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" shadow="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e" background_color="#ffffff" border_color="#dddddd" inner_border_color="#ffffff"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="30" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#0267c1" button_background="#ffffff" price_font_color="#ffffff" image="970" button_border_color_hover="#ffffff" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#ffffff" background_color="#0267c1" headline_text_color="#ffffff" subheadline_text_color="#ffffff" period_text_color="#ffffff" feature_text_color="#ffffff" inner_border_color="#0267c1"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" shadow="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" background_color="#ffffff" inner_border_color="#ffffff"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e" background_color="#ffffff" inner_border_color="#ffffff"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e" inner_border_color="#0267c1"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e" background_color="#ffffff" inner_border_color="#ffffff"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243386794{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Product Page 2', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497962373383{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="In a world of over 1 billion websites, <b>does your website stand out?</b>"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_animated_image size="full" align="center" image="972" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="3" gap="40" caption_below="yes" animate_once="yes" delay_animation="true" gallery="1174,1175,970,958,956,1197" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="We Create the World" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="Available for:" font_container="tag:div|font_size:10px|text_align:center|line_height:10px" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1497860784352{margin-bottom: 10px !important;}"][ut_social_follow align="center" gap="40 Pixel" socials="%5B%7B%22icon%22%3A%22fa%20fa-windows%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-apple%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-android%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#71787e"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="none" delay_timer="200"][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" icon_color_hover="#0267c1" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498243421895{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Pricing Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497473807367{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498243609016{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Team Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497960542756{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row animate_once="yes" effect="none"][vc_column][ut_header align="center" title="The founders of <b>Brooklyn.</b>" lead_accent_color="#151515"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497444454313{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column width="1/3"][ut_team_member icon_size="18" line_width="1" name="John Brooklyn" occupation="CEO / Founder" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#393c3e" avatar="886" css=".vc_custom_1497444649659{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="18" line_width="1" name="Sven Grim" occupation="CTO / Co Founder" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#393c3e" avatar="887" css=".vc_custom_1497444641563{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="18" line_width="1" name="Richard Cremer" occupation="CHRO / Co Founder" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#393c3e" avatar="888" css=".vc_custom_1497444782905{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1497960580142{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row animate_once="yes" effect="none"][vc_column][ut_header align="center" title="The team of <b>Brooklyn.</b>" lead_accent_color="#151515"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row animate_once="yes" effect="none"][vc_column width="1/4"][ut_team_member style="member-style-5" name="Harald Ehrenfeld" occupation="Backend Developer" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0267c1" avatar="911" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Patrick Wolf" occupation="Community Manager" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="892" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" name="Regina Schoenen" occupation="Graphic Designer" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="889" css=".vc_custom_1497461560963{background-color: #ffffff !important;}" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Eva Richter" occupation="Marketing Experte" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="893" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" name="Ben Schwarz" occupation="Graphic Designer" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="890" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Sven Bauer" occupation="Account Manager" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="894" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member style="member-style-5" name="Christine Becks" occupation="Sales Experte" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="891" icon_color_hover="#393c3e"][/ut_team_member][ut_team_member style="member-style-5" name="Leo Schmitz" occupation="Assistant" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" avatar="895" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243742695{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" effect="none"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Person Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497960334020{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="Learn more about <b>John.</b>"]Hello, I\'m John CEO &amp; founder at Brooklyn Designs.
[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/2"][ut_team_member align="left" icon_size="20" name="John Brooklyn" avatar="886" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color_hover="#393c3e"][/ut_team_member][/vc_column][vc_column width="1/2"][vc_custom_heading text="John\'s Biography" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="900" info="PHP Coding" color="#0267c1" percentage_bg_color="#0267c1" info_color="#393c3e" percentage_color="#ffffff"][ut_probar_thin width="95" animate_once="yes" info_font_weight="900" info="jQuery Coding" info_color="#393c3e" color="#0267c1" percentage_color="#ffffff" percentage_bg_color="#0267c1"][ut_probar_thin width="98" animate_once="yes" info_font_weight="900" info="Plugin Development" info_color="#393c3e" color="#0267c1" percentage_color="#ffffff" percentage_bg_color="#0267c1"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243865566{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>John.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Partner Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497473807367{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="Our Great <b>Partners.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row gap="40" css=".vc_custom_1497434998760{border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435233793{background-color: #f7f8fa !important;}"][vc_single_image image="675" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435228695{background-color: #f7f8fa !important;}"][vc_single_image image="673" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435223945{background-color: #f7f8fa !important;}"][vc_single_image image="677" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435218568{background-color: #f7f8fa !important;}"][vc_single_image image="676" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435133750{margin-top: 40px !important;border-bottom-width: 1px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_column width="1/4" css=".vc_custom_1497435208349{background-color: #f7f8fa !important;}"][vc_single_image image="674" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][vc_row gap="40" css=".vc_custom_1497435158204{margin-top: 40px !important;}"][vc_column width="1/4" css=".vc_custom_1497435214250{background-color: #f7f8fa !important;}"][vc_single_image image="678" alignment="center"][/vc_column][vc_column width="3/4"][ut_service_column headline="ThemeForest <b>Envato</b>" link="url:%23|title:Visit%20Partner||"]Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.
[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498243964091{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Become a partner of <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Testimonials Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497473807367{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="188" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="187" title="<b>Customer</b> Support" author="Dori84" company="Brooklyn Customer" rating_color="#fec42d"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box. But even more important: I experienced outstanding support from UnitedThemes, when I came up with indiviudual questions resulting from my customization work!
[/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Awesome</b> Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d"]Love the whole theme and it\'s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="1388" title="<b>Customer</b> Support" author="dpassudetti" company="Brooklyn Customer" rating_color="#fec42d"]Very prompt, friendly and knowledgeable support... both pre and post sale. Well done people!! [/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="188" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="187" title="<b>Customer</b> Support" author="Dori84" company="Brooklyn Customer" rating_color="#fec42d"]I built a multisite website with this theme and I was really excited about the design and function that are available out of the box. But even more important: I experienced outstanding support from UnitedThemes, when I came up with indiviudual questions resulting from my customization work!
[/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Awesome</b> Flexibility" author="GlyphConcepts" company="Brooklyn Customer" rating_color="#fec42d"]Love the whole theme and it\'s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_single_quote][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="1388" title="<b>Customer</b> Support" author="dpassudetti" company="Brooklyn Customer" rating_color="#fec42d"]Very prompt, friendly and knowledgeable support... both pre and post sale. Well done people!! [/ut_single_quote][/vc_column][/vc_row][vc_row css=".vc_custom_1497883067054{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #393c3e !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="199,198,197,196,195" delay_timer="50" effect="zoomIn"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498244067978{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Become a customer of <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Video Tutorials Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497960426290{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Hi there!</b> I am Brooklyn,
way more than just a standard theme.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player caption="Lesson 1." url="https://youtu.be/z_8ePTj5ido" poster="705"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_video_player caption="Lesson 4." url="https://youtu.be/z_8ePTj5ido" poster="708"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player caption="Lesson 2." url="https://youtu.be/z_8ePTj5ido" poster="706"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_video_player caption="Lesson 5." url="https://youtu.be/z_8ePTj5ido" poster="709"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_video_player caption="Lesson 3." url="https://youtu.be/z_8ePTj5ido" poster="707"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_video_player caption="Lesson 6." url="https://youtu.be/z_8ePTj5ido" poster="710"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498244211676{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498244312933{padding-bottom: 160px !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column width="1/2"][ut_header align="left" title="<b>Drop</b> us a line."]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#393c3e" text_color="#393c3e" text_color_hover="#0267c1"][vc_custom_heading text="Follow us" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_social_follow gap="40 Pixel" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#393c3e" icon_color_hover="#0267c1"][/vc_column][vc_column width="1/2"][contact-form-7 id="5" title="Contact Page"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - CTA Section Image BG', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - CTA Section Blue', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498241105883{padding-bottom: 120px !important;background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people.</b>" title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)" button_border_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Get in Touch Section Image BG', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_overlay="true" css=".vc_custom_1498243386794{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/demo-3-hero.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.8)"][vc_row][vc_column animate_once="yes" delay="true" effect="none" delay_timer="50"][ut_header align="center" title="Get in touch with <b>Brooklyn.</b>" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Any Question at" headline_margin_bottom="0px" imageicon="872"]1-8456-563-BKLYN[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="1399 Beverley Rd" headline_margin_bottom="0px" imageicon="877"]Brooklyn, NY 11218[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Monday - Saturday" headline_margin_bottom="0px" imageicon="348"]8 am â€“ 8 pm[/ut_service_column][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column shape="round" headline_color="#ffffff" text_color="#ffffff" color="#ffffff" background="#0267c1" headline="Send your mail at" headline_margin_bottom="0px" imageicon="875"]contact@yourdomain.com[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Responsive Pricing Tables Section', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1497478235653{border-bottom-width: 1px !important;background-color: #f7f8fa !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}"][vc_row][vc_column][ut_header align="center" title="<b>Brooklyn</b> will make you
more proud of your business.
"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true"][vc_column width="1/3" css=".vc_custom_1497386709133{padding-right: 0px !important;}"][ut_pricing_table image_spacing="true" right_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386713284{padding-right: 0px !important;padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][vc_column width="1/3" css=".vc_custom_1497386720370{padding-left: 0px !important;}"][ut_pricing_table image_spacing="true" left_border="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_border_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" hide_on_desktop="true"][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Starter" subheadline="Get Brooklyn" price="39" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1174" button_text_color_hover="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_border_color_hover="#393c3e" price_font_color="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" popular="true" shadow="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Most Popular" subheadline="Get Brooklyn" price="59" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" price_font_color="#393c3e" image="970" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][vc_column width="1/3" offset="vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_pricing_table image_spacing="true" headline_font_size="24" button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="1" price_font_size="60" price_line_height="150" features="%5B%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Beautiful%20Demos%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E115%2B%3C%2Fb%3E%20Page%20Templates%22%7D%5D" headline="Power User" subheadline="Get Brooklyn" price="79" currency="$" period="one time fee" button="url:%23|||" button_text="Choose Plan" button_link="url:%23|||" border_color="#dddddd" button_text_color="#ffffff" button_background="#0267c1" image="1175" price_font_color="#393c3e" button_background_hover="rgba(2,103,193,0)" button_border_color="#0267c1" button_text_color_hover="#393c3e" button_border_color_hover="#393c3e"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Ken Tomita', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Ken <b>Tomita.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption_below="yes" animate_once="yes" delay_animation="true" gallery="1174,1175,970,958"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Ken Tomita" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Startup Stock Photos', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Startup <b>Stock Photos.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498128561470{padding-top: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_gallery_slider type="carousel" number="4" number_tablet="4" dots="true" caption="on" hover_caption="on" slides="1743,1085,1742,1739" hover_caption_color="#ffffff"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Startup Stock Photos" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums![/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Damian Dulisz', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Damian <b>Dulisz.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498128561470{padding-top: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_gallery_slider type="carousel" number="2" number_tablet="2" dots="true" hover_caption="on" slides="1743,1085,1742,1739" hover_caption_color="#ffffff"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" avatar="186" title="Awesome Flexibility" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums![/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Wilfred Iven', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Wilfred <b>Iven.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498130245047{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="large" grid="3" caption="yes" gallery="1774,1085,1739,1742,1743,1766" css=".vc_custom_1498203181334{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Benjamin Child', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Benjamin <b>Child.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" caption="yes" gallery="1774,1085,1739,1742,1743,1766"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Alesia Kazantceva', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Alesia <b>Kazantceva.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="3" gap="40" caption_below="yes" gallery="1774,1085,1739,1742,1743,1766"][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" avatar="186" title="<b>Design</b> Quality" author="DerMoki" company="Brooklyn Customer" rating_color="#fec42d"]This is the best Theme i have every used! Brooklyn is very Simple to use (a highlight for new Customers) and comes with big Content ! Thanks to UnitedThemes for this Theme and the good Support on your Forums!
[/ut_single_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Negative Space 2', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Negative <b>Space 2.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22June%2022%2C%202017%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="In a world of over 1 billion websites,
<b>does your website stand out?</b>"]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" caption="yes" caption_below="yes" gallery="1774,1085,1739,1742,1743,1766"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 03 - Portfolio Negative Space', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498078646614{background-color: #0267c1 !important;}"][vc_row][vc_column][ut_header align="center" title="Negative <b>Space.</b>" title_color="#ffffff" lead_color="rgba(255,255,255,0.8)"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22Client%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22Date%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%7D%2C%7B%22title%22%3A%22Project%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#ffffff" description_color="rgba(255,255,255,0.8)" description_link_color="#ffffff" description_link_hover_color="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and building
<b>brands</b> that truly matter <b>to people.</b>"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption="yes" caption_below="yes" gallery="1774,1739,1743,1766,1742,1085"][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_progress_circle percent="97" percent_font_weight="bold" title_text_font="on" stroke_width="4" title="Web Design"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|font_size:15px|text_align:center|line_height:30px" use_theme_fonts="yes"][/vc_column][vc_column width="1/3"][ut_progress_circle percent="91" percent_font_weight="bold" title_text_font="on" stroke_width="4" title="Web Development"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|font_size:15px|text_align:center|line_height:30px" use_theme_fonts="yes"][/vc_column][vc_column width="1/3"][ut_progress_circle percent="100" percent_font_weight="bold" title_text_font="on" stroke_width="4" title="Customer Support"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|font_size:15px|text_align:center|line_height:30px" use_theme_fonts="yes"][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="Share:" icon_color="#393c3e" border_color="#dddddd"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498081358858{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo3/wp-content/uploads/2017/06/portfolio-1-cta.jpeg?id=1742) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header align="center" title="<b>Creating</b> ideas and <b>building</b>
<b>brands</b> that truly matter to <b>people</b>." title_color="#ffffff" lead_color="#ffffff"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_custom_border="yes" button_border_width="2" button_text="Purchase Now" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="rgba(255,255,255,0.5)"][/vc_column][/vc_row][/vc_section]',

        ),
        
        /* Demo5 */
        array(
            'name'      => esc_html__( 'Demo 05 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="About"][vc_row][vc_column][ut_header title="Creative Solutions And
Results That Grow Brands"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="3350" css=".vc_custom_1499437093751{margin-bottom: 10px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1499439833942{background-color: #f9f9fa !important;}"][vc_column][ut_header title="Brooklyn Designs Are The
Gasoline To Boost Your Website"]With your purchase you will get all
the demos you can find on this page.[/ut_header][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="2/3"][rev_slider alias="about"][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column_vertical align="left" imageicon="3797" headline="Brooklyn 2017"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily.[/ut_service_column_vertical][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_position="after" icon_animation="yes" link="url:%23|title:More%20Information||" icon_fontawesome="fa fa-chevron-circle-right" link_color="#222222" link_color_hover="#222222" icon_color="#0674ec" icon_color_hover="#0674ec" css=".vc_custom_1499447497957{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: #dddddd !important;border-top-style: solid !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1499467299722{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo5/wp-content/uploads/2017/07/1.jpg?id=3908) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.5)"][vc_column][ut_header title_color="#ffffff" lead_color="#ffffff" title="We’ll Design Experiences,
We Do Not Copy Them"]Each completed project makes us even more hungry.[/ut_header][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Team"][vc_row][vc_column][ut_header title="We Work For Your Success"]We believe in a diverse range of personel to bring
creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member icon_size="20" avatar="3908" name="John" occupation="FOUNDER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" icon_color_hover="#0674ec" icon_color="#dddddd"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. [/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="20" avatar="3908" name="Dwayne" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" icon_color_hover="#0674ec" icon_color="#dddddd"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. [/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member icon_size="20" avatar="3908" name="Jeff" occupation="DEVELOPER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" icon_color_hover="#0674ec" icon_color="#dddddd"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. [/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1499467259283{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo5/wp-content/uploads/2017/07/1.jpg?id=3908) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.5)"][vc_column][ut_header title="Our Glorious Achievements" title_color="#ffffff" lead_color="#ffffff"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][vc_row_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Flying-Rocket" to="20" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"] Themes Released [/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Clock-1" to="40000" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"]Working Hours[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Mustache-1" to="42758" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"]Sales[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="uppercase" caption_font_weight="normal" icon_bklyn="BklynIcons-Office-Desk-2" to="14000" color="#ffffff" counter_color="#ffffff" desccolor="#ffffff"]Community Members[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Services"][vc_row][vc_column][ut_header title="Our Services"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline="APP Development" imageicon="3800" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="Web Development" imageicon="3796" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="UI Design" imageicon="3801" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline="Brand &amp; Identity" imageicon="3799" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="Consultancy" imageicon="3798" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="Marketing" imageicon="3797" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. [/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Work" css=".vc_custom_1499448003957{background-color: #f9f9fa !important;}"][vc_row][vc_column][ut_header align="center" lead_accent_font_weight="bold" title="Our Awesome Work" lead_accent_color="#151515"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="45" css=".vc_custom_1499447992640{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499447952921{padding-bottom: 160px !important;}"][vc_row][vc_column][ut_header align="center" lead_accent_font_weight="bold" title="Get connected" lead_accent_color="#151515"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-facebook" title="Facebook" slogan="JOIN THE CONVERSATION" icon_hover_color="#222222"][/vc_column][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-twitter" title="Twitter" slogan="FOLLOW US ON TWITTER" icon_hover_color="#222222"][/vc_column][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-behance" title="Behance" slogan="SEE OUR LATEST WORK" icon_hover_color="#222222"][/vc_column][vc_column width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" icon="fa fa-instagram" title="Instagram" slogan="LATEST IMAGES" icon_hover_color="#222222"][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1499467273702{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo5/wp-content/uploads/2017/07/1.jpg?id=3908) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.5)"][vc_column][ut_twitter_rotator avatar="on" tweet_font_weight="" tweet_date_font_weight="normal" count="3" tweet_text_color="#ffffff" tweet_link_color="rgba(255,255,255,0.5)" tweet_date_color="#ffffff" tweet_font_size="35px" tweet_link_color_hover="#ffffff" arrow_color_hover="#ffffff" arrow_bg_color="rgba(20,22,24,0.3)" arrow_bg_color_hover="#141618"][/vc_column][/vc_row][vc_row][vc_column][ut_header title="Let\'s Get In Touch"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#0674ec" text_color_hover="#0674ec"][/vc_column][/vc_row][vc_row][vc_column width="1/2" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][contact-form-7 id="32"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 05 - Portfolio Slide-Up Template', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Gira o Mundo" title_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#222222"][/vc_column][/vc_row][/vc_section]',
        ),
        
        
        
         /* Demo 7 */
        array(
            'name'      => esc_html__( 'Demo 07 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about"][vc_row][vc_column][ut_header title="We\'re Brooklyn Studio"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Care." imageicon="278" link="|||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Deliver." imageicon="279"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We\'re Creative." imageicon="280"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498576913558{padding-top: 80px !important;padding-bottom: 40px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-1.jpg?id=233) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column width="1/4"][ut_number_counter icon_spacing="20" sep="true" caption_text_transform="capitalize" caption_font_weight="" to="3" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"]Co-Worker[/ut_number_counter][/vc_column][vc_column width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="capitalize" caption_font_weight="" to="75" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"]Projects Delivered[/ut_number_counter][/vc_column][vc_column width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="capitalize" caption_font_weight="" to="30" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"]Satisfied Clients[/ut_number_counter][/vc_column][vc_column width="1/4"][ut_number_counter icon_spacing="20" caption_text_transform="capitalize" caption_font_weight="" to="7" color="#fe7e17" counter_color="#ffffff" desccolor="#ffffff"] Winning Design Awards[/ut_number_counter][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team"][vc_row][vc_column][ut_header title="We Work for Your Success"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="682" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="682"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="682" name="John Brooklyn" occupation="Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="682"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498665096798{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/parallax-quote.jpg?id=488) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="UNITED THEMES™" cite_color="#ffffff"]Passion leads to design, design leads to performance,
performance leads to <ins>success!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work" css=".vc_custom_1498592522231{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="88" css=".vc_custom_1498592487970{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1498592544977{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="GlyphConcepts" cite_color="#ffffff"]Love the whole theme and it’s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_section_anchor_id="services" css=".vc_custom_1498599149863{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-2.jpg?id=271) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header style="pt-style-2" title="New Opportunities for You" title_color="#ffffff" accent="#ff3f00" lead_color="rgba(255,255,255,0.8)"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498579577327{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="310" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498599257629{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="311" headline="Mobile Apps" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498579586124{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="312" headline="Design" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="pricing"][vc_row][vc_column][ut_header style="pt-style-2" title="Choose your Plan Today" accent="#fe7e17"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Basic" subheadline="Classic Plan" price="39" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="682" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table popular="true" shadow="true" headline_font_size="18" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Premium" subheadline="The Best Choice" price="59" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#ff3f00" subheadline_text_color="#ffffff" headline_text_color="#ffffff" header_background="#ff3f00" period_text_color="#ff3f00" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#ff3f00" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Professional" subheadline="Unlimited Features" price="79" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="testimonials"][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498698348768{padding-top: 200px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/1.jpg?id=679) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Amazing theme - just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them." font_container="tag:div|font_size:25px|text_align:left|color:%23ffffff|line_height:40px" google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_column_text css=".vc_custom_1498689468207{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"]<span style="color: #ffffff;">CodeBound,</span> <span style="color: #dddddd;">ThemeForest Customer</span>[/vc_column_text][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#dddddd" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" align="center" title="Trusted by Amazing Brands"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1498652254167{margin-top: 40px !important;padding-top: 80px !important;background-color: #ff3f00 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="68" css=".vc_custom_1498604678036{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="71" css=".vc_custom_1498604682609{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="70" css=".vc_custom_1498604686441{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Learn More" button_link="url:%23|||" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Beautiful Handmade Watch Design', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Beautiful Handmade Watch Design"]I believe my work speaks for itself. Browse my most recent projects below
and enjoy my handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_image_gallery thumbnail_size="full" gap="40" gallery="413,414,415"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22June%20%2027%2C%202017%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Front Page App', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about"][vc_row equal_height="yes" content_placement="middle" hide_on_mobile="true"][vc_column width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" image="615" effect="fadeInUp" css=".vc_custom_1498688135225{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2"][ut_header align="left" title="We\'re Brooklyn Studio" font_size="40px"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Get in touch with us" button_link="url:%23contact-section||target:%20_blank|" button_text_color="#252525" button_background="#ffffff" button_text_color_hover="#ff3f00" button_background_hover="#ffffff" button_border_color="#ff3f00" button_border_color_hover="#ff3f00"][/vc_column][/vc_row][vc_row hide_on_desktop="true" hide_on_tablet="true"][vc_column width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" image="615" effect="fadeInUp"][/vc_column][vc_column width="1/2"][ut_header align="left" title="We\'re Brooklyn Studio"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Get in touch with us" button_link="url:%23contact-section||target:%20_blank|" button_text_color="#252525" button_background="#ffffff" button_text_color_hover="#ff3f00" button_background_hover="#ffffff" button_border_color="#ff3f00" button_border_color_hover="#ff3f00"][/vc_column][/vc_row][vc_row css=".vc_custom_1498685512018{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Care." imageicon="588" link="|||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Deliver." imageicon="589" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We\'re Creative." imageicon="590" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team"][vc_row][vc_column][ut_header title="We Work for Your Success"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498665096798{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/parallax-quote.jpg?id=488) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="UNITED THEMES™" cite_color="#ffffff"]Passion leads to design, design leads to performance,
performance leads to <ins>success!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work" css=".vc_custom_1498592522231{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="88" css=".vc_custom_1498592487970{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1498592544977{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="GlyphConcepts" cite_color="#ffffff"]Love the whole theme and it’s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_section_anchor_id="services" css=".vc_custom_1498599149863{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-2.jpg?id=271) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header style="pt-style-2" title="New Opportunities for You" title_color="#ffffff" accent="#ff3f00" lead_color="rgba(255,255,255,0.8)"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498579577327{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="310" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498599257629{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="311" headline="Mobile Apps" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498579586124{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="312" headline="Design" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="pricing"][vc_row][vc_column][ut_header style="pt-style-2" title="Choose your Plan Today" accent="#fe7e17"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Basic" subheadline="Classic Plan" price="39" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table popular="true" shadow="true" headline_font_size="18" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Premium" subheadline="The Best Choice" price="59" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#ff3f00" subheadline_text_color="#ffffff" headline_text_color="#ffffff" header_background="#ff3f00" period_text_color="#ff3f00" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#ff3f00" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Professional" subheadline="Unlimited Features" price="79" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="testimonials"][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498698522157{padding-top: 200px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/1.jpg?id=679) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Amazing theme - just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them." font_container="tag:div|font_size:25px|text_align:left|color:%23ffffff|line_height:40px" google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_column_text css=".vc_custom_1498689855594{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"]<span style="color: #ffffff;">CodeBound,</span> <span style="color: #dddddd;">ThemeForest Customer</span>[/vc_column_text][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#dddddd" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" align="center" title="Trusted by Amazing Brands"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1498652254167{margin-top: 40px !important;padding-top: 80px !important;background-color: #ff3f00 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="68" css=".vc_custom_1498604678036{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="71" css=".vc_custom_1498604682609{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="70" css=".vc_custom_1498604686441{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Learn More" button_link="url:%23|||" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Front Page Orange Style', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about" css=".vc_custom_1498690902010{background-color: #ff3f00 !important;}"][vc_row][vc_column][ut_header title="We\'re Brooklyn Studio" title_color="#ffffff" lead_color="#ffffff" font_size="50px"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Care." imageicon="588" link="|||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We Deliver." imageicon="589" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical align="left" headline="We\'re Creative." imageicon="590" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team"][vc_row][vc_column][ut_header title="We Work for Your Success"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="682" name="John Brooklyn" occupation="CEO / Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Developer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" line_width="1" line_style="dotted" avatar="679" name="John Brooklyn" occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#ff3f00" icon_color="#252525" icon_color_hover="#ff3f00" line_color="#dddddd" avatar_alternate="679"][/ut_team_member][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498665096798{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/parallax-quote.jpg?id=488) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="UNITED THEMES™" cite_color="#ffffff"]Passion leads to design, design leads to performance,
performance leads to <ins>success!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work" css=".vc_custom_1498592522231{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header title="Our Work"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="88" css=".vc_custom_1498592487970{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row css=".vc_custom_1498592544977{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_text_transform="capitalize" quote_color="#ffffff" quote_ins_color="#ff3f00" cite="GlyphConcepts" cite_color="#ffffff"]Love the whole theme and it’s function. Also kudos to the support as well. Very reliable. Answers all your question and help you outright.[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_section_anchor_id="services" css=".vc_custom_1498599149863{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/portfolio-2.jpg?id=271) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_row][vc_column][ut_header style="pt-style-2" title="New Opportunities for You" title_color="#ffffff" accent="#ff3f00" lead_color="rgba(255,255,255,0.8)"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/3" css=".vc_custom_1498579577327{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="310" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498599257629{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="311" headline="Mobile Apps" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3" css=".vc_custom_1498579586124{background-color: #ffffff !important;}"][ut_service_column_vertical icon_margin_bottom="40" imageicon="312" headline="Design" link="url:%23|title:Learn%20More||"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="pricing"][vc_row][vc_column][ut_header style="pt-style-2" title="Choose your Plan Today" accent="#fe7e17"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Basic" subheadline="Classic Plan" price="39" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table popular="true" shadow="true" headline_font_size="18" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Premium" subheadline="The Best Choice" price="59" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#ff3f00" subheadline_text_color="#ffffff" headline_text_color="#ffffff" header_background="#ff3f00" period_text_color="#ff3f00" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#ff3f00" button_border_color_hover="#252525"][/vc_column][vc_column width="1/3"][ut_pricing_table shadow="true" button_border_radius="4" button_custom_border="yes" button_border_width="2" font_weight="bold" price_font_size="60" headline="Professional" subheadline="Unlimited Features" price="79" currency="$" period="one time fee" features="%5B%7B%22feature%22%3A%22%3Cb%3E27%2B%3C%2Fb%3E%20Demos%20Ready%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E148%2B%3C%2Fb%3E%20Page%20Templates%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3E40%2B%3C%2Fb%3E%20Design%20Module%20%22%7D%2C%7B%22feature%22%3A%22%3Cb%3EPower%3C%2Fb%3E%20Elite%20Support%20%22%7D%5D" image="679" border_color="#dddddd" button_text="Choose Plan" button_background="#ffffff" price_font_color="#252525" button_text_color="#252525" button_text_color_hover="#ffffff" button_background_hover="#252525" button_border_color="#252525" button_border_color_hover="#252525"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="testimonials"][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1498701333383{padding-top: 200px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo7/wp-content/uploads/2017/06/1.jpg?id=679) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Amazing theme - just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them." font_container="tag:div|font_size:25px|text_align:left|color:%23ffffff|line_height:40px" google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_column_text css=".vc_custom_1498690660030{margin-top: 20px !important;border-top-width: 1px !important;padding-top: 20px !important;border-top-color: rgba(255,255,255,0.1) !important;border-top-style: solid !important;}"]<span style="color: #ffffff;">CodeBound,</span> <span style="color: #dddddd;">ThemeForest Customer</span>[/vc_column_text][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#dddddd" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" align="center" title="Trusted by Amazing Brands"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1498652254167{margin-top: 40px !important;padding-top: 80px !important;background-color: #ff3f00 !important;}"][vc_column][vc_row_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="68" css=".vc_custom_1498604678036{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="71" css=".vc_custom_1498604682609{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/3"][ut_animated_image size="full" align="center" image="70" css=".vc_custom_1498604686441{margin-bottom: 0px !important;}"][ut_service_column_vertical text_color="rgba(255,255,255,0.9)" headline_margin_bottom="0px"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-small" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Learn More" button_link="url:%23|||" button_text_color="#ffffff" button_background="rgba(255,255,255,0)" button_border_color="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Portfolio Become Legend with Brooklyn', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498684861282{padding-bottom: 0px !important;}"][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" image="570" css=".vc_custom_1498684302697{margin-bottom: 0px !important;}" effect="fadeInUp"][/vc_column][vc_column width="1/2"][ut_header align="left" title="Become Legend
with Brooklyn"]We have created an awesome theme that will help designers, developers, and companies create websites for their startups quickly and easily. [/ut_header][ut_btn button_size="bklyn-btn-small" button_align="bklyn-btn-left" button_border_radius="4" button_custom_border="yes" button_border_width="2" button_text="Download Brooklyn" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179%3Fref%3DUnitedThemes||target:%20_blank|" button_text_color="#ff3f00" button_background="#ffffff" button_text_color_hover="#252525" button_background_hover="#ffffff" button_border_color="#ff3f00" button_border_color_hover="#252525"][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][vc_row css=".vc_custom_1498684036134{margin-top: 0px !important;background-color: #ff3f00 !important;}"][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" imageicon="567" headline="Web Dev" link="url:%23|title:Learn%20More|target:%20_blank|" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" imageicon="568" headline="Mobile Apps" link="url:%23|title:Learn%20More||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" imageicon="569" headline="Design" link="url:%23|title:Learn%20More||" headline_color="#ffffff" text_color="rgba(255,255,255,0.7)" link_color="#ffffff" link_hover_color="rgba(255,255,255,0.7)"]Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium.[/ut_service_column_vertical][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1498684454560{margin-top: 0px !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="4" caption="yes" animate_once="yes" gallery="680,681,682,679" effect="zoomIn" css=".vc_custom_1498697985788{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Portfolio Friends Make The World A Better Place', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Friends Make The
World A Better Place"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22June%20%2027%2C%202017%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption="yes" caption_content="plus" caption_below="yes" gallery="682,681,680,679" caption_below_color="#252525"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 07 - Portfolio Tablet Smartcover Design', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Tablet Smartcover Design"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22June%20%2027%2C%202017%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Step 1" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Step 2" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="full" grid="3" gap="40" caption="yes" gallery="289,290,291" caption_color="#ffffff" caption_background="rgba(255,63,0,0.9)"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Step 3" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Finally" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_image_gallery thumbnail_size="full" caption_below="yes" gallery="287" caption_below_color="#252525"][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#252525"][/vc_column][/vc_row][/vc_section]',

        ),
                
        /* Demo 8 - Extended */
        array(
            'name'      => esc_html__( 'Demo 08 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" bklyn_section_anchor="true" css=".vc_custom_1477967744445{margin-bottom: 0px !important;padding-top: 120px !important;padding-bottom: 0px !important;background-color: #ffffff !important;}" bklyn_section_anchor_id="About Brooklyn"][vc_column css=".vc_custom_1477390682192{padding-top: 0px !important;}"][vc_row_inner css=".vc_custom_1477586581339{padding-top: 0px !important;}"][vc_column_inner css=".vc_custom_1477586586610{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="About Brooklyn" css=".vc_custom_1477970312956{margin-bottom: 60px !important;}" lead_accent_color="#252525"]We are a creative agency located in <ins>Brooklyn, New York.</ins>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInLeft" delay_timer="200"][ut_service_column shape="round" align="right" headline="APP DEVELOPMENT" icon="fa fa-cloud" color="#ffffff" background="#0cb4ce" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeInRight" delay_timer="200"][ut_service_column shape="round" headline="UI DESIGN" icon="fa fa-th-large" color="#ffffff" background="#151515" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477921839851{margin-top: 20px !important;}"][vc_column_inner effect="none"][ut_animated_image size="full" align="center" animate_once="yes" css=".vc_custom_1477999764728{margin-bottom: 0px !important;}" effect="none"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477971171664{margin-top: 0px !important;padding-top: 60px !important;padding-bottom: 60px !important;background-color: #080808 !important;}"][vc_column_inner css=".vc_custom_1477932362431{padding-top: 0px !important;}"][ut_fancy_link link_color="#e5e5e5" line_color="#666666" url="#contact-section" class="ut-scroll-to-section"]Get in touch with us![/ut_fancy_link][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" parallax="content-moving" parallax_image="4879" parallax_speed_bg="2.5" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" css=".vc_custom_1477999920085{padding-top: 200px !important;padding-bottom: 200px !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477932895246{padding-top: 0px !important;}"][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" quote_color="#ffffff" cite="United Themes – Theme Development Brooklyn" cite_color="#ffffff" icon="fa fa-quote-left" icon_color="#ffffff" quote_ins_color="#0cb4ce"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE, PERFORMANCE LEADS TO <ins>SUCCESS</ins>![/ut_parallax_quote][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477967893503{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #f9f9f9 !important;}" bklyn_section_anchor_id="Our Service"][vc_column css=".vc_custom_1477484140481{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415810648{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Our Services" css=".vc_custom_1477970318772{margin-bottom: 60px !important;}" lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <ins>know-how</ins> and <ins>experience</ins> in your <ins>daily business</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2"][ut_animated_image size="full" align="center" animate_once="yes" effect="zoomIn"][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column headline="RETINA READY &amp; RESPONSIVE" icon="fa fa-tablet" color="#252525" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="ONE CLICK DEMO INSTALLER" icon="fa fa-download" color="#252525" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][ut_service_column headline="DRAG &amp; DROP PAGE BUILDER" icon="fa fa-object-ungroup" color="#252525" headline_color="#252525" text_color="#666666"]Praesent faucibus nisl sit amet nulla sollicitudin
pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_section_anchor="true" css=".vc_custom_1477969135279{padding-top: 120px !important;padding-bottom: 0px !important;background-color: #ffffff !important;}" bklyn_section_anchor_id="Our Work"][vc_column css=".vc_custom_1477484344871{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477415836145{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="OUr Work" css=".vc_custom_1477970325105{margin-bottom: 60px !important;}" lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <ins>handmade work</ins> with love for every detail.[/ut_header][ut_custom_shortcode css=".vc_custom_1477491082574{margin-bottom: 0px !important;}"][ut_showcase id="4272"][/ut_custom_shortcode][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1477969388979{background-color: #ffffff !important;}"][vc_column_inner css=".vc_custom_1477922635866{padding-top: 0px !important;}"][ut_image_gallery thumbnail_size="full" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="4881,4879,4880,4867,4866" effect="zoomIn" css=".vc_custom_1477999799622{padding-top: 20px !important;padding-bottom: 20px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477969397873{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #f9f9f9 !important;}" bklyn_section_anchor_id="Clients"][vc_column css=".vc_custom_1477491736456{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="The Clients" css=".vc_custom_1477970331638{margin-bottom: 60px !important;}" lead_accent_color="#252525"]The comments below are just a sample of the <ins>22.500 clients</ins> worldwide
who transformed their business website with Brooklyn.[/ut_header][ut_qtrotator_2 quote_custom_font="yes" origin_font_weight="normal" name_color="#252525" origin_color="#0cb4ce" quote_color="#666666" arrow_color="#252525" arrow_color_hover="#0cb4ce" quote_font="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="17px" quote_line_height="27px"][ut_qt_2 author="RON SCHMIDT" avatar="4879" origin="BROOKLYN CUSTOMER" imageicon="4798"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point.

Really looking forward to the upcoming demos, United Themes, you guys do a great job!”[/ut_qt_2][ut_qt_2 author="JOHN AREUS" avatar="4879" origin="BROOKLYN CUSTOMER" imageicon="4799"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 author="HENRIK SCHWARZ" avatar="4879" origin="BROOKLYN CUSTOMER" imageicon="4800"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_section_anchor="true" css=".vc_custom_1477969403164{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #ffffff !important;}" bklyn_section_anchor_id="Team"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1477586544362{padding-top: 0px !important;}"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="The Crew" css=".vc_custom_1477970335684{margin-bottom: 60px !important;}" lead_accent_color="#252525"]We believe in a diverse range of personel to bring <ins>creative skills</ins>,
<ins>thoughts</ins>, and <ins>ideas</ins> to the table.
[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MARCEL M." occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo8%2Fteam-single-page-1%2F|||" line_color="#efefef" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="MATTHIAS N." occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0cb4ce" name_color="#252525" description_color="#666666" line_color="#efefef" icon_color="#252525" icon_color_hover="#0cb4ce" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo8%2Fteam-single-page-2%2F|||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member align="left" ocupation_font_weight="normal" name="Andreea B." occupation="SUPPORT" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0cb4ce" name_color="#252525" icon_color="#252525" icon_color_hover="#0cb4ce" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo8%2Fteam-single-page-3%2F|||" line_color="#efefef" description_color="#666666"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1477999870917{padding-top: 120px !important;padding-bottom: 80px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.7)"][vc_column css=".vc_custom_1477586797526{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="bold" title="WE ARE GOOD AT" css=".vc_custom_1477970341131{margin-bottom: 60px !important;}" lead_accent_color="#0cb4ce" lead_color="#e5e5e5" title_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a <ins>better web experience</ins>.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="95" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="Web Design" info_color="#e5e5e5" color="#0cb4ce" background_color="#81d742" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="98" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="HTML / CSS" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="96" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="WORDPRESS DEVELOPMENT" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="99" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="LOGO DESIGN" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar_thin width="97" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="PHP DEVELOPMENT" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar_thin width="100" animate_once="yes" percentage_bg_color_opacity="0" info_font_size="17" info_font_weight="" border_radius="30" info="CUSTOMER SUPPORT" info_color="#e5e5e5" color="#0cb4ce" percentage_color="#ffffff" percentage_bg_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477969841499{padding-top: 120px !important;padding-bottom: 120px !important;background-color: #ffffff !important;}"][vc_column css=".vc_custom_1477492103312{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Get Brooklyn Now" css=".vc_custom_1477970345989{margin-bottom: 60px !important;}" lead_accent_color="#252525"]Get yourself ready for an <ins>awesome experience</ins> with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner effect="none"][vc_column_inner effect="none"][vc_icon icon_fontawesome="fa fa-download" color="custom" size="xl" align="center" custom_color="#bbbbbb"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_weight="900" text_transform="uppercase" button_text="Buy Now" button_text_color="#ffffff" button_background="#252525" button_text_color_hover="#ffffff" button_background_hover="#0cb4ce"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477926378383{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 1" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933051608{margin-bottom: 10px !important;}"][ut_header align="left" title="Street View" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Porsche Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4881,4879,4880,4866"][/vc_column][/vc_row]',

        ),        
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" animate_once="yes" css=".vc_custom_1477934139431{padding-right: 30px !important;padding-left: 30px !important;}" effect="fadeIn"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 2" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477933233245{margin-bottom: 10px !important;}"][ut_header align="left" title="Running is a way of life" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Running for Kids" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_gallery_slider autoplay="true" loop="true" effect_in="fadeIn" effect_out="fadeOut" slides="4881,4879,4880,4866" arrow_color="#252525" arrow_color_hover="#ff6e00" dot_color="#252525" dot_color_hover="#ff6e00"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="top" css=".vc_custom_1477934526560{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 3" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477926125194{margin-bottom: 10px !important;}"][ut_header align="left" title="Winter Time" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Brooklyn in Winter" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_animated_image size="full" link_type="image" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477933557094{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="4879,4880"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1477675051837{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477934630458{margin-bottom: 10px !important;}"][ut_header align="left" lead_accent_font_weight="bold" title="Wake up and smell the coffee" title_color="#252525" lead_accent_color="#252525"]Flexibility starts with a colour! Our integrated colour picker lets you choose your desired one for several different elements to give your <ins>Brooklyn</ins> powered website and individual touch!

The art and technique of arranging type in order to make language visible. With our build in Font Manager you can give your website the final touch.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Wake Up" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="I like Coffee" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-two" background_position="center center" background_attachment="scroll" css=".vc_custom_1478000757055{margin-bottom: 120px !important;padding-top: 200px !important;padding-bottom: 200px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.3)"][vc_column][ut_parallax_quote quote_font_size="30" quote_line_height="40" quote_text_transform="uppercase" cite_text_transform="uppercase" icon="fa fa-quote-left" icon_color="#ffffff" quote_color="#ffffff" cite="Somebody" cite_color="#ffffff"]MORNING HAS BROKEN
AND THE COFFEE HAS SPOKEN[/ut_parallax_quote][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1477934909720{padding-top: 0px !important;}"][vc_custom_heading text="Start each day with a cup of positivity" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477934914183{padding-top: 0px !important;}"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477916391920{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935187461{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935014472{margin-bottom: 10px !important;}"][ut_header align="left" title="HAPPINESS IS SUN, SAND AND A DRINK IN MY HAND" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/2" css=".vc_custom_1477935191889{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477916398261{margin-bottom: 80px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935232537{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Take a silly selfie with your friends" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1477935236742{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" effect="fadeIn"][vc_custom_heading text="Salt in the air and sand in our hair" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column css=".vc_custom_1477935263955{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935030368{margin-bottom: 10px !important;}"][ut_header align="center" title="Each Demo looks different and can be imported in seconds!" title_color="#252525" css=".vc_custom_1477935035668{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="large" align="center" animate_once="yes" css=".vc_custom_1478000870163{margin-bottom: 60px !important;}" effect="fadeIn"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How we build this APP" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22App%20Development%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477925906808{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935336020{margin-bottom: 10px !important;}"][ut_header align="left" title="SENNHEISER HD 598" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="OVERVIEW" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Characteristics" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Sennheiser%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="4879,4880,4881"][ut_media_slider dots="false" slides="%5B%7B%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F76850650%22%2C%22poster%22%3A%224879%22%7D%5D"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row"][vc_column][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935419748{margin-bottom: 10px !important;}"][ut_header align="center" title="Just What You Need " title_color="#252525" css=".vc_custom_1477935468275{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1477505777253{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][vc_column width="1/2" css=".vc_custom_1475504625537{padding-left: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663877638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935429458{margin-bottom: 10px !important;}"][ut_header align="left" title="Endless Possibilities" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Create One-Page or Multi-Page websites easily by using the Visual Composer per Drag &amp; Drop or use shortcodes. It’s up to you!
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1478001052594{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1477663884237{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935605405{margin-bottom: 10px !important;}"][ut_header align="left" title="Powerful Admin Panel" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]That will cover all your basic needs! You don’t need to touch a single line of code, perfect for people without any coding knowledge. Individualize Layouts, Colours &amp; Styles within minutes.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1478001063529{margin-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo2b/wp-content/uploads/2016/11/1.jpg?id=4879) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477935536739{margin-bottom: 10px !important;}"][ut_header align="center" title="Thank You" title_color="#252525" css=".vc_custom_1477935532710{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="How We Work" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2026%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][ut_social_share_bar share_text="SHARE:" share_text_color="#252525" icon_color="#999999" border="true" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_media_slider dots="false" slides="%5B%7B%22title%22%3A%22Slide%201%22%2C%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fvimeo.com%2F10089801%22%2C%22poster%22%3A%224879%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Portfolio Style 8" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1477662215938{margin-bottom: 10px !important;}"][ut_header align="left" title="Hello Brooklyn" title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="2/3"][vc_custom_heading text="We love Brooklyn" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/3"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Team Single 1', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Marcel M." title_color="#252525"]Hello, Im Marcel Designer at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="MARCEL M." occupation="Designer" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing.[/vc_column_text][ut_probar_thin width="99" animate_once="yes" info_font_weight="" info="Project Management" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="97" animate_once="yes" info_font_weight="" info="Web Design" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1477939841961{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column css=".vc_custom_1477939807253{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_custom_heading text="my recent work" font_container="tag:h3|text_align:center|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][ut_custom_shortcode css=".vc_custom_1477939724912{margin-bottom: 0px !important;}"][ut_showcase id="4642"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477970707524{margin-bottom: 0px !important;background-color: #0cb4ce !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Team Single 2', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Matthias N." title_color="#252525"]Hello, Im Matthias Coder at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Matthias N." occupation="Coder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#ff6e00"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477930077660{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #080808 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 08 - Team Single 3', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1477937476431{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="left" title="Andreea B." title_color="#252525"]Hello, Im Andreea Support Guru at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" line_width="1" name="Andreea B." occupation="Support Guru" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name_color="#252525" icon_color="#252525" icon_color_hover="#0cb4ce"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="a little bit about me" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="PHP Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="95" animate_once="yes" info_font_weight="" info="jQuery Coding" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][ut_probar_thin width="98" animate_once="yes" info_font_weight="" info="Plugin Development" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1477970587402{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #0cb4ce !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',

        ),

        /* Demo 20 - Contruction */
        array(
            'name'      => esc_html__( 'Demo 20 - Abouts Us', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1469828450302{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Every Day We Fight!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469750459988{margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][ut_header title="Our history."]We are a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline_color="#333333" headline="1.) OUR RESPONSIBILITY"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline_color="#333333" headline="2.) OUR APPROACH"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="3.) OUR MISSION"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1469751518111{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="PAUL" avatar="236" occupation="Founder" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="KARL" avatar="237" occupation="Distribution" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TOM" avatar="238" occupation="Engineering" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="SANDRA" avatar="240" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner][vc_custom_heading text="We are brooklyn!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469751560802{margin-bottom: 10px !important;}"][ut_header title="Our famous team."]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="DIRK" avatar="245" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TARUN" avatar="243" occupation="Handy-Man" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1469828604740{margin-bottom: 80px !important;}"][vc_column][ut_parallax_quote quotation_marks="no" icon_border_radius="50" quote_font_source="websafe" quote_websafe_fonts="helvetica" quote_font_size="14" quote_line_height="50" quote_letter_spacing="10" quote_font_weight="bold" cite_font_source="websafe" cite_websafe_fonts="helvetica" cite_font_size="13" cite_font_weight="bold" cite_text_transform="uppercase" cite="United Themes" icon="fa fa-quote-left" icon_color="#ffffff" icon_background_color="#333333" quote_color="#333333" cite_color="#cccccc" css=".vc_custom_1469835516230{padding-top: 120px !important;padding-right: 40px !important;padding-bottom: 80px !important;padding-left: 40px !important;background-image: url() !important;background-position: 0 0 !important;background-repeat: repeat !important;}"]PASSION LEADS TO DESIGN,
DESIGN LEADS TO PERFORMANCE,
PERFORMANCE LEADS TO SUCCESS![/ut_parallax_quote][/vc_column][/vc_row][vc_row css=".vc_custom_1469829147655{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Our awesome partner!" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470091907220{margin-bottom: 10px !important;}"][ut_header align="center" title="Our partner."]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="263,262,259,264,267,268" effect="fadeIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1467823960306{margin-bottom: 60px !important;}"][vc_column width="1/2"][vc_custom_heading text="Company Information" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][vc_column_text]

    1399 Beverley Rd, Brooklyn, NY 11218
    547-589-663-BKLYN
    info@bklyn-construction.com

[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Send Us A Message" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_custom_shortcode][contact-form-7 id="5" title="Contact form 1"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][vc_gmaps link="#E-8_JTNDaWZyYW1lJTIwc3JjJTNEJTIyaHR0cHMlM0ElMkYlMkZ3d3cuZ29vZ2xlLmNvbSUyRm1hcHMlMkZlbWJlZCUzRnBiJTNEJTIxMW0xOCUyMTFtMTIlMjExbTMlMjExZDMwMjcuMzUwNDA5Mjg5ODQ0MyUyMTJkLTczLjk2ODEzMTg4Mzg0MjIlMjEzZDQwLjY0NDIwNTU0OTY5NTkzJTIxMm0zJTIxMWYwJTIxMmYwJTIxM2YwJTIxM20yJTIxMWkxMDI0JTIxMmk3NjglMjE0ZjEzLjElMjEzbTMlMjExbTIlMjExczB4ODljMjViM2EwOTcxYjgwZiUyNTNBMHg3MjRmNWZjODQ4ZGEyMmFhJTIxMnMxMzk5JTJCQmV2ZXJsZXklMkJSZCUyNTJDJTJCQnJvb2tseW4lMjUyQyUyQk5ZJTJCMTEyMTglMjUyQyUyQlVTQSUyMTVlMCUyMTNtMiUyMTFzZGUlMjEyc2RlJTIxNHYxNDY3Mzg5NzEyODY3JTIyJTIwd2lkdGglM0QlMjI4MDAlMjIlMjBoZWlnaHQlM0QlMjI2MDAlMjIlMjBmcmFtZWJvcmRlciUzRCUyMjAlMjIlMjBzdHlsZSUzRCUyMmJvcmRlciUzQTAlMjIlMjBhbGxvd2Z1bGxzY3JlZW4lM0UlM0MlMkZpZnJhbWUlM0U=" size="400" css=".vc_custom_1467389937342{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467792854469{margin-bottom: 0px !important;background-color: #141414 !important;}"][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-phone" color="#0a0d1b" background="#f1c40f" headline="Any Question at" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-home" color="#0a0d1b" background="#f1c40f" headline="1399 Beverley Rd" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-clock-o" color="#0a0d1b" background="#f1c40f" headline="Mon-Sat" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-envelope-o" color="#0a0d1b" background="#f1c40f" headline="Send your mail at" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',
        ),
        array(
            'name'       => esc_html__( 'Demo 20 - Front Page', 'ut_shortcodes' ),
            'content'    => '[vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1467669204375{margin-bottom: 120px !important;}"][vc_column width="1/3"][ut_service_icon_box icon="fa fa-bluetooth" headline="Building" css=".vc_custom_1467851491149{margin-bottom: 0px !important;padding-top: 100px !important;padding-right: 100px !important;padding-bottom: 100px !important;padding-left: 100px !important;background-color: #f1c40f !important;}" headline_color="#0a0d1b" text_color="#322803" imageicon="268" color="#0a0d1b" hovercolor="#0a0d1b"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.[/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box icon="fa fa-shopping-basket" headline="Renovation" css=".vc_custom_1467669190944{margin-bottom: 0px !important;padding-top: 100px !important;padding-right: 100px !important;padding-bottom: 100px !important;padding-left: 100px !important;background-color: #0a0d1b !important;}" headline_color="#f1c40f" text_color="#ffffff" imageicon="276" color="#f1c40f" hovercolor="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.[/ut_service_icon_box][/vc_column][vc_column width="1/3"][ut_service_icon_box icon_color="#ffffff" headline="Demolition" css=".vc_custom_1467851496502{margin-bottom: 0px !important;padding-top: 100px !important;padding-right: 100px !important;padding-bottom: 100px !important;padding-left: 100px !important;background-color: #f1c40f !important;}" imageicon="278" color="#0a0d1b" hovercolor="#0a0d1b" headline_color="#0a0d1b" text_color="#322803"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.[/ut_service_icon_box][/vc_column][/vc_row][vc_row full_width="stretch_row"][vc_column][ut_header style="pt-style-2" align="left" title="Build Your House With Us!" font_size="24px"]Building energy efficient, comfortable and affordable homes for Americas families is at the heart of what we do at Brooklyn Construction.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1467468867642{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

[/vc_column_text][vc_custom_heading text="Karl Hoffmann" font_container="tag:h3|font_size:18px|text_align:left" google_fonts="font_family:Yellowtail%3Aregular|font_style:400%20regular%3A400%3Anormal" text_transform="capitalize" css=".vc_custom_1467774325360{margin-bottom: 10px !important;}"][vc_column_text]Karl Hoffmann
Founder of Brooklyn Homes[/vc_column_text][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-calculator" headline="Concept Stage" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-clock-o" headline="Building Agreement" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-book" headline="Contract Signing" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column icon="fa fa-building-o" headline="Construction" color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_single_image img_size="full" alignment="center" css=".vc_custom_1467914703954{margin-bottom: 0px !important;}"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467654749069{background-color: #0a0d1b !important;}"][vc_column][ut_header style="pt-style-2" align="left" title="Our Latest Projects" title_color="#ffffff" lead_color="#999999"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column css=".vc_custom_1467421758161{padding-top: 0px !important;}"][ut_custom_shortcode css=".vc_custom_1467654281838{margin-bottom: 0px !important;}"][ut_showcase id="139"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467727601702{margin-bottom: 120px !important;background-color: #0a0d1b !important;}"][vc_column css=".vc_custom_1467421758161{padding-top: 0px !important;}"][ut_cta button_size="bklyn-btn-mini" button_align="bklyn-btn-right" button_border_width="2" headline="View All Projects" headline_color="#f1c40f" button_link="url:|||" button_custom_border="true" button_custom_font="true" text_color="#ffffff" button_text="All Projects" button_border_color="#ffffff" button_border_color_hover="#ffffff" button_text_color="#ffffff" button_text_color_hover="#0a0d1b" button_font="font_family:ABeeZee%3Aregular%2Citalic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1467851397184{margin-bottom: 0px !important;}" button_background_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_cta][/vc_column][/vc_row][vc_row css=".vc_custom_1467823085426{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1467822966158{padding-top: 0px !important;}"][ut_header style="pt-style-2" align="center" title="What our customers say" css=".vc_custom_1467851100514{padding-top: 0px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" author="Mr. Smith" avatar="2730" company="Smith & Sons" title="Feature Availability" date="2016 / May / 12"]As a graphic designer, I love Brooklyn for its flexibility and with Nevada as a supplement I give United Theme 10 points![/ut_single_quote][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" author="Mr. Smith" avatar="2731" company="Smith & Sons" title="Design Quality" date="2016 / Juli / 4"]This is basically a FLAWLESS THEME. Demo’s are amazing and SUPER easy to incorporate. 10/10/ A+++ Please keep up the excellent quality work!![/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467850753702{margin-bottom: 0px !important;background-color: #0a0d1b !important;}"][vc_column css=".vc_custom_1467421758161{padding-top: 0px !important;}"][ut_cta button_size="bklyn-btn-mini" button_align="bklyn-btn-right" button_border_width="2" headline="Our Services" headline_color="#f1c40f" button_link="url:|||" button_custom_border="true" button_custom_font="true" text_color="#ffffff" button_text="Services" button_border_color="#ffffff" button_border_color_hover="#ffffff" button_text_color="#ffffff" button_text_color_hover="#0a0d1b" button_font="font_family:ABeeZee%3Aregular%2Citalic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1467851385245{margin-bottom: 0px !important;}" button_background_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_cta][/vc_column][/vc_row][vc_row full_width="stretch_row" full_height="yes" content_placement="middle" parallax="content-moving" parallax_image="577" css=".vc_custom_1467849716200{margin-bottom: 120px !important;padding-top: 300px !important;padding-bottom: 300px !important;}" bklyn_overlay="true" bklyn_overlay_color="rgba(10,13,27,0.7)"][vc_column][ut_header style="pt-style-2" title="We Build Your Dream Home!" title_color="#ffffff" font_size="70px"][/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1467727107493{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1467727608044{padding-top: 0px !important;}"][ut_header style="pt-style-2" align="global" title="Use Our Advantages" css=".vc_custom_1467851093528{padding-top: 0px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Save Energy" font_container="tag:h3|text_align:left" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css=".vc_custom_1467586873742{margin-bottom: 15px !important;}"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Construction and equipment" font_container="tag:h3|text_align:left" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css=".vc_custom_1467496631188{margin-bottom: 15px !important;}"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Worry-free service" font_container="tag:h3|text_align:left" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css=".vc_custom_1467496634742{margin-bottom: 15px !important;}"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1467836956429{margin-bottom: 80px !important;}"][vc_column][vc_text_separator title="Our Clients" color="custom" accent_color="#ededed" css=".vc_custom_1467852666460{margin-bottom: 0px !important;}"][vc_row_inner][vc_column_inner][ut_client_group carousel="true" deco_line_color="#ffffff" deco_line_color_top="#ffffff" deco_line_color_bottom="#ededed"][ut_client logo="404"][ut_client logo="407"][ut_client logo="411"][ut_client logo="405"][ut_client logo="401"][ut_client logo="409"][/ut_client_group][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467836947041{margin-bottom: 0px !important;background-color: #141414 !important;}"][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-phone" color="#0a0d1b" background="#f1c40f" headline="Any Question at" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-home" color="#0a0d1b" background="#f1c40f" headline="1399 Beverley Rd" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-clock-o" color="#0a0d1b" background="#f1c40f" headline="Mon-Sat" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-envelope-o" color="#0a0d1b" background="#f1c40f" headline="Send your mail at" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Service Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1467781577280{margin-bottom: 40px !important;}"][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Design and Plans" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Groundworks and Contract Brickwork" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="New Builds" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1467781584262{margin-bottom: 40px !important;}"][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Alterations" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Extensions" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Electrical & Plumbing" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1467781600019{margin-bottom: 40px !important;}"][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Plastering" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Kitchens" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Bathrooms" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1467781607831{margin-bottom: 80px !important;}"][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Painting & Decorating" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Steelwork" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/3"][vc_single_image img_size="full" alignment="center"][vc_custom_heading text="Hard Landscaping" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467781265964{margin-bottom: 0px !important;background-color: #141414 !important;}"][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-phone" color="#0a0d1b" background="#f1c40f" headline="Any Question at" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-home" color="#0a0d1b" background="#f1c40f" headline="1399 Beverley Rd" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-clock-o" color="#0a0d1b" background="#f1c40f" headline="Mon-Sat" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-envelope-o" color="#0a0d1b" background="#f1c40f" headline="Send your mail at" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Team Member', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_header style="pt-style-2" align="global" title="Team Member Style 1" font_size="30px"][/ut_header][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Base Layout" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467783739808{margin-bottom: 40px !important;}"][vc_column width="1/4"][ut_team_member align="left" name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467788799558{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][vc_text_separator title="Text Align Center" color="custom" accent_color="#ededed"][vc_row_inner][vc_column_inner width="1/4"][ut_team_member name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1467789037399{margin-bottom: 40px !important;}"][vc_column][vc_text_separator title="Without Description" color="custom" accent_color="#ededed"][vc_row_inner][vc_column_inner width="1/4"][ut_team_member name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467788987858{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][vc_text_separator title="Without Description & Social Icons" color="custom" accent_color="#ededed"][vc_row_inner][vc_column_inner width="1/4"][ut_team_member name="Thomas Hoffmann" occupation="CEO Brookyln Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/4"][ut_team_member name="Helmut Hoffmann" occupation="The Nephew" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Custom Sizes & Colors" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467789310167{margin-bottom: 40px !important;}"][vc_column width="1/3"][ut_team_member align="left" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467915516011{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #2c3e50 !important;}" name_color="#f1c40f" ocupation_color="#fafafa" description_color="#fafafa" line_color="#34495e" icon_color_hover="#fafafa"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467915520123{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #0c2032 !important;}" name_color="#bdc3c7" ocupation_color="#f1c40f" description_color="#bdc3c7" line_color="#1b3147" icon_color="#ffffff" icon_color_hover="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467789274461{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][ut_header style="pt-style-2" title="Team Member Style 2"][/ut_header][vc_row_inner][vc_column_inner][vc_text_separator title="Base Layout" color="custom" accent_color="#ededed"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-2" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" line_color="#ededed" icon_color_hover="#f1c40f" ocupation_color="#0a0d1b"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-2" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#0a0d1b" line_color="#ededed" icon_color_hover="#f1c40f" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-2" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" icon_color="#0a0d1b" line_color="#fafafa" icon_color_hover="#f1c40f" ocupation_color="#0a0d1b"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Custom Layouts" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467786238954{margin-bottom: 40px !important;}"][vc_column width="1/3"][ut_team_member style="member-style-2" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467915542992{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ecf0f1 !important;}" icon_color="#dadada" line_color="#fafafa" icon_color_hover="#2c3e50"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member style="member-style-2" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467915547101{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #2c3e50 !important;}" name_color="#f1c40f" ocupation_color="#fafafa" description_color="#fafafa" line_color="#34495e" icon_color_hover="#fafafa"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member style="member-style-2" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467789691859{margin-bottom: 40px !important;padding-top: 40px !important;padding-bottom: 40px !important;background-color: #f9f9f9 !important;}"][vc_column][ut_header style="pt-style-2" title="Team Member Style 3"][/ut_header][vc_row_inner][vc_column_inner][vc_text_separator title="Custom Hover Styles" color="custom" accent_color="#ededed"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-3" name="Thomas Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" name_color="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-3" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467915563951{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #f1c40f !important;}" name_color="#f1c40f" ocupation_color="#0a0d1b" icon_color_hover="#f1c40f" overlay_color="#ffffff" icon_color="#0a0d1b"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][vc_column_inner width="1/3"][ut_team_member style="member-style-3" name="Max Hoffmann" occupation="The Brother" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" name_color="#0a0d1b" ocupation_color="#ffffff" overlay_color="#f1c40f" icon_color="#0a0d1b" icon_color_hover="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_header style="pt-style-2" title="Team Member Style 4"][/ut_header][/vc_column][/vc_row][vc_row][vc_column][vc_text_separator title="Text Alignment Bottom" color="custom" accent_color="#ededed"][/vc_column][/vc_row][vc_row css=".vc_custom_1467667458182{margin-bottom: 80px !important;}"][vc_column width="1/2"][ut_team_member style="member-style-4" name="Max Hoffmann" occupation="CEO Brooklyn Homes" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%7D%5D" name_color="#0a0d1b" overlay_color="rgba(255,255,255,0.9)" ocupation_color="#f1c40f"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/2"][ut_team_member style="member-style-4" name="Frank Hoffmann" occupation="The Son" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" css=".vc_custom_1467915580974{padding-top: 20px !important;padding-right: 20px !important;padding-bottom: 20px !important;padding-left: 20px !important;background-color: #ededed !important;}" name_color="#f1c40f" ocupation_color="#fafafa" icon_color_hover="#fafafa" overlay_color="rgba(52,73,94,0.7)"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row]'
        ),
        array(
            'name'      => esc_html__( 'Demo 20 - Project Details Page', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][vc_single_image img_size="full" alignment="center"][/vc_column][/vc_row][vc_row css=".vc_custom_1467836668565{margin-bottom: 80px !important;}"][vc_column width="1/6"][vc_media_grid style="pagination" items_per_page="3" element_width="12" gap="20" grid_id="vc_gid:1467915747422-5d089c83-df10-6"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Project Description" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="2/6"][vc_custom_heading text="Project Details" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_fancy_list values="%5B%7B%22title%22%3A%22%3Cstrong%3EClient%3A%3C%2Fstrong%3E%20United%20Buildings%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3ELocation%3A%3C%2Fstrong%3E%20Germany%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3EProject%20Begin%3A%3C%2Fstrong%3E%20March%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3EProject%20End%3A%3C%2Fstrong%3E%20Juni%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%3Cstrong%3EArchitect%3A%3C%2Fstrong%3E%20Mr.%20Smith%22%2C%22is_link%22%3A%22true%22%7D%5D" css=".vc_custom_1467837162554{padding: 20px !important;background-color: #fafafa !important;}"][vc_custom_heading text="Project Management" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][vc_icon icon_fontawesome="fa fa-file-pdf-o" color="custom" background_style="rounded" background_color="custom" size="lg" align="center" link="url:%23|title:Download%20Brochure|target:%20_blank|" custom_color="#fafafa" custom_background_color="#f1c40f" css=".vc_custom_1467841293740{margin-bottom: 20px !important;}"][vc_column_text]
Download Brochure

[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1467769950053{margin-bottom: 0px !important;background-color: #141414 !important;}"][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-phone" color="#0a0d1b" background="#f1c40f" headline="Any Question at" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-home" color="#0a0d1b" background="#f1c40f" headline="1399 Beverley Rd" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-clock-o" color="#0a0d1b" background="#f1c40f" headline="Mon-Sat" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column shape="round" headline_color="#ffffff" text_color="#777777" icon="fa fa-envelope-o" color="#0a0d1b" background="#f1c40f" headline="Send your mail at" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',
        ),

        /* Demo 21 - Creative Agency */
        array(
            'name'      => esc_html__( 'Demo 21 - Home Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle" css=".vc_custom_1470172161287{margin-bottom: 80px !important;padding-top: 40px !important;padding-right: 60px !important;padding-bottom: 40px !important;padding-left: 60px !important;background-color: #f9f9f9 !important;}"][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="Who We Are" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469498927805{margin-bottom: 10px !important;}"][ut_header title="Your experts around modern design."]We are a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][vc_column width="2/3" offset="vc_col-lg-8 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_icon type="linecons" icon_linecons="vc_li vc_li-phone" color="custom" size="xl" align="center" custom_color="#f5ab35"][vc_custom_heading text="MOBILE DESIGN" font_container="tag:h3|text_align:center|color:%23333333" use_theme_fonts="yes" css=".vc_custom_1470184344232{margin-bottom: 40px !important;}"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_icon type="linecons" icon_linecons="vc_li vc_li-data" color="custom" size="xl" align="center" custom_color="#f5ab35"][vc_custom_heading text="APPS DEVELOPMENT" font_container="tag:h3|text_align:center|color:%23333333" use_theme_fonts="yes" css=".vc_custom_1470184354503{margin-bottom: 40px !important;}"][/vc_column_inner][vc_column_inner width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_icon type="linecons" icon_linecons="vc_li vc_li-cloud" color="custom" size="xl" align="center" custom_color="#f5ab35"][vc_custom_heading text="UX/UI DESIGN" font_container="tag:h3|text_align:center|color:%23333333" use_theme_fonts="yes" css=".vc_custom_1470184358920{margin-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1470017013870{margin-bottom: 80px !important;}"][vc_column width="2/3" offset="vc_col-lg-offset-0"][vc_custom_heading text="Brooklyn Demo #21" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469498940817{margin-bottom: 10px !important;}"][ut_header title="We create awesome websites."]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.

Each demo looks different and can be imported in seconds![/ut_header][/vc_column][vc_column width="1/3"][ut_animated_image size="large" align="center" animate_once="yes" image="515" effect="fadeIn"][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="our finest designs" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469551995320{margin-bottom: 10px !important;}"][ut_header align="center" title="Our works."]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1469590804944{margin-bottom: 80px !important;}"][vc_column][ut_custom_shortcode][ut_showcase id="99"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row][vc_column][vc_custom_heading text="Our Clients" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469591935773{margin-bottom: 10px !important;}"][ut_header align="center" title="You are in good company!"]Over 37.000 extremely satisfied customers![/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row" background_position="center center" background_attachment="scroll" css=".vc_custom_1470260095639{margin-bottom: 0px !important;padding-top: 120px !important;padding-bottom: 80px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][ut_qtrotator effect_in="fadeIn" effect_out="fadeOut" arrow_color="#333333" arrow_color_hover="#f5ab35" quote_color="#333333" name_color="#333333"][ut_qt avatar="236" author="Fmenossi"]Easy to install, work exatelly as expected.
Best theme I ever had.[/ut_qt][ut_qt avatar="237" author="Illagraphics"]This theme is perfect for the project I’m working on.
Its flexible and easy to use.[/ut_qt][ut_qt avatar="240" author="Slidus"]Great theme and customer support!
Purchased this theme more than once. [/ut_qt][/ut_qtrotator][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1469410901052{background-color: #f9f9f9 !important;}"][vc_column][ut_image_gallery thumbnail_size="medium" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="264,263,262,259,268" effect="fadeIn"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1469828450302{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Every Day We Fight!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469750459988{margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][ut_header title="Our history."]We are a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline_color="#333333" headline="1.) OUR RESPONSIBILITY"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline_color="#333333" headline="2.) OUR APPROACH"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="3.) OUR MISSION"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1469751518111{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="PAUL" avatar="236" occupation="Founder" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="KARL" avatar="237" occupation="Distribution" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TOM" avatar="238" occupation="Engineering" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="SANDRA" avatar="240" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner][vc_custom_heading text="We are brooklyn!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469751560802{margin-bottom: 10px !important;}"][ut_header title="Our famous team."]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="DIRK" avatar="245" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TARUN" avatar="243" occupation="Handy-Man" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1469828604740{margin-bottom: 80px !important;}"][vc_column][ut_parallax_quote quotation_marks="no" icon_border_radius="50" quote_font_source="websafe" quote_websafe_fonts="helvetica" quote_font_size="14" quote_line_height="50" quote_letter_spacing="10" quote_font_weight="bold" cite_font_source="websafe" cite_websafe_fonts="helvetica" cite_font_size="13" cite_font_weight="bold" cite_text_transform="uppercase" cite="United Themes" icon="fa fa-quote-left" icon_color="#ffffff" icon_background_color="#333333" quote_color="#333333" cite_color="#cccccc" css=".vc_custom_1469835516230{padding-top: 120px !important;padding-right: 40px !important;padding-bottom: 80px !important;padding-left: 40px !important;background-image: url() !important;background-position: 0 0 !important;background-repeat: repeat !important;}"]PASSION LEADS TO DESIGN,
DESIGN LEADS TO PERFORMANCE,
PERFORMANCE LEADS TO SUCCESS![/ut_parallax_quote][/vc_column][/vc_row][vc_row css=".vc_custom_1469829147655{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Our awesome partner!" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470091907220{margin-bottom: 10px !important;}"][ut_header align="center" title="Our partner."]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="263,262,259,264,267,268" effect="fadeIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][vc_custom_heading text="Get in touch with us!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes"][ut_header align="global" title="Drop us a line."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][ut_custom_shortcode][contact-form-7 id="334" title="contact"][/ut_custom_shortcode][/vc_column][vc_column width="1/2"][ut_service_column_vertical shape="round" headline_color="#333333" icon="fa fa-map-marker" color="#ffffff" background="#333333" headline="VISIT US"]1399 Beverley Rd
Brooklyn, NY 11218[/ut_service_column_vertical][ut_service_column_vertical shape="round" headline_color="#333333" icon="fa fa-envelope-o" color="#ffffff" background="#333333" headline="MAIL US"]contact@yourdomain.com[/ut_service_column_vertical][ut_service_column_vertical shape="round" headline_color="#333333" icon="fa fa-phone" color="#ffffff" background="#333333" headline="CALL US"]1-8456-563-BKLYN[/ut_service_column_vertical][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Main Portfolio Page', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][vc_custom_heading text="Page without hero" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470107160400{margin-bottom: 10px !important;}"][ut_header align="center" title="Portfolio"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_custom_shortcode][ut_showcase id="2842"][/ut_custom_shortcode][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Service Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1470010711683{margin-bottom: 80px !important;}"][vc_column][vc_custom_heading text="New demos each month!" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470010945729{margin-bottom: 10px !important;}"][ut_header align="center" title="No run of the mill."]We have created an awesome theme that will help designers, developers
and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_icon_box effect="fadeIn" animate_once="yes" icon="fa fa-desktop" headline="VISUAL COMPOSER" color="#dddddd"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_icon_box effect="fadeIn" animate_once="yes" icon="fa fa-clock-o" headline="1 CLICK DEMO IMPORTER" color="#f5ab35" hovercolor="#dddddd"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_icon_box effect="fadeIn" animate_once="yes" icon="fa fa-code" headline="FULLY CUSTOMIZABLE" color="#dddddd" hovercolor="#dddddd"]All parts of Brooklyn can be customized. From header to footer and everything what’s in between.[/ut_service_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470012345255{margin-bottom: 120px !important;padding-top: 120px !important;padding-bottom: 40px !important;background: #f9f9f9 url() !important;background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column width="1/2" css=".vc_custom_1469807293290{padding-top: 120px !important;padding-bottom: 80px !important;}"][vc_row_inner][vc_column_inner][vc_custom_heading text="What we offer!" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469806797798{margin-bottom: 10px !important;}"][ut_header title="Our services."]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_service_column effect="fadeIn" animate_once="yes" icon="fa fa-desktop" headline="NEW DEMOS EACH MONTH" color="#333333" imageicon="306"]We release each month new demos for our beloved Brooklyn![/ut_service_column][/vc_column_inner][/vc_row_inner][ut_service_column effect="fadeIn" animate_once="yes" icon="fa fa-life-ring" headline="LIFETIME UPDATES" color="#333333"]Brooklyn received continues updates, new features and new Demos. Since release we published around 50 updates![/ut_service_column][ut_service_column effect="fadeIn" animate_once="yes" icon="fa fa-balance-scale" headline="OUR PROMISE" color="#333333"]We’re here to make products that work! It’s a tall order, but we wouldn’t want to do anything else.[/ut_service_column][/vc_column][vc_column width="1/2" css=".vc_custom_1470012243922{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" image="832" effect="fadeInRight"][/vc_column][/vc_row][vc_row css=".vc_custom_1469814947065{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][vc_custom_heading text="what are you waiting for?" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469814729146{margin-bottom: 10px !important;}"][ut_header align="center" title="Our offer for you."]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="continuous improvements" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="New Demos" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="unlimited possibilities" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="bold" info_letter_spacing="0" info_text_transform="uppercase" info="Power Elite Support" background_color="#f9f9f9" color="#dddddd" percentage_color="#333333" info_color="#333333"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1469814947065{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner][vc_custom_heading text="You are in good company!" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470009882749{margin-bottom: 10px !important;}"][ut_header align="center" title="Customers voice."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="CUSTOMIZABILITY" author="Fmenossi" avatar="236" company="Brooklyn Customer" deco_line_color="#efefef"]Easy to install, work exatelly as expected. Best theme I ever had.[/ut_single_quote][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="FLEXIBILITY" author="Illagraphics" avatar="238" company="Brooklyn Customer" deco_line_color="#efefef"]This theme is perfect for the project I’m working on. Its flexible and easy to use.[/ut_single_quote][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="CODE QUALITY" author="JRole" avatar="237" company="Brooklyn Customer" deco_line_color="#efefef"]It’s just so easy to use &amp; get fantastic results with very little knowledge.[/ut_single_quote][ut_single_quote rating="5" effect="fadeIn" animate_once="yes" title="CUSTOMER SUPPORT" author="Slidus" avatar="240" company="Brooklyn Customer" deco_line_color="#efefef"]Great theme and customer support! Purchased this theme more than once. [/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column width="2/3"][ut_image_gallery thumbnail_size="full" gap="40" animate_once="yes" delay_animation="true" gallery="1101,1102,1103" effect="fadeIn"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Single Portfolio Style 1" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717353210{margin-bottom: 10px !important;}"][ut_header title="Disc &amp; Cover Design"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/ut_header][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%2C%20Design%22%2C%22link%22%3A%22%7C%7C%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text_font_weight="bold" share_text="SHARE:" border="true" border_color="#efefef" icon_color="#999999" icon_color_hover="#f5ab35" share_text_color="#333333"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="3/4"][vc_custom_heading text="Single Portfolio Style 2" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717493127{margin-bottom: 10px !important;}"][ut_header title="Frame Decoration"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Interiors%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="557" effect="fadeIn"][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="607,609,608,610" effect="fadeIn"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/6"][vc_custom_heading text="Single Portfolio Style 3" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717524368{margin-bottom: 10px !important;}"][ut_header title=" Jacks Hot Cup"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Jacks%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="4/6"][ut_image_gallery thumbnail_size="large" grid="3" adjust_row="yes" gap="40" animate_once="yes" delay_animation="true" effect="bounceInDown" gallery="662,661,666,665,664,659,658,660"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470153837638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 4" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470153127186{margin-bottom: 10px !important;}"][ut_header title="Brooklyn is perfect for your presentation."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="2824" effect="zoomIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" css=".vc_custom_1470162702299{margin-bottom: 0px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #222222 !important;}"][vc_column][vc_custom_heading text="Brooklyn 4 is here!" font_container="tag:h6|font_size:15px|text_align:center|color:%23f5ab35" use_theme_fonts="yes" css=".vc_custom_1470159454271{margin-bottom: 10px !important;}"][ut_header align="center" title="Present your web
with brooklyn." title_color="#ffffff" lead_color="#999999" css=".vc_custom_1470188000328{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_gallery_slider lightbox="no" dots="false" effect_in="zoomIn" effect_out="zoomOut" slides="2839,2838,2841,2837,2840" arrow_color="#f5ab35" arrow_color_hover="#ffffff" arrow_background_color="rgba(0,0,0,0.1)" dot_color="#ffffff" dot_color_hover="#f5ab35"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470161590478{margin-bottom: 80px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #28272c !important;}"][vc_column][vc_custom_heading text="Single Portfolio Style 4" font_container="tag:h6|font_size:15px|text_align:center|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470162512428{margin-bottom: 10px !important;}"][ut_header align="center" title="Black watch." title_color="#f5ab35" css=".vc_custom_1470162797977{margin-bottom: 80px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_image_gallery thumbnail_size="large" lightbox="no" grid="3" gap="40" delay_animation="true" gallery="2831,2829,2830" effect="zoomIn"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="2833" effect="zoomIn"][/vc_column][vc_column width="1/2"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Black%20Watch%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%20%22%2C%22description%22%3A%22Watch%20Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="bottom"][vc_column width="2/3"][vc_custom_heading text="Single Portfolio Style 5" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469730525127{margin-bottom: 10px !important;}"][ut_header title="Brads"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brads%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="zoomIn" gallery="721,713,720,708,722,710"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1469758135477{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469757988023{margin-bottom: 10px !important;}"][ut_header title="Berlin"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="785" effect="fadeIn"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1469758138604{margin-bottom: 80px !important;}"][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="786" effect="fadeIn" delay_timer="400"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469758000521{margin-bottom: 10px !important;}"][ut_header title="Orange room."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469758024808{margin-bottom: 10px !important;}"][ut_header title="Orange is king."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="787" effect="fadeIn" delay_timer="600"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_height="yes" equal_height="yes" content_placement="middle"][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 7" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469760101545{margin-bottom: 10px !important;}"][ut_header title="We design a unique multipurpose website."]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="792" effect="zoomIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" full_height="yes" equal_height="yes"][vc_column][ut_parallax_quote quotation_marks="no" quote_font_source="websafe" quote_websafe_fonts="helvetica" quote_font_size="15" quote_line_height="50" quote_letter_spacing="10" quote_font_weight="bold" quote_text_transform="uppercase" cite_font_source="websafe" cite_websafe_fonts="helvetica" cite_font_size="13" cite_font_weight="bold" cite_text_transform="uppercase" cite="Brooklyn Customer" icon="fa fa-quote-left" icon_color="#333333" quote_color="#333333" cite_color="#cccccc"]I’m really enjoying this theme, very easy to use, the markups makes a lot of sense, and the design is on point. Great!!![/ut_parallax_quote][/vc_column][/vc_row][vc_row full_height="yes" equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="794" effect="zoomIn"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 7" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469760105388{margin-bottom: 10px !important;}"][ut_header title="Thank you!"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border="true" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="flipInX" gallery="1026,1027,1028,1029,1030,1031"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="2/3"][vc_custom_heading text="Single Portfolio Style 8" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469856555909{margin-bottom: 10px !important;}"][ut_header title="John Street"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22John%20Street%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22August%201%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 9', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="3/4"][vc_custom_heading text="Single Portfolio Style 9" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469889884692{margin-bottom: 10px !important;}"][ut_header title="Relaxation Room"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd
gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 10', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Single Portfolio Style 4" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1469717576836{margin-bottom: 10px !important;}"][ut_header title="Brooklyn Magazine"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="5/6"][ut_gallery_slider slides="2698,2697,2695,2696"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/6"][ut_image_gallery thumbnail_size="medium" gap="40" animate_once="yes" delay_animation="true" gallery="2697,2698,2701" effect="zoomIn"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Magazine%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 11', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/3"][ut_gallery_slider dots="false" effect_in="bounceIn" effect_out="bounceOut" slides="2728,2729,2730,2731" arrow_color="#333333" arrow_color_hover="#f5ab35"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Single Portfolio Style 11" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470073522937{margin-bottom: 10px !important;}"][ut_header title="Top Brand"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Top%20Brand%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),
         array(
            'name'      => esc_html__( 'Demo 21 - Single Portfolio Style 12', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="2743,2744,2745,2746" effect="flipInX"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Single Portfolio Style 12" font_container="tag:h6|font_size:15px|text_align:left|color:%23cccccc" use_theme_fonts="yes" css=".vc_custom_1470074826957{margin-bottom: 10px !important;}"][ut_header title="Drawing"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22United%20Themes%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][/vc_row]',

        ),

        /* Demo 22 */
        array(
            'name'      => esc_html__( 'Demo 22 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1476104711538{padding-top: 80px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="UNITED THEMES" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604014105{margin-bottom: 10px !important;}"][ut_header title="We Build The Web"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row" background_position="right bottom" background_attachment="scroll" hide_bg_medium="true" hide_bg_tablet="true" hide_bg_mobile="true" css=".vc_custom_1476470891749{margin-bottom: 0px !important;padding-bottom: 80px !important;background-image: url() !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column width="1/2" css=".vc_custom_1476107837958{padding-top: 0px !important;}" offset="vc_col-lg-9 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner delay="true" effect="fadeIn" delay_timer="400"][vc_column_inner width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476116764585{margin-bottom: 40px !important;}" effect="fadeIn" delay_timer="400"][vc_icon type="linecons" icon_linecons="vc_li vc_li-phone" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104561072{margin-bottom: 12px !important;}"][vc_custom_heading text="MOBILE DESIGN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104785496{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][vc_icon type="linecons" icon_linecons="vc_li vc_li-data" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104569877{margin-bottom: 12px !important;}"][vc_custom_heading text="APPS DEVELOPMENT" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104781755{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476116773553{margin-bottom: 40px !important;}" effect="fadeIn" delay_timer="800"][vc_icon type="linecons" icon_linecons="vc_li vc_li-paperplane" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104579879{margin-bottom: 12px !important;}"][vc_custom_heading text="INNOVATIVE ADMIN PANEL" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104789871{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476116777601{margin-bottom: 40px !important;}" effect="fadeIn" delay_timer="1000"][vc_icon type="linecons" icon_linecons="vc_li vc_li-cloud" color="custom" size="lg" custom_color="#0070c9" css=".vc_custom_1476104587733{margin-bottom: 12px !important;}"][vc_custom_heading text="UX/UI DESIGN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1476104793595{margin-bottom: 0px !important;}"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1475623482050{margin-bottom: 120px !important;padding-top: 80px !important;background-color: #1b1d1f !important;}"][vc_column offset="vc_col-lg-offset-0"][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/2" offset="vc_col-lg-6 vc_hidden-md vc_hidden-sm vc_hidden-xs" effect="none"][ut_animated_image size="full" animate_once="yes" image="3847" css=".vc_custom_1476284926296{margin-bottom: 0px !important;}" effect="fadeInUp" animation_duration="2s"][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12" css=".vc_custom_1476284933348{margin-bottom: 80px !important;}" effect="fadeInDown" delay_timer="400" animation_duration="2s"][vc_custom_heading text="INTUITIVE &amp; SMART" font_container="tag:h6|font_size:25px|text_align:left|color:%23444444" use_theme_fonts="yes" css=".vc_custom_1475623291736{margin-bottom: 10px !important;}"][ut_header title="Works On All Platforms" title_color="#ffffff" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1475623431748{padding-top: 0px !important;}"][vc_custom_heading text="OUR AWESOME PROJECTS" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604521054{margin-bottom: 10px !important;}"][ut_header align="center" title="The Work We Love"]We believe our work speaks for itself. Browse our most recent projects below.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1475676795342{margin-bottom: 10px !important;}"][vc_column][ut_custom_shortcode][ut_showcase id="99"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476116094336{margin-bottom: 120px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #1b1d1f !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="ADVANTAGES" font_container="tag:h6|font_size:25px|text_align:left|color:%23444444" use_theme_fonts="yes" css=".vc_custom_1476116201603{margin-bottom: 10px !important;}"][ut_header align="left" title="How We Work" title_color="#ffffff" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][vc_row_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="400"][vc_icon type="linecons" icon_linecons="vc_li vc_li-phone" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672351420{margin-bottom: 12px !important;}"][vc_custom_heading text="MOBILE DESIGN" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118410016{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][vc_icon type="linecons" icon_linecons="vc_li vc_li-fire" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672341829{margin-bottom: 12px !important;}"][vc_custom_heading text="APPS DEVELOPMENT" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118415192{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="800"][vc_icon type="linecons" icon_linecons="vc_li vc_li-world" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672362854{margin-bottom: 12px !important;}"][vc_custom_heading text="GLOBAL BRANDING" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118420766{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="1000"][vc_icon type="linecons" icon_linecons="vc_li vc_li-bubble" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672372435{margin-bottom: 12px !important;}"][vc_custom_heading text="CUSTOMER SUPPORT" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118426195{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="1200"][vc_icon type="linecons" icon_linecons="vc_li vc_li-data" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672383286{margin-bottom: 12px !important;}"][vc_custom_heading text="WEB HOSTING" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118432445{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="1400"][vc_icon type="linecons" icon_linecons="vc_li vc_li-diamond" color="custom" size="lg" align="center" custom_color="#0070c9" css=".vc_custom_1475672392703{margin-bottom: 12px !important;}"][vc_custom_heading text="UI DESIGN" font_container="tag:h3|text_align:center|color:%23e5e5e5" use_theme_fonts="yes" css=".vc_custom_1476118442472{margin-bottom: 20px !important;}"][vc_column_text]
<p style="text-align: center;"><span style="color: #5d5d5d;">Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</span></p>

[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column animate_once="yes" delay="true" css=".vc_custom_1476120589381{padding-top: 0px !important;}" effect="fadeIn" delay_timer="200"][vc_custom_heading text="OUR CLIENTS SAID" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604769727{margin-bottom: 10px !important;}"][ut_header align="center" title="You Are In Good Company"]Over 38.000 extremely satisfied customers![/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475710080770{margin-bottom: 80px !important;background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column animate_once="yes" delay="true" css=".vc_custom_1476120606769{padding-top: 0px !important;}" effect="fadeIn" delay_timer="400"][ut_qtrotator_2 rotator_custom_font="yes" arrow_color="#333333" arrow_color_hover="#0070c9" name_color="#333333"][ut_qt_2 avatar="3401" author="John Areus" origin="Brooklyn User" imageicon="3888"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 avatar="3400" author="Ron Schmidt" origin="Brooklyn User" imageicon="3889"]“Im really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point.
Really looking forward to the upcoming demos, United Themes, you guys do a great job!"
[/ut_qt_2][ut_qt_2 avatar="3416" author="Henrik Schwarz" origin="Brooklyn User" imageicon="3890"]"The one and only Wordpress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!"[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476114044954{background-color: #1b1d1f !important;}"][vc_column css=".vc_custom_1476114133218{padding-top: 60px !important;padding-bottom: 20px !important;}"][ut_image_gallery thumbnail_size="medium" lightbox="no" grid="5" gap="40" animate_once="yes" delay_animation="true" gallery="3473,3474,3475,3476,3477" effect="fadeIn" delay_timer="300"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1476558889993{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="none"][vc_column bklyn_overlay="true" background_position="center center" background_attachment="scroll" animate_once="yes" delay="true" css=".vc_custom_1476558979511{padding-top: 240px !important;padding-bottom: 240px !important;background-image: url() !important;}" effect="fadeIn" delay_timer="400" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_custom_heading text="EASY AND FAST INSTALLATION" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" css=".vc_custom_1475604810469{margin-bottom: 10px !important;}"][ut_header align="center" title="So Intuitive, So Easy!" title_color="#ffffff" lead_color="#ffffff"]Join the Brooklyn family with over 22k Member![/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_weight="500" text_transform="uppercase" letter_spacing="2" button_text="Purchase" button_text_color="#ffffff" button_background="#0070c9" button_text_color_hover="#333333" button_background_hover="#ffffff" css=".vc_custom_1475663210672{padding-bottom: 50px !important;}" spacing="padding-bottom:8px"][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 22 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1469828450302{margin-bottom: 80px !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="We Are Brooklyn" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475665116476{margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][ut_header title="Our History"]We are a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][vc_row_inner][vc_column_inner width="1/3"][ut_service_column headline="1.) OUR RESPONSIBILITY"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="2.) OUR APPROACH"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.
[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3"][ut_service_column headline="3.) OUR MISSION"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1469751518111{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="PAUL" avatar="3415" occupation="Founder" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="KARL" avatar="3416" occupation="Distribution" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TOM" avatar="3417" occupation="Engineering" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="SANDRA" avatar="3418" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner][vc_custom_heading text="Our Famous Team" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475774092100{margin-bottom: 10px !important;}"][ut_header title="The Crew"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="DIRK" avatar="3419" occupation="Designer" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" icon_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member style="member-style-4" name="TARUN" avatar="3420" occupation="Handy-Man" social="%5B%7B%7D%5D" name_color="#ffffff" ocupation_color="#ffffff" overlay_color="rgba(0,112,201,0.7)"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" full_height="yes" bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1475765580529{margin-bottom: 0px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="The Mission" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475773811114{margin-bottom: 10px !important;}"][ut_header align="left" title="Our Responsibility" title_color="#ffffff" lead_color="#ffffff"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475762719202{margin-bottom: 120px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #1b1d1f !important;}"][vc_column][vc_row_inner][vc_column_inner][vc_custom_heading text="Pixel Perfect" font_container="tag:h6|font_size:25px|text_align:center|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475774174205{margin-bottom: 10px !important;}"][ut_header align="center" title="Our Approach" title_color="#ffffff" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3"][ut_count_up caption_text_transform="uppercase" to="75" counter_color="#777777" desccolor="#444444" icon="fa fa-cubes" color="#444444"]Finished Projects[/ut_count_up][/vc_column_inner][vc_column_inner width="1/3"][ut_count_up caption_text_transform="uppercase" to="420" counter_color="#777777" desccolor="#444444" icon="fa fa-heart" color="#444444"]Happy Clients[/ut_count_up][/vc_column_inner][vc_column_inner width="1/3"][ut_count_up caption_text_transform="uppercase" to="24" counter_color="#777777" desccolor="#444444" icon="fa fa-umbrella" color="#444444"] Employee[/ut_count_up][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1475774771233{margin-bottom: 40px !important;}"][vc_column css=".vc_custom_1475533703277{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Proud to work with" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475764964452{margin-bottom: 10px !important;}"][ut_header align="left" title="Our Clients" css=".vc_custom_1475773552406{margin-bottom: 0px !important;}"]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][vc_column_inner width="1/2"][ut_image_gallery thumbnail_size="medium" lightbox="no" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="3544,3545,3546,3547,3548,3549" effect="fadeIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1476311658513{padding-top: 240px !important;padding-bottom: 240px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_column css=".vc_custom_1476122867830{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner css=".vc_custom_1476122824274{padding-top: 0px !important;}"][vc_custom_heading text="New demos each month" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476311542034{margin-bottom: 10px !important;}"][ut_header align="center" title="Join The Brooklyn Family" title_color="#ffffff" lead_color="#fafafa"]We have created an awesome theme that will help designers, developers
and companies create websites for their startups quickly and easily.[/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_weight="600" text_transform="capitalize" letter_spacing="2" button_text="Join Now" button_background="#ffffff" button_text_color="#333333" button_text_color_hover="#0070c9" button_background_hover="#ffffff" spacing="padding-bottom:8px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Service Page', 'ut_shortcodes' ),
            'content'   => '[vc_row css=".vc_custom_1470010711683{margin-bottom: 80px !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="New demos each month" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475677655713{margin-bottom: 10px !important;}"][ut_header align="center" title="No Run Of The Mill"]We have created an awesome theme that will help designers, developers
and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="400"][ut_service_icon_box animate_once="yes" icon="fa fa-desktop" headline="VISUAL COMPOSER" color="#dddddd" icon_color="#ffffff" icon_hover_color="#ffffff" hovercolor="#0070c9"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][ut_service_icon_box icon="fa fa-clock-o" headline="1 CLICK DEMO IMPORTER" color="#0070c9" hovercolor="#dddddd" icon_color="#ffffff" icon_hover_color="#ffffff"]The most popular Page Builder plugin now integrated in Brooklyn. Web design without any coding and right at your fingertips![/ut_service_icon_box][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes" delay="true" effect="fadeIn" delay_timer="800"][ut_service_icon_box animate_once="yes" icon="fa fa-code" headline="FULLY CUSTOMIZABLE" color="#dddddd" icon_color="#ffffff" icon_hover_color="#ffffff" hovercolor="#0070c9"]All parts of Brooklyn can be customized. From header to footer and everything what’s in between.[/ut_service_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1476308404797{margin-bottom: 120px !important;background-color: #1b1d1f !important;background-position: 0 0 !important;background-repeat: repeat !important;}"][vc_column width="1/2" css=".vc_custom_1475791604048{padding-top: 120px !important;padding-bottom: 80px !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="What we offer" font_container="tag:h6|font_size:25px|text_align:left|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475766265963{margin-bottom: 10px !important;}"][ut_header title="Our Services" title_color="#ffffff" lead_color="#777777"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="400"][ut_service_column animate_once="yes" icon="fa fa-desktop" headline="NEW DEMOS EACH MONTH" imageicon="306" headline_color="#e5e5e5" text_color="#5d5d5d" color="#444444"]We release each month new demos for our beloved Brooklyn![/ut_service_column][ut_service_column animate_once="yes" icon="fa fa-life-ring" headline="LIFETIME UPDATES" headline_color="#e5e5e5" text_color="#5d5d5d" color="#444444"]Brooklyn received continues updates, new features and new Demos. Since release we published around 50 updates![/ut_service_column][ut_service_column animate_once="yes" icon="fa fa-balance-scale" headline="OUR PROMISE" headline_color="#e5e5e5" text_color="#5d5d5d" color="#444444"]We’re here to make products that work! It’s a tall order, but we wouldn’t want to do anything else.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476309760169{padding-top: 0px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" offset="vc_hidden-md vc_hidden-sm vc_hidden-xs" effect="fadeIn" delay_timer="400" animation_duration="4s"][/vc_column][/vc_row][vc_row css=".vc_custom_1469814947065{margin-bottom: 80px !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner animate_once="yes" delay="true" delay_timer="200" effect="fadeIn"][vc_custom_heading text="what are you waiting for?" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475677673459{margin-bottom: 10px !important;}"][ut_header align="center" title="Our Offer For You"]Each completed project makes us even more hungry, hungry for more designs, more code and at least some more twinkies.
As a result we deliver a better web experience.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="continuous improvements" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="New Demos" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="unlimited possibilities" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="Power Elite Support" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475534176834{padding-top: 120px !important;padding-bottom: 80px !important;background-color: #fafafa !important;}"][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_custom_heading text="You are in good company" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475679941920{margin-bottom: 10px !important;}"][ut_header align="center" title="Customers Voice"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor
invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][ut_single_quote activate_rating="no" animate_once="yes" title="CUSTOMIZABILITY" author="Fmenossi" avatar="3415" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]Easy to install, work exatelly as expected. Best theme I ever had.[/ut_single_quote][ut_single_quote activate_rating="no" animate_once="yes" title="FLEXIBILITY" author="Illagraphics" avatar="3417" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]This theme is perfect for the project I’m working on. Its flexible and easy to use.[/ut_single_quote][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" delay="true" effect="fadeIn" delay_timer="600"][ut_single_quote activate_rating="no" animate_once="yes" title="CODE QUALITY" author="JRole" avatar="3416" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]It’s just so easy to use &amp; get fantastic results with very little knowledge.[/ut_single_quote][ut_single_quote activate_rating="no" animate_once="yes" title="CUSTOMER SUPPORT" author="Slidus" avatar="3418" company="Brooklyn Customer" deco_line_color="#efefef" author_color="#333333"]Great theme and customer support! Purchased this theme more than once. [/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',

        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Crew Page', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][vc_custom_heading text="We Love Web Design" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header title="Our Awesome Crew"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.
[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1476554285042{margin-bottom: 80px !important;}"][vc_column width="1/4"][ut_team_member align="left" name="HELMUT BROOKLYN" occupation="CEO " values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4223"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="HANS GLUECK" occupation="DESIGNER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4220"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="FRANK BROOKLYN" occupation="THE SON" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4217"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="ROBERT WOLFF" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4227"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="MAX BROOKLYN" occupation="THE BROTHER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4222"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="TITUS CRONOS" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4221"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="HELM BROOKLYN" occupation="THE NEPHEW" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4218"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="SAN RICHTER" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#333333" ocupation_color="#0070c9" avatar="4219"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1476554328358{margin-bottom: 0px !important;background-color: #0070c9 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Crew Detail Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1476554328358{margin-bottom: 0px !important;background-color: #0070c9 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLEY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][vc_row css=".vc_custom_1476555192549{margin-top: 80px !important;}"][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header title="Helmut Brooklyn"]Hello, Im Helmut Brooklyn CEO at Brooklyn Designs.
[/ut_header][vc_column_text]<img class="alignleft size-medium wp-image-4223" src="" alt="team8" width="300" height="200" />Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1469815053514{padding-top: 0px !important;}"][vc_row_inner][vc_column_inner width="1/2"][ut_probar width="95" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="HTML" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="90" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="CSS" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][vc_column_inner width="1/2"][ut_probar width="97" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="DESIGN" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][ut_probar width="100" animate_once="yes" border_radius="30" info_font_size="14" info_font_weight="" info_letter_spacing="0" info_text_transform="uppercase" info="CONCEPT" background_color="#dddddd" color="#0070c9" percentage_color="#ffffff" info_color="#3b3d40"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1475795383144{margin-bottom: 120px !important;background-color: #0070c9 !important;}"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-phone" color="#ffffff" headline="ANY QUESTION AT" headline_margin_bottom="0px"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-home" color="#ffffff" headline="1399 BEVERLY RD" headline_margin_bottom="0px"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-clock-o" color="#ffffff" headline="MON - SAT" headline_margin_bottom="0px"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column headline_color="#ffffff" text_color="#ffffff" icon="fa fa-envelope-o" color="#ffffff" headline="SEND YOUR MAIL AT" headline_margin_bottom="0px"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1475795445815{padding-top: 0px !important;}"][vc_custom_heading text="Get in touch with us" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="global" title="Contact"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ut_custom_shortcode][contact-form-7 id="334" title="contact"][/ut_custom_shortcode][/vc_column][vc_column width="1/3"][vc_custom_heading font_container="tag:h3|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]

I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.

[/vc_column_text][vc_custom_heading font_container="tag:h3|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]

I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.

[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" border_color="#efefef" share_text_color="#333333"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 1', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column width="2/3"][ut_image_gallery thumbnail_size="large" gap="40" animate_once="yes" delay_animation="true" gallery="3349,3350,3352" effect="fadeIn"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Portfolio Style 1" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711398804{margin-bottom: 10px !important;}"][ut_header title="Disc &amp; Cover Design"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/ut_header][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%2C%20Design%22%2C%22link%22%3A%22%7C%7C%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text_font_weight="bold" share_text="SHARE:" border="true" border_color="#efefef" icon_color="#999999" share_text_color="#333333"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 2', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="3/4"][vc_custom_heading text="Portfolio Style 2" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711432773{margin-bottom: 10px !important;}"][ut_header title="Frame Decoration"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Interiors%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" animate_once="yes" delay="true" image="3353" effect="fadeIn"][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="3355,3357,3356,3354" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 3', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/6"][vc_custom_heading text="Portfolio Style 3" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476140988444{margin-bottom: 10px !important;}"][ut_header title=" Jacks Hot Cup"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Jacks%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="4/6"][ut_image_gallery thumbnail_size="large" grid="3" adjust_row="yes" gap="40" animate_once="yes" delay_animation="true" effect="bounceInDown" gallery="3388,3390,3391,3392,3393,3394,3395,3396,3397"][/vc_column][/vc_row][vc_row][vc_column][ut_animated_image size="large" align="center" animate_once="yes" image="3962" effect="fadeInUp" css=".vc_custom_1476273463358{margin-bottom: 0px !important;}"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 4', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1470153837638{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476138631245{margin-bottom: 10px !important;}"][ut_header title="Right When You Need It"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][/vc_column][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="3369" effect="zoomIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" css=".vc_custom_1476138622067{margin-bottom: 0px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #1b1d1f !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:center|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476138638508{margin-bottom: 10px !important;}"][ut_header align="center" title="Brilliantly Scratch-Resistant" title_color="#ffffff" lead_color="#777777" css=".vc_custom_1476138992142{margin-bottom: 40px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_gallery_slider lightbox="no" dots="false" effect_in="zoomIn" effect_out="zoomOut" slides="3372,3371,3374,3370,3373" arrow_color="#e5e5e5" arrow_color_hover="#ffffff" arrow_background_color="rgba(0,0,0,0.1)" dot_color="#ffffff" dot_color_hover="#3b66ac"][/vc_column][/vc_row][vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1476138814263{margin-bottom: 80px !important;padding-top: 80px !important;padding-bottom: 80px !important;background-color: #26292c !important;}"][vc_column][vc_custom_heading text="Portfolio Style 4" font_container="tag:h6|font_size:25px|text_align:center|color:%23444444" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476138855159{margin-bottom: 10px !important;}"][ut_header align="center" title="Black Watch" title_color="#ffffff" css=".vc_custom_1476138999318{margin-bottom: 40px !important;}" lead_color="#777777"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore.[/ut_header][ut_image_gallery thumbnail_size="large" lightbox="no" grid="3" gap="40" animate_once="yes" delay_animation="true" gallery="3378,3376,3377" effect="zoomIn"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="medium" align="center" animate_once="yes" delay="true" image="3379" effect="zoomIn"][/vc_column][vc_column width="1/2"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Black%20Watch%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%20%22%2C%22description%22%3A%22Watch%20Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][vc_column_text]
<div class="lead">

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</div>
[/vc_column_text][ut_social_share_bar share_text="SHARE:" border="true" icon_color="#999999" border_color="#efefef" share_text_color="#333333"][/vc_column][/vc_row]',
        ),        
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 5', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="bottom" css=".vc_custom_1476136718992{background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column width="2/3"][vc_custom_heading text="Portfolio Style 5" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711499290{margin-bottom: 10px !important;}"][ut_header title="Brads"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brads%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="zoomIn" gallery="3926,3931,3932,3929,3927,3928" delay_timer="200"][ut_animated_image size="large" align="center" animate_once="yes" image="3910" effect="fadeIn"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 6', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1476560602179{margin-bottom: 0px !important;}"][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561516207{padding-right: 40px !important;}" effect="zoomIn" delay_timer="600" animation_duration="2s"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476560703936{margin-bottom: 10px !important;}"][ut_header title="Digital Watch"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561509214{margin-right: 20px !important;padding-top: 300px !important;padding-bottom: 300px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn" animation_duration="2s" delay_timer="600"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1476560558228{margin-bottom: 0px !important;}"][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561564919{margin-left: 20px !important;padding-top: 300px !important;padding-bottom: 300px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn" animation_duration="2s" delay_timer="600"][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561670190{padding-left: 40px !important;}" effect="zoomIn" animation_duration="2s" delay_timer="600"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476560732454{margin-bottom: 10px !important;}"][ut_header title="Different Colors"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1476561332610{margin-bottom: 0px !important;}"][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561678524{padding-right: 40px !important;}" effect="zoomIn" animation_duration="2s" delay_timer="600"][vc_custom_heading text="Single Portfolio Style 6" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476560727304{margin-bottom: 10px !important;}"][ut_header title="Ready for Duty"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" css=".vc_custom_1476561628825{margin-right: 20px !important;padding-top: 300px !important;padding-bottom: 300px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn" animation_duration="2s" delay_timer="600"][/vc_column][/vc_row]',            
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 7', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" css=".vc_custom_1475579619696{margin-bottom: 40px !important;}"][vc_column][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272896179{margin-bottom: 10px !important;}"][ut_header align="center" title="Just What You Need "]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.[/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1475504692691{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="3414" effect="fadeIn"][/vc_column][vc_column width="1/2" css=".vc_custom_1475504625537{padding-left: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="3413" effect="fadeIn"][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475504672545{margin-bottom: 80px !important;}"][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272901735{margin-bottom: 10px !important;}"][ut_header align="left" title="Monitor Your Health"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1475587778598{margin-bottom: 120px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][/vc_column][/vc_row][vc_row full_width="stretch_row" css=".vc_custom_1475504672545{margin-bottom: 80px !important;}"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272906667{margin-bottom: 10px !important;}"][ut_header align="left" title="Stay Connected"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1476191129158{margin-bottom: 120px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][vc_custom_heading text="Portfolio Style 7" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476272911456{margin-bottom: 10px !important;}"][ut_header align="center" title="Thank You"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.At vero eos et accusam et justo duo dolores et ea rebum.[/ut_header][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="3369" effect="zoomIn" css=".vc_custom_1475588265603{margin-bottom: 80px !important;}"][ut_social_share_bar share_text="SHARE:" share_text_color="#333333" icon_color="#999999" border="true" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 8', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" gap="40" animate_once="yes" delay_animation="true" effect="flipInX" gallery="3933,3936,3937,3938,3939,3940" delay_timer="200"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="bottom"][vc_column width="2/3"][vc_custom_heading text="Portfolio Style 8" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476141522288{margin-bottom: 10px !important;}"][ut_header title="The Bklyn Guys"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][vc_column width="1/3"][ut_portfolio_details style="compact" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22The%20Bklyn%20Guys%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22August%201%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22WEBSITE%3A%22%2C%22description%22%3A%22Visit%20Website%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fthemeforest.unitedthemes.com%252Fwpversions%252Fbrooklyn%252Fdemo15%252F%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333" description_link_color="#333333" description_link_hover_color="#0070c9"][/vc_column][/vc_row][vc_row full_height="yes" background_position="center center" background_attachment="scroll" css=".vc_custom_1476201302319{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}"][vc_column][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 9', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1475627812758{margin-bottom: 80px !important;}"][vc_column width="3/4"][vc_custom_heading text="Single Portfolio Style 9" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475627858252{margin-bottom: 10px !important;}"][ut_header title="Relaxing Car Drive"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd
gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/ut_header][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" icon_color_hover="#f5ab35" border_color="#efefef"][/vc_column][vc_column width="1/4"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="top" css=".vc_custom_1476560333625{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column bklyn_overlay="true" background_position="center bottom" css=".vc_custom_1476561334357{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" equal_height="yes" css=".vc_custom_1476560454124{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1476561275197{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" full_height="yes" columns_placement="stretch" equal_height="yes"][vc_column bklyn_overlay="true" background_position="center center" css=".vc_custom_1476560868819{background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle"][vc_column bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1476560983976{padding-top: 0px !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(0,0,0,0.5)"][vc_row_inner animate_once="yes" effect="zoomIn" css=".vc_custom_1476405069540{padding-top: 0px !important;}"][vc_column_inner][vc_custom_heading text="EASY AND FAST INSTALLATION" font_container="tag:h6|font_size:25px|text_align:center|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase"][ut_header align="center" title="So Intuitive, So Easy!" title_color="#ffffff" lead_color="#ffffff"]Join the Brooklyn family with over 22k Member![/ut_header][ut_btn button_size="bklyn-btn-small" button_border_radius="50" font_weight="500" text_transform="uppercase" letter_spacing="2" button_text="Purchase" button_text_color="#ffffff" button_text_color_hover="#333333" button_background="#0070c9" spacing="padding-bottom:8px" button_background_hover="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 10', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column][vc_custom_heading text="Portfolio Style 10" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476139325076{margin-bottom: 10px !important;}"][ut_header title="Brooklyn Interior"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="5/6"][ut_gallery_slider dots="false" slides="3385,3386,3384"][ut_social_share_bar share_text="SHARE:" border="true" icon_color="#999999" border_color="#efefef" share_text_color="#333333"][/vc_column][vc_column width="1/6"][ut_image_gallery thumbnail_size="medium" gap="40" animate_once="yes" delay_animation="true" gallery="3387,3386,3385" effect="zoomIn"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Bklyn%20Magazine%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 11', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column width="2/3"][ut_gallery_slider dots="false" effect_in="fadeIn" effect_out="fadeOut" slides="3363,3361,3360,3362" arrow_color="#333333" arrow_color_hover="#333333"][/vc_column][vc_column width="1/3"][vc_custom_heading text="Portfolio Style 11" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1475711353151{margin-bottom: 10px !important;}"][ut_header title="Top Brand"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Top%20Brand%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#3b3d40"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#3b3d40" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),
        array(
            'name'      => esc_html__( 'Demo 22 - Portfolio Style 12', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="top"][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" adjust_row="yes" gap="40" animate_once="yes" delay_animation="true" gallery="3950,3951,3952,3953,3954" effect="flipInX"][/vc_column][vc_column width="1/2"][vc_custom_heading text="Portfolio Style 12" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1476256618888{margin-bottom: 10px !important;}"][ut_header title="Drawing"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Lorem ipsum dolor sit amet, consetetur sadipscing elitr.
[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22United%20Themes%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Design%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#333333" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row]',
        ),

        /* Demo 23 */
        array(
            'name'      => esc_html__( 'Demo 23 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" effect="fadeIn"][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="About Brooklyn." lead_accent_color="#151515"]We\'re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" animate_once="yes" effect="fadeInUp"][ut_service_column size="medium" headline="Brand & Identity" color="#252525" imageicon="5877"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" effect="fadeInUp"][ut_service_column size="medium" headline="UX / UI Design" color="#252525" imageicon="5874"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" effect="fadeInUp"][ut_service_column size="medium" headline="APP Development" color="#252525" imageicon="5879"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/3" animate_once="yes" effect="fadeInUp"][ut_service_column size="medium" headline="Web Development" color="#252525" imageicon="5876"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" effect="fadeInUp"][ut_service_column size="medium" headline="Marketing" color="#252525" imageicon="5878"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" effect="fadeInUp"][ut_service_column size="medium" headline="Customer Support" icon="fa fa-cloud" color="#252525" imageicon="5875"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="fixed" css=".vc_custom_1496792129121{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/quote-section.jpg?id=6023) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)"][vc_column animate_once="yes" css=".vc_custom_1496755241180{padding-top: 0px !important;}" effect="fadeIn"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Poppins%3A300%2Cregular%2C500%2C600%2C700|font_style:700%20bold%20regular%3A700%3Anormal" cite="UNITED THEMES" quote_color="#ffffff" cite_color="#ffffff"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE,
PERFORMANCE LEADS TO SUCCESS![/ut_parallax_quote][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn"][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="The Crew." lead_accent_color="#151515"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.
[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" effect="fadeIn"][vc_column width="1/3" effect="none"][ut_team_member align="left" name="John Brooklyn" avatar="6106" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#151515" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo23%2Fteam-single-page-1%2F|||" line_color="#efefef" ocupation_color="#151515" icon_color_hover="#296af5"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][vc_column width="1/3" effect="none"][ut_team_member align="left" name="Dwayne Smith" avatar="6106" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#151515" line_color="#efefef" icon_color="#151515" icon_color_hover="#296af5" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo23%2Fteam-single-page-2%2F|||"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][vc_column width="1/3" effect="none"][ut_team_member align="left" name="Ruben Lorenz" avatar="6106" occupation="SUPPORT GURU" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#151515" icon_color="#151515" icon_color_hover="#296af5" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fdemo23%2Fteam-single-page-3%2F|||" line_color="#efefef"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_team_member][/vc_column][/vc_row][vc_row animate_once="yes" css=".vc_custom_1496792306503{background-color: #f9f9f9 !important;}" effect="fadeIn"][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Our Services." lead_accent_color="#151515"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][vc_row_inner][vc_column_inner][ut_animated_image size="full" align="center" animate_once="yes" image="4327" effect="none"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/3" animate_once="yes"][ut_service_column animate_once="yes" headline="Retina Ready & Responsive" color="#999999" imageicon="5829" effect="none"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes"][ut_service_column animate_once="yes" headline="One Click Demo Installer" color="#999999" imageicon="5828" effect="none"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][vc_column_inner width="1/3" animate_once="yes"][ut_service_column animate_once="yes" headline="Drag & Drop Page Builder" color="#999999" imageicon="5830" effect="none"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1496755416529{padding-top: 40px !important;padding-bottom: 0px !important;background-color: #151515 !important;}"][vc_column animate_once="yes" effect="fadeIn"][ut_fancy_link link_color="#ffffff" line_color="rgba(255,255,255,0.01)" url="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/contact/" line_hover_color="rgba(255,255,255,0.01)" link_hover_color="rgba(255,255,255,0.7)"]Get in touch with us![/ut_fancy_link][/vc_column][/vc_row][vc_row animate_once="yes" effect="fadeIn"][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Our Work." lead_accent_color="#151515"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_custom_shortcode css=".vc_custom_1496749058743{margin-bottom: 0px !important;}"][ut_showcase id="4272"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row animate_once="yes" css=".vc_custom_1496755472429{margin-top: 120px !important;}" effect="fadeIn"][vc_column][ut_header align="global" lead_accent_font_weight="bold" title="Happy Clients." lead_accent_color="#151515"]The comments below are just a sample of the 26.000 clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" effect="fadeIn"][vc_column][ut_qtrotator_2 arrow_color="#151515" arrow_color_hover="#296af5"][ut_qt_2 avatar="6106" author="Ron Schmidt" origin="Brooklyn Customer"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point. Really looking forward to the upcoming demos, United Themes, you guys do a great job!”[/ut_qt_2][ut_qt_2 avatar="6106" author="John Areus" origin="Brooklyn Customer"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”[/ut_qt_2][ut_qt_2 avatar="6106" author="Henrik Schwarz" origin="Brooklyn Customer"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="6109,6110,6111,6112,6113" effect="zoomIn"][/vc_column][/vc_row][vc_row bklyn_overlay="true" background_position="center center" background_attachment="fixed" animate_once="yes" css=".vc_custom_1496792398892{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/contact-hero-1.jpg?id=5918) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.7)" effect="none"][vc_column animate_once="yes" effect="fadeIn"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Get Connected." css=".vc_custom_1496751859085{margin-bottom: 60px !important;}" title_color="#ffffff" lead_color="#ffffff"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_row_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan=" Follow us on Twitter " icon_color="#ffffff" title_color="#ffffff" slogan_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan=" Join the Conversation " icon_color="#ffffff" title_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" slogan_text_transform="uppercase" icon="fa fa-youtube" title="YouTube" slogan="View Exclusive Videos " icon_color="#ffffff" title_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon shape="normal" slogan_font_weight="normal" slogan_text_transform="uppercase" icon="fa fa-instagram" title="Instagram" slogan="Latest Images" icon_color="#ffffff" title_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" slogan_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row equal_height="yes" content_placement="top"][vc_column width="1/3" animate_once="yes" effect="fadeIn"][ut_header align="left" lead_accent_font_weight="bold" title="About us." lead_accent_color="#151515"]We\'re a creative agency located in Brooklyn, New York. We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][vc_column_text]Banh mi authentic flexitarian meh master cleanse, selfies hella lo-fi sriracha sartorial fam asymmetrical cornhole. Enamel pin seitan ramps green juice. Helvetica +1 fixie, master cleanse gastropub vape ramps biodiesel williamsburg fingerstache.[/vc_column_text][/vc_column][vc_column width="1/3"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="5229" effect="fadeIn"][/vc_column][vc_column width="1/3"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="6106" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section][vc_row full_width="stretch_row_content_no_spaces" equal_height="yes" content_placement="middle" animate_once="yes" css=".vc_custom_1496792542694{margin-top: 0px !important;margin-bottom: 0px !important;padding-top: 0px !important;padding-bottom: 0px !important;}" effect="fadeIn"][vc_column width="1/2" css=".vc_custom_1496792500773{padding-top: 0px !important;}" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" css=".vc_custom_1496802107401{padding-top: 160px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/1.jpg?id=6106) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1496802118093{padding-top: 160px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/1.jpg?id=6106) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1496745940631{margin-top: 0px !important;}"][vc_column_inner width="1/2" css=".vc_custom_1496802126215{padding-top: 160px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/1.jpg?id=6106) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1496802133498{padding-top: 160px !important;padding-bottom: 160px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/1.jpg?id=6106) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" bklyn_overlay="true" animate_once="yes" css=".vc_custom_1496792516928{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/social-bg.jpg?id=5447) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(41,106,245,0.89)" effect="none" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header align="center" lead_accent_font_weight="bold" title="A New Era Begins." lead_accent_color="#ffffff" css=".vc_custom_1494690190031{padding-top: 40px !important;}" title_color="#ffffff" lead_color="#ffffff"]We believe our work speaks for itself. Browse our most recent projects
and enjoy our handmade work with love for every detail.[/ut_header][ut_animated_image size="medium" align="center" image="5608"][vc_custom_heading text="Team Brooklyn" font_container="tag:h6|text_align:center|color:%23ffffff" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1496782998223{margin-bottom: 40px !important;}"][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" lightbox="no" animate_once="yes" delay_animation="true" gallery="6112,6113,6111,6110,6109" effect="zoomIn"][/vc_column][/vc_row][/vc_section]',

        ), 
                
        array(
            'name'      => esc_html__( 'Demo 23 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title="Drop us a line."]We welcome you to contact us for more information
about any of our products or services.[/ut_header][contact-form-7 id="5"][/vc_column][vc_column width="1/2"][ut_service_column_vertical shape="round" headline="Visit us" imageicon="6061" css=".vc_custom_1496796648981{margin-bottom: 60px !important;}"]1399 Beverley Rd
Brooklyn, NY 11218[/ut_service_column_vertical][ut_service_column_vertical shape="round" headline="Mail us" imageicon="6056" css=".vc_custom_1496796655038{margin-bottom: 60px !important;}"]contact@yourdomain.com[/ut_service_column_vertical][ut_service_column_vertical shape="round" headline="Call us" imageicon="6060" css=".vc_custom_1496796662470{margin-bottom: 60px !important;}"]1-8456-563-BKLYN[/ut_service_column_vertical][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Services Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" effect="fadeIn"][vc_column width="1/3"][ut_service_column size="medium" imageicon="5829" headline="Retina Ready & Responsive"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column size="medium" imageicon="5828" headline="One Click Demo Installer"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column size="medium" imageicon="5830" headline="Drag & Drop Page Builder"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" effect="fadeIn"][vc_column width="1/3"][ut_service_column size="medium" imageicon="5877" headline="25+ Demos"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column size="medium" imageicon="5874" headline="Unlimited Design Options"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column size="medium" imageicon="5876" headline="8 Different Hero Types"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" effect="fadeIn"][vc_column width="1/3"][ut_service_column size="medium" imageicon="5878" headline="115+ Predefined Page Layouts"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column size="medium" imageicon="5875" headline="Awesome Customer Support"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column size="medium" imageicon="5879" headline="Free Content Updates"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section][vc_row bklyn_overlay="true" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1496802180714{padding-top: 160px !important;padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/1.jpg?id=6106) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(41,106,245,0.9)" effect="fadeIn"][vc_column][ut_qtrotator_2 arrow_color="#ffffff" name_color="#ffffff" quote_color="#ffffff" origin_color="#ffffff" arrow_color_hover="rgba(255,255,255,0.7)"][ut_qt_2 author="Ron Schmidt" origin="Brooklyn Customer"]“I’m really enjoying this theme so far, very easy to use, the markups makes alot of sense, and the design is on point. Really looking forward to the upcoming demos, United Themes, you guys do a great job!”
[/ut_qt_2][ut_qt_2 author="John Areus" origin="Brooklyn Customer"]“I bought my first license back in 2013 and loved this theme from the very first beginning. The fact, that in meantime the theme received lots of updates and new demos is simply a big big plus. The Design is outstanding and my customers are loving it.”
[/ut_qt_2][ut_qt_2 author="Henrik Schwarz" origin="Brooklyn Customer"]“The one and only WordPress Theme. Love it. Great support too!!! This is awesome! Please keep up the great work!”
[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" effect="fadeIn"][vc_column][ut_header title="The Crew." lead_accent_color="#151515"]We believe in a diverse range of personel to bring creative skills,
thoughts, and ideas to the table.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" effect="fadeIn"][vc_column width="1/4"][ut_team_member align="left" name="Helmut Brooklyn" occupation="CEO " values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802218904{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="Hans Glueck" occupation="DESIGNER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802226937{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Frank Brooklyn" occupation="THE SON" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802237208{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="Robert Wolf" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802244568{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Max Brooklyn" occupation="THE BROTHER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802252215{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="Titus Cronos" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802260520{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][vc_column width="1/4"][ut_team_member align="left" name="Helm Brooklyn" occupation="THE NEPHEW" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802268091{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][ut_team_member align="left" name="San Richter" occupation="DEVELOPER" values="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3AFacebook%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitter%7Ctarget%3A%2520_blank%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7Ctitle%3ATwitch%7Ctarget%3A%2520_blank%7C%22%7D%5D" icon_color="#151515" avatar="6106" ocupation_color="#151515" css=".vc_custom_1496802275343{margin-bottom: 60px !important;}"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidun.[/ut_team_member][/vc_column][/vc_row][vc_row animate_once="yes" css=".vc_custom_1496760117277{margin-bottom: 0px !important;background-color: #296af5 !important;}" effect="none"][vc_column width="1/4" animate_once="yes" effect="fadeIn"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="Any question at" headline_margin_bottom="0px" imageicon="6068"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4" animate_once="yes" effect="fadeIn"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="1399 Beverly Rd" headline_margin_bottom="0px" imageicon="6067"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4" animate_once="yes" effect="fadeIn"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="Mon - Sat" headline_margin_bottom="0px" imageicon="6065"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4" animate_once="yes" effect="fadeIn"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="Send your mail at" headline_margin_bottom="0px" imageicon="6066"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Single Page 1', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="left" title="John Brooklyn" title_color="#252525"]Hello, I\'m John designer at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" name="John Brooklyn" avatar="6106" occupation="DESIGNER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#151515" icon_color_hover="#296af5" ocupation_color="#151515"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="About John" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="900" info_text_transform="uppercase" info="PHP Coding" info_color="#151515" color="#151515" percentage_color="#ffffff" percentage_bg_color="#151515"][ut_probar_thin width="95" animate_once="yes" info_font_weight="900" info_text_transform="uppercase" info="jQuery Coding" info_color="#151515" color="#151515" percentage_color="#ffffff" percentage_bg_color="#151515"][ut_probar_thin width="98" animate_once="yes" info_font_weight="900" info_text_transform="uppercase" info="Plugin Development" info_color="#151515" color="#151515" percentage_color="#ffffff" percentage_bg_color="#151515"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1496762422820{margin-top: 80px !important;margin-bottom: 0px !important;background-color: #296af5 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="Any question at" headline_margin_bottom="0px" imageicon="6068"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="1399 Beverly Rd" headline_margin_bottom="0px" imageicon="6067"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="Mon - Sat" headline_margin_bottom="0px" imageicon="6065"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#ffffff" text_color="#ffffff" color="#ffffff" headline="Send your mail at" headline_margin_bottom="0px" imageicon="6066"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][/vc_section]',

        ),
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Single Page 2', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1496795059503{margin-bottom: 10px !important;}"][ut_header align="left" title="Dwayne Smith" title_color="#252525"]Hello, I\'m Dwayne coder at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" name="Dwayne Smith" avatar="6106" occupation="CODER" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#151515" icon_color_hover="#296af5" ocupation_color="#151515"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="About Dwayne" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="900" info_text_transform="uppercase" info="PHP Coding" info_color="#151515" color="#151515" percentage_color="#ffffff" percentage_bg_color="#151515"][ut_probar_thin width="95" animate_once="yes" info_font_weight="900" info_text_transform="uppercase" info="jQuery Coding" info_color="#151515" color="#151515" percentage_color="#ffffff" percentage_bg_color="#151515"][ut_probar_thin width="98" animate_once="yes" info_font_weight="900" info_text_transform="uppercase" info="Plugin Development" info_color="#151515" color="#151515" percentage_color="#ffffff" percentage_bg_color="#151515"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1496795184792{margin-bottom: 0px !important;background-color: #f9f9f9 !important;}"][vc_column width="1/4"][ut_service_column headline_color="#151515" headline="Any question at" headline_margin_bottom="0px" imageicon="6060"]1-8456-563-BKLYN[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#151515" color="#ffffff" headline="1399 Beverly Rd" headline_margin_bottom="0px" imageicon="6061"]Brooklyn, NY 11218[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#151515" headline="Mon - Sat" headline_margin_bottom="0px" imageicon="6055"]8 am – 8 pm[/ut_service_column][/vc_column][vc_column width="1/4"][ut_service_column headline_color="#151515" headline="Send your mail at" headline_margin_bottom="0px" imageicon="6056"]contact@yourdomain.com[/ut_service_column][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Team Single Page 3', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1496795970303{padding-bottom: 0px !important;}"][vc_row][vc_column][vc_custom_heading text="his story" font_container="tag:h6|font_size:25px|text_align:left|color:%23dddddd" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1496795929551{margin-bottom: 10px !important;}"][ut_header align="left" title="Ruben Lorenz"]Hello, I\'m Ruben guru at Brooklyn Designs.
[/ut_header][vc_row_inner][vc_column_inner width="1/2"][ut_team_member align="left" name="Ruben Lorenz" avatar="6106" occupation="SUPPORT GURU" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#151515" icon_color_hover="#296af5" ocupation_color="#151515"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="About Ruben" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing.[/vc_column_text][ut_probar_thin width="99" animate_once="yes" info_font_weight="900" info="Project Management" info_color="#151515" color="#151515" percentage_color="#ffffff" percentage_bg_color="#151515"][ut_probar_thin width="97" animate_once="yes" info_font_weight="900" info="Web Design" info_color="#252525" color="#252525" percentage_color="#ffffff" percentage_bg_color="#252525"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row_content" css=".vc_custom_1496795924270{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column css=".vc_custom_1477939807253{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][ut_custom_shortcode css=".vc_custom_1477939724912{margin-bottom: 0px !important;}"][ut_showcase id="4642"][/ut_custom_shortcode][/vc_column][/vc_row][/vc_section]',

        ),         
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Cap Mock-Up', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="Cap Mock-Up"]Advanced, easy to edit mockup. It contains everything you need to create a realistic look of your project.
Guarantees the a good look for bright and dark designs and perfect fit to the shape.
Easy to navigate, well described layers, friendly help file.[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2" css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="5409" effect="fadeIn"][/vc_column][vc_column width="1/2" css=".vc_custom_1475504625537{padding-left: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="5411" effect="fadeIn"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title="Endless Possibilities"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]Create One-Page or Multi-Page websites easily by using the Visual Composer per Drag & Drop or use shortcodes. It’s up to you!
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1496785482707{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/p5-1-2.jpg?id=5405) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" css=".vc_custom_1475587884140{padding-top: 0px !important;}"][ut_header align="left" title="Powerful Admin Panel" title_color="#252525"][/ut_header][/vc_column][vc_column width="1/2"][ut_header align="left"]That will cover all your basic needs! You don’t need to touch a single line of code, perfect for people without any coding knowledge. Individualize Layouts, Colours & Styles within minutes.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1496785493080{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo23/wp-content/uploads/2016/10/p5-3-1.jpg?id=5407) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1476191211666{padding-top: 0px !important;}"][ut_header align="center" title="Thank You" css=".vc_custom_1494726690801{margin-bottom: 60px !important;}"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="7 photorealistic presentations" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%20Elements%22%7D%2C%7B%22title%22%3A%22BY%3A%22%2C%22description%22%3A%22Yogurt86%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22Visit%20Prokect%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttps%253A%252F%252Felements.envato.com%252Fitems%252Ftype%252Fgraphic-templates%252Fcap-mock-up-GSARW7%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" title_color="#151515"][/vc_column_inner][vc_column_inner width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" animate_once="yes" delay_animation="true" gallery="5405,5406,5407,5408,5409,5411" effect="fadeIn"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#151515" icon_color="#B9B9B9" border_color="#efefef"][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Poster Mock-Up', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column width="1/2" effect="fadeIn"][ut_header align="left" title="Poster Mock-Up"]Clean and elegant poster mockup to quickly present via smart layers your design work.[/ut_header][vc_row_inner][vc_column_inner][vc_custom_heading text="Unio proudly presents “Poster Mockup”." font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%20Elements%22%7D%2C%7B%22title%22%3A%22BY%3A%22%2C%22description%22%3A%22UnioCS%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttps%253A%252F%252Fgoo.gl%252FCltj55%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" title_color="#151515"][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#151515" icon_color="#b9b9b9" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" gap="40" caption="yes" animate_once="yes" delay_animation="true" gallery="5379,5380,5381,5382,5383,5384" effect="fadeIn"][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Smoothie Plastic Bottle Mock-Up', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1496752754448{background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1477935187461{padding-top: 0px !important;}"][ut_header align="left" title="Smoothie Plastic Bottle Mock-Up"]Showcase your design with this Plastic Bottle Mock-Up. This photorealistic PSD templates is fully editable. With smart object included you can edit the layers of the graphic canvas or remove them completely and place your own graphics inside, without worrying about perspective, light and shadow effects.[/ut_header][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#151515" icon_color="#b9b9b9" border_color="#efefef"][/vc_column][vc_column width="1/2" css=".vc_custom_1496752703814{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" image="5376" effect="fadeIn"][/vc_column][/vc_row][vc_row css=".vc_custom_1496752828991{padding-top: 0px !important;background-color: #ffffff !important;}"][vc_column width="1/2" css=".vc_custom_1496752711916{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" image="5369" effect="fadeIn"][vc_custom_heading text="7 Photorealistic Mock-Ups" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" css=".vc_custom_1496752715630{padding-top: 0px !important;}"][ut_animated_image size="large" align="center" animate_once="yes" image="5365" effect="fadeIn"][vc_custom_heading text="Fully editable via smart object’s" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1496752869474{margin-top: 0px !important;}"][vc_column][ut_animated_image size="large" align="center" animate_once="yes" image="5377" css=".vc_custom_1478284989351{margin-bottom: 120px !important;}" effect="fadeIn"][vc_row_inner][vc_column_inner width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" caption="yes" animate_once="yes" delay_animation="true" gallery="5370,5371,5369,5367,5365,5364" effect="fadeIn"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Photorealistic Result" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%20Elements%22%7D%2C%7B%22title%22%3A%22BY%3A%22%2C%22description%22%3A%22L5Design%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttps%253A%252F%252Fgoo.gl%252Fy152sQ%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" title_color="#151515"][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#151515" icon_color="#b9b9b9" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Software Box Mock-Up', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="left" title="Software Box Mock-Up"]Advanced, easy to edit mockup. It contains everything you need to create a realistic look of your project. Guarantees the a good look for bright and dark designs and perfect fit to the shape. Easy to navigate, well described layers, friendly help file.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%20Elements%22%7D%2C%7B%22title%22%3A%22BY%3A%22%2C%22description%22%3A%22Yogurt86%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttps%253A%252F%252Felements.envato.com%252Fitems%252Ftype%252Fgraphic-templates%252Fsoftware-box-mock-up-8ABLFC%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" title_color="#151515"][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" gap="40" animate_once="yes" delay_animation="true" gallery="5391,5392,5393,5394,5395" effect="fadeInUp"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="6 photorealistic presentations" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Photoshop CS 5 or higher compatible" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#151515" icon_color="#b9b9b9" border_color="#efefef"][/vc_column][/vc_row][/vc_section]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Trendy Vintage Logos & Badges', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="Trendy Vintage
Logos & Badges"]16 Logos, badges and insignias ready to use, fully editable.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" animate_once="yes" delay_animation="true" gallery="5137,5141,5140,5139,5138,5135" effect="fadeIn"][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-lg-offset-4 vc_col-lg-6"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%20Elements%22%7D%2C%7B%22title%22%3A%22BY%3A%22%2C%22description%22%3A%22Designdistrictmx%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttps%253A%252F%252Felements.envato.com%252Fitems%252Ftype%252Fgraphic-templates%252Ftrendy-vintage-logos-badges-NS9FEG%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" title_color="#151515"][/vc_column][/vc_row][vc_row][vc_column offset="vc_col-lg-offset-4 vc_col-lg-6"][ut_social_share_bar share_text="SHARE:" share_text_color="#151515" icon_color="#b9b9b9"][/vc_column][/vc_row]',

        ), 
        
        array(
            'name'      => esc_html__( 'Demo 23 - Portfolio Yogurt Mock-Up', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" effect="fadeIn"][vc_column][ut_header align="left" title="Four Plastic Container for
Yogurt Mock-Up"]This photorealistic PSD templates is fully editable. With smart object included you can edit the layers of the graphic canvas or remove them completely and place your own graphics inside, without worrying about perspective, light and shadow effects. You can adjust the effect of light, shadow and reflects.[/ut_header][vc_row_inner][vc_column_inner width="5/6"][ut_gallery_slider autoplay="true" effect_in="fadeIn" effect_out="fadeOut" slides="5354,5355,5356,5357,5358,5359,5360,5361,5362"][/vc_column_inner][vc_column_inner width="1/6"][ut_image_gallery thumbnail_size="large" gap="40" caption="yes" animate_once="yes" gallery="5355,5356,5357" effect="fadeIn"][ut_portfolio_details values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%20Elements%22%7D%2C%7B%22title%22%3A%22BY%3A%22%2C%22description%22%3A%22L5Design%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22Visit%20Project%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttps%253A%252F%252Fgoo.gl%252FRyZaQk%7C%7Ctarget%3A%2520_blank%7C%22%7D%5D" title_color="#151515"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Four Plastic Container" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Features" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#B9B9B9" border_color="#efefef" share_text_color="#151515"][/vc_column][/vc_row][/vc_section]',

        ), 
        
                
        /* Demo 24 */
        array(
            'name'      => esc_html__( 'Demo 24 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_row equal_height="yes" content_placement="top"][vc_column width="1/2"][ut_animated_image size="large"][/vc_column][vc_column width="1/2"][vc_custom_heading text="John Brooklyn" font_container="tag:h6|font_size:17px|text_align:left|color:%23ff1654" use_theme_fonts="yes" css=".vc_custom_1494630178607{margin-bottom: 20px !important;}"][ut_header align="left" title="I\'m John, designer and photographer at United Themes. "]I love traveling, steaks, hot dogs and lots of blond beer. You can also find me on Twitter and Facebook. I collect inspirations on Pinterest and save all my pics at Instagram.[/ut_header][vc_custom_heading text="What I love" font_container="tag:h6|font_size:17px|text_align:left|color:%23ff1654" use_theme_fonts="yes" css=".vc_custom_1494630184436{margin-bottom: 20px !important;}"][vc_row_inner][vc_column_inner width="1/2"][ut_fancy_list values="%5B%7B%22title%22%3A%22Family%20Stuff%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22Web%20Design%22%7D%2C%7B%22title%22%3A%22Photography%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22%20Bicycle%22%2C%22is_link%22%3A%22true%22%7D%5D" text_color="#151515"][/vc_column_inner][vc_column_inner width="1/2"][ut_fancy_list values="%5B%7B%22title%22%3A%22Good%20Food%22%7D%2C%7B%22title%22%3A%22Cold%20Beer%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22Classic%20Music%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22Old%20Culture%22%2C%22is_link%22%3A%22true%22%7D%5D" text_color="#151515"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][vc_empty_space][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-facebook" title="Facebook" slogan="Give me a like on Facebook" icon_hover_color="#ff1654" title_color="#ff1654" slogan_color="#151515" icon_color="#151515"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-twitter" title="Twitter" slogan="Follow me on Twitter" icon_color="#151515" icon_hover_color="#ff1654" title_color="#ff1654" slogan_color="#151515"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-instagram" title="Instagram" slogan="See my latest photos on Instagram" icon_color="#151515" icon_hover_color="#ff1654" title_color="#ff1654" slogan_color="#151515"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 24 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row" bklyn_overlay="true" css=".vc_custom_1494716995768{padding-top: 120px !important;padding-bottom: 120px !important;background-color: #161616 !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0.4)"][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-facebook" title="Facebook" slogan="Give me a like on Facebook" icon_hover_color="rgba(255,255,255,0.7)" title_color="#ffffff" slogan_color="#ffffff" icon_color="#ffffff"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-twitter" title="Twitter" slogan="Follow me on Twitter" icon_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" title_color="#ffffff" slogan_color="#ffffff"][/vc_column][vc_column width="1/3"][ut_big_icon shape="normal" icon="fa fa-instagram" title="Instgram" slogan="See my latest photos on Instagram" icon_color="#ffffff" icon_hover_color="rgba(255,255,255,0.7)" title_color="#ffffff" slogan_color="#ffffff"][/vc_column][/vc_row][vc_row][vc_column][vc_empty_space][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_header title="Get in touch with John Brooklyn."]We have created an awesome theme that will help designers,
developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][vc_column width="1/2"][vc_custom_heading text="Write John" font_container="tag:h6|font_size:17px|text_align:left|color:%23ff1654" use_theme_fonts="yes" css=".vc_custom_1494630297405{margin-bottom: 20px !important;}"][contact-form-7 id="15"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 24 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][ut_header title="Hi, I\'m John, John Brooklyn designer
and photographer at United Themes." font_size="50px"]We have created an awesome theme that will help designers,
developers and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row][vc_column][vc_empty_space][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_image_gallery thumbnail_size="large" grid="5" gap="5" caption="yes" animate_once="yes" delay_animation="true" gallery="27,26,25,24,23,22,21,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,76" effect="fadeInUp" delay_timer="100"][/vc_column][/vc_row][vc_row][vc_column][vc_empty_space height="35px"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 24 - Private Gallery', 'ut_shortcodes' ),
            'content'   => '[vc_row][vc_column][vc_empty_space][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" animate_once="yes" delay_animation="true" caption_transform="uppercase" gallery="26,27,59,71,70,61,49,50,62,76,63,51,52,64,73,72,60,48,25,57,69,68,56,24,23,55,67,66,54,22,21,53" delay_timer="100" effect="zoomIn" caption_color="#ffffff" caption_background="rgba(255,22,84,0.9)"][/vc_column][/vc_row]',
        ),
        
        
        /* Demo 25 */
        array(
            'name'      => esc_html__( 'Demo 25 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content" css=".vc_custom_1477926378383{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/2"][ut_header align="left" title="What We Do..." title_color="#252525"]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Nature Photography" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Adventure Photography" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="20" caption="yes" animate_once="yes" delay_animation="true" gallery="74,78,36,82" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 25 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content"][vc_column][ut_header align="left" title="Let\'s Start Our Journey..." title_color="#252525"]We have created an awesome theme that will help designers, developers,
and companies create websites for their startups quickly and easily.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column width="1/2"][vc_custom_heading text="Tell us your story" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes"][contact-form-7 id="134"][vc_empty_space height="20px"][ut_social_share_bar share_text="SHARE:" border="true" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/2"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 25 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" animate_once="yes" delay_animation="true" gallery="36,78,67,68,69,76,70,71,72,73,74,75,77,79,80,81,82,83,84,85" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 25 - Private Page', 'ut_shortcodes' ),
            'content'   => '[vc_row full_width="stretch_row_content"][vc_column][ut_image_gallery thumbnail_size="large" grid="5" gap="20" caption="yes" animate_once="yes" delay_animation="true" gallery="86,85,73,74,36,72,84,83,71,70,82,81,69,68,80,67,79,78,76,75" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 26 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1496316007823{background-color: #111314 !important;}" bklyn_section_anchor_id="about"][vc_row hide_on_tablet="true" hide_on_mobile="true" animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header title="I\'m a creative freelancer located in Brooklyn, New York. I’ve won a ton of awards and have been featured in all of the magazines." title_color="#ffffff"][/ut_header][/vc_column][/vc_row][vc_row hide_on_desktop="true" animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header title="I\'m a creative freelancer located in Brooklyn, New York. I’ve won a ton of awards and have been featured in all of the magazines." title_color="#ffffff" font_size="25px"][/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/3" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][ut_service_column shape="round" headline="MOBILE DESIGN" imageicon="123" text_color="#d1d1cf" headline_color="#e8e8e6" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][ut_service_column shape="round" headline="WEB DESIGN" imageicon="126" text_color="#d1d1cf" headline_color="#e8e8e6" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][vc_column width="1/3" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][ut_service_column shape="round" headline="PHOTOGRAPHY" imageicon="278" text_color="#d1d1cf" headline_color="#e8e8e6" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496316230426{padding-bottom: 0px !important;}"][vc_row hide_on_tablet="true" hide_on_mobile="true" effect="none" css=".vc_custom_1496425752192{background-color: #ff3f00 !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50" offset="vc_hidden-md vc_hidden-sm vc_hidden-xs"][ut_header style="global" align="global" title="Browse my most recent projects below and enjoy my handmade work with love for every detail." title_color="#ffffff"][/ut_header][/vc_column][/vc_row][vc_row hide_on_desktop="true" effect="none" css=".vc_custom_1496425756570{background-color: #ff3f00 !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header style="global" align="global" title="Browse my most recent projects below and enjoy my handmade work with love for every detail." title_color="#ffffff" font_size="25px"][/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1496418932119{margin-top: 0px !important;}" bklyn_section_anchor_id="portfolio"][vc_column][ut_custom_shortcode css=".vc_custom_1496315950159{margin-bottom: 0px !important;}"][ut_showcase id="138" name="Demo 26 – Showcase"][/ut_custom_shortcode][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496421318519{background-color: #ff3f00 !important;}" bklyn_section_anchor_id="Contact"][vc_row hide_on_tablet="true" hide_on_mobile="true"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header align="left" title="I welcome you to contact me for more information about any of my products or services." title_color="#ffffff" lead_accent_color="#ffffff"][/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#ffffff" text_color="#ffffff" icon_color_hover="#ffffff" text_color_hover="#ffffff"][vc_custom_heading text="FOLLOW ME ON" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1496417267509{margin-bottom: 40px !important;}"][ut_social_follow gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#ffffff" icon_color_hover="#ffffff"][/vc_column][/vc_row][vc_row hide_on_desktop="true"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header align="left" title="I welcome you to contact me for more information about any of my products or services." title_color="#ffffff" lead_accent_color="#ffffff" font_size="25px"][/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#ffffff" text_color="#ffffff" icon_color_hover="#ffffff" text_color_hover="#ffffff"][vc_custom_heading text="FOLLOW ME ON" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1496417267509{margin-bottom: 40px !important;}"][ut_social_follow gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#ffffff" icon_color_hover="#ffffff"][/vc_column][/vc_row][/vc_section]',
        ),
        
        /* Demo 27 */
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post All The Trimmings', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Get the full audio experience without disturbing the neighbors. Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496189385801{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/gabriel-beaudry-253369.jpg?id=2185) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="35" cite_font_size="18" quote_color="#ffffff" cite="Some Guy" cite_color="#ffffff"]These headphones are absolutely brilliant. Amazing sound quality that I had never experience through headphone until I bought these.[/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Whats in the box?</h2>
<strong>Not only are the HD 598 aesthetically pleasing to the eyes but they also provide impeccable sound quality and unrivalled comfort. These beige-coloured, open, circumaural headphones come with high-gloss burl wood parts and matching earpads for a sophisiticated, premium finish.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="3" caption="yes" gallery="2185,2184,2182"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth.

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Become Legend', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496189606256{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service1.jpg?id=3076) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_font_size="35" cite_font_size="18" quote_color="#ffffff" cite_color="#ffffff"]BECOME LEGEND[/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>What is about Part 2?</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.
The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1496161873814{padding-top: 40px !important;padding-bottom: 40px !important;}"][vc_column][ut_gallery_slider type="carousel" number="4" hover_caption="on" slides="2185,2184,2182,2894"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Minimalistic Interior', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Minimalist interior design is one of the architectural centerpieces of the 20th century. Spare and streamlined while still being inviting, minimalism is charming in almost any space.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496189818538{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service2.jpg?id=3077) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="35" quote_text_transform="capitalize" cite_font_size="18" cite_text_transform="uppercase" quote_color="#ffffff" cite="United Themes™" cite_color="#ffffff"]Passion Leads to Design, Design Leads to Performance,
Performance Leads to success![/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Things to make you go OOH</h2>
[caption id="attachment_2894" align="alignleft" width="300"]<img class="wp-image-2894 size-medium" src="http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/7-300x300.jpg" alt="" width="300" height="300" /> We <i class="fa fa-heart"></i> Brooklyn[/caption]

<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" gallery="2185,2184,2182,2894"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Music Is The Key', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496162923926{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/music-key.jpg?id=3787) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_font_size="35" quote_text_transform="uppercase" cite_font_size="18" quote_color="#ffffff" cite_color="#ffffff"]We Love Music[/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Our last night!</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.
The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][ut_image_gallery thumbnail_size="large" grid="4" caption="yes" gallery="3791,3792,3793,3794"][vc_column_text]When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>What is your favorite song?</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.
The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Blog Post Organic Food', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_column_text]<strong>Organic food has become very popular. But navigating the maze of organic food labels, benefits, and claims can be confusing.</strong>

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][ut_image_gallery thumbnail_size="medium" grid="5" caption="yes" animate_once="yes" delay_animation="true" gallery="2037,2038,2039,2041,2043,2044,2045,2046,2047,2048,2058,2057,2056,2055,2059" effect="fadeIn"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]
<h2>Organic vs. Non-Organic</h2>
<strong>I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now.</strong>

Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way.

When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_gallery_slider type="carousel" number="2" number_tablet="2" caption="on" slides="2068,2067,2069,2070"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.[/vc_column_text][/vc_column][/vc_row][/vc_section]',                
        ),        
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio Beautiful Minimalist', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header title="BEAUTIFUL MINIMALIST" title_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22May%2029%2C%202017%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" grid="5" caption="yes" delay_animation="true" gallery="2900,3078,3077,3076,2901,2898,2480,2894,2897,3829" delay_timer="150" effect="fadeIn"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_column][ut_social_share_bar border="true" share_text="SHARE:"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio Custom Cap', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][ut_header style="pt-style-4" align="center" title="CAP MOCK-UP"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row][vc_column css=".vc_custom_1475504630256{padding-right: 0px !important;}"][ut_image_gallery thumbnail_size="large" grid="2" caption="yes" animate_once="yes" delay_animation="true" gallery="3078,3077" delay_timer="100" effect="fadeInUp"][/vc_column][/vc_row][/vc_section][vc_section][vc_row equal_height="yes" content_placement="middle" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][ut_header style="pt-style-4" align="center" title="ENDLESS POSSIBILITIES"]Create One-Page or Multi-Page websites <b>easily</b> by using the
Visual Composer per <b>Drag &amp; Drop</b> or use shortcodes. It’s up to you![/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="large" caption="yes" animate_once="yes" delay_animation="true" gallery="3078" delay_timer="100" effect="fadeInUp"][/vc_column][/vc_row][/vc_section][vc_section][vc_row content_placement="middle" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][ut_header style="pt-style-4" align="center" title="INTUITIVE ADMIN PANEL" title_color="#252525"]You don’t need to touch a single line of code,
<b>perfect</b> for people <b>without</b> any <b>coding knowledge.</b>
[/ut_header][/vc_column][/vc_row][vc_row hide_on_desktop="true"][vc_column][ut_image_gallery thumbnail_size="large" caption="yes" animate="false" gallery="3077"][/vc_column][/vc_row][vc_row full_height="yes" background_position="center center" background_attachment="scroll" hide_on_tablet="true" hide_on_mobile="true" css=".vc_custom_1496189986184{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service1.jpg?id=3076) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="none"][vc_column][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_column_text]It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen. She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then.

The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli, but the Little Blind Text didn’t listen.[/vc_column_text][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#ffbf00" text_color_hover="#ffbf00"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="#ffbf00"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio Disc & Cover Design', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][vc_custom_heading text="WHAT WE DID" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1496096150343{margin-bottom: 10px !important;}"][ut_header title="DISC &amp; COVER DESIGN"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_image_gallery thumbnail_size="full" grid="3" gap="40" caption="yes" animate_once="yes" delay_animation="true" gallery="3149,3148,3150" effect="fadeIn" caption_color="#151515" caption_background="rgba(255,191,0,0.8)" delay_timer="150"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_column width="1/2"][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22Creative%2C%20Design%22%2C%22link%22%3A%22%7C%7C%7C%22%7D%2C%7B%22title%22%3A%22AUTHOR%3A%22%2C%22description%22%3A%22United%20Themes%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#333333"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][ut_custom_shortcode][/ut_custom_shortcode][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="250"][vc_column][ut_social_share_bar share_text_font_weight="bold" border="true" share_text="SHARE:"][/vc_column][/vc_row][/vc_section][vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="150"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1496096081298{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#151515" text_color_hover="rgba(21,21,21,0.5)"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="rgba(21,21,21,0.5)"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Portfolio My Awesome Bike', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="MY AWESOME BIKE" title_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left|color:%23252525" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar border="true" share_text="SHARE:"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Front Page', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="about"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header align="center" title="ABOUT BROOKLYN"]We’re a creative agency located in <b>Brooklyn, New York.</b>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3"][ut_service_column headline="APP DEVELOPMENT" imageicon="1358" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="WEB DESIGN" imageicon="1581" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="UI DESIGN" imageicon="1362" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column width="1/3"][ut_service_column headline="BRAND &amp; IDENTITY" imageicon="1590" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="CONSULTANCY" imageicon="1588" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="MARKETING" imageicon="1652" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1495489285314{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/bklyn-section-1.jpg?id=2514) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)" effect="none"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_font_size="35" quote_text_transform="uppercase" cite_font_size="14" cite_text_transform="uppercase" cite="United Themes – Development Brooklyn" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE,
PERFORMANCE LEADS TO <ins>SUCCESS!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="Team"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header style="global" align="center" title="BROOKLYN\'S CREW"]We believe in a diverse range of personel to bring <b>creative skills,
thoughts,</b> and <b>ideas</b> to the table.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="JOHN" avatar="3855" occupation="DEVELOPER / <b>DESIGNER</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="DWAYNE" avatar="3855" occupation="DEVELOPER / <b>CODER</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-youtube%22%2C%22title%22%3A%22YouTube%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22Email%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="BRUCE" avatar="3855" occupation="STAFF / <b>SUPPORT</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-vimeo%22%2C%22title%22%3A%22Vimeo%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="NICK" avatar="3855" occupation="STAFF / <b>SUPPORT</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1495963738985{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/section-archievements-1.jpg?id=2529) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="150"][vc_column_inner][ut_header style="global" align="center" title="OUR ARCHIEVEMENTS" title_color="#ffffff" lead_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Office-Desk-2" to="3000" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="h"]Working Hours[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Rocket-Launch" to="40000" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="+"]Customers Worldwide[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Mustache-1" to="17" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="."]Design Awards[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1495994782208{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #141618 !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="250"][ut_fancy_link link_color="#ffffff" line_color="#ffffff" link_hover_color="#ffbf00" line_hover_color="#ffbf00" url="#contact-section"] Drop us a line [/ut_fancy_link][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="Services"][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496187665145{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/1.jpg?id=3855) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_tablet="true" delay="true" effect="fadeIn" delay_timer="50"][vc_column_inner][ut_header style="global" align="center" title="OUR SERVICES" title_color="#ffffff" lead_color="#ffffff"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <b>know-how</b> and <b>experience</b> in your <b>daily business.</b>[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="TEMPLATE INSTALLER" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Download" headline_margin_bottom="20px"]Brooklyn has made the Theme Installer popular on the market![/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="TEMPLATE BUILDER" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Computer-Network-2" headline_margin_bottom="20px"]Web design without any coding and right at your fingertips![/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="CUSTOMIZE EVERYTHING" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Lens-1" headline_margin_bottom="20px"]From header to footer and everything what’s in between.[/ut_service_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="work"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header style="global" align="center" title="OUR WORK"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column][ut_custom_shortcode css=".vc_custom_1496080035830{margin-bottom: 0px !important;}"][ut_showcase id="1637" name="Demo 1 – Front Page"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496080103092{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/bklyn-section-2.jpg?id=2515) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column_inner][ut_header style="global" align="center" title="GET CONNECTED" title_color="#ffffff" lead_color="#ffffff"]Get yourself ready for an <b>awesome experience</b> with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan=" Follow us on Twitter " icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-behance" title="Behance" slogan="See our latest works" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-instagram" title="Instagram" slogan="Latest Images" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="clients"][vc_row][vc_column][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header style="global" align="center" title="OUR CLIENTS"]The comments below are just a sample of the <b>25.500</b> clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column_inner][/vc_row_inner][ut_qtrotator_2 effect="fadeInUp" quote_custom_font="yes" animate_once="yes" delay="true" effect_in="slideInLeft" effect_out="slideOutRight" arrow_color="#151515" arrow_color_hover="#ffbf00" quote_color="#777777" origin_color="#151515" quote_font="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="16px" quote_line_height="32px" name_color="#151515" logo_color="#151515" delay_timer="100" css=".vc_custom_1496096940850{margin-top: 40px !important;}"][ut_qt_2 avatar="3855" author="CUSTOMER" origin="LAS VEGAS, NV" icon_bklyn="BklynIcons-Rocket-Launch"]"Genuinely love this theme. So sick of trawling through endless menus and options on other themes. Brooklyn is so intuitive with where all its settings are located and is just a pleasure to use. Also, the sheer number of demos and ability to mix elements from different demos means it works well for so many purposes."[/ut_qt_2][ut_qt_2 avatar="3855" author="CUSTOMER" origin="HOUSTON, TX" icon_bklyn="BklynIcons-Diamond"]“Beautiful Theme! Awesome built-in features with some great built in Plug-ins! A well designed and well thought out Dashboard! 100/100 Would recommend!”[/ut_qt_2][ut_qt_2 avatar="3855" author="CUSTOMER" origin="BROOKLYN, NY" icon_bklyn="BklynIcons-Angry-Birds"]"Amazing theme – just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them."[/ut_qt_2][ut_qt_2 avatar="3855" author="CUSTOMER" origin="MIAMI, FL" icon_bklyn="BklynIcons-Stormtrooper-2"]“Great theme with great flexibility. A lot of ready-to-go demos which can be installed with a single click. Really great support if needed. With most updates, there is a new demo added to the bundle.”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row css=".vc_custom_1495890143958{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #141618 !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="3862,3863,3864,3865,3866" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][/vc_section]',

        ),
        array(
            'name'      => esc_html__( 'Demo 27 - About Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column delay="true" effect="none"][vc_custom_heading text="WHO WE ARE..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495860887765{margin-bottom: 10px !important;}"][ut_header title="DESIGNERS, THINKERS
&amp; COLLABORATORS" title_accent_color="#ffbf00"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create<b> websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="50"][ut_team_member align="left" ocupation_font_size="large" name="JOHN BROOKLYN" social="%5B%7B%7D%5D" occupation="CEO & Founder" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow John" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="100"][ut_team_member align="left" ocupation_font_size="large" name="DWAYNE RUSSEL" social="%5B%7B%7D%5D" occupation="CTO & Company Partner" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow Dwayne" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="150"][ut_team_member align="left" ocupation_font_size="large" name="BRUCE AMIREZ" social="%5B%7B%7D%5D" occupation="Marketing Expert" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow Bruce" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-linkedin%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-steam%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][vc_column width="1/4" animate_once="yes" delay="true" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="200"][ut_team_member align="left" ocupation_font_size="large" name="NICK BRONSEN" social="%5B%7B%7D%5D" occupation="Hardcore Coder" icon_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna. Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_team_member][vc_custom_heading text="Follow Nick" font_container="tag:h6|text_align:left" use_theme_fonts="yes" text_transform="uppercase"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22colors%22%3A%22global%22%7D%5D"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="about" css=".vc_custom_1495863114914{background-color: #453c32 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column delay="true" effect="none"][vc_custom_heading text="...OUR CLIENTS" font_container="tag:h3|text_align:center|color:%23ffffff" use_theme_fonts="yes" css=".vc_custom_1495862877280{margin-bottom: 10px !important;}"][ut_header title="WE HAVE WORKED FOR" title_color="#ffbf00" lead_color="#ffffff"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create<b> websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="3869,3870,3871,3872,3866,3865,3864,3863,3861,3862" delay_timer="100" effect="fadeIn"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor="true" css=".vc_custom_1496070576598{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="...WHAT WE DO" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495647312055{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="CREATING THE WEB"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create <b>websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3"][ut_service_column headline="APP DEVELOPMENT" imageicon="1358" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="WEB DESIGN" imageicon="1581" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="UI DESIGN" imageicon="1362" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column width="1/3"][ut_service_column headline="BRAND &amp; IDENTITY" imageicon="1590" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="CONSULTANCY" imageicon="1588" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="MARKETING" imageicon="1652" headline_margin_bottom="20px" text_color="#151515"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="DEVELOPER..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495662896183{margin-bottom: 10px !important;}"][ut_header align="center" title="I\'M JOHN <ins>BROOKLYN</ins>"]I love traveling, steaks, hot dogs and lots of blond beer. You can also find me on
<a href="http://www.yourdomain.com">Twitter</a> and <a href="http://www.yourdomain.com">Facebook.</a> I collect inspirations on <a href="http://www.yourdomain.com">Pinterest</a> and save all my pics at <a href="http://www.yourdomain.com">Instagram.</a>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_custom_heading text="WHO I AM?" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]<strong>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</strong>

A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to[/vc_column_text][ut_btn button_align="bklyn-btn-left" button_text="Download My CV" button_text_color="#ffffff" button_background="#151515"][/vc_column][vc_column width="1/2"][vc_custom_heading text="EXPERT IN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="Dreameaver" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="62" animate_once="yes" info_font_weight="" info="Illustrator" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="83" animate_once="yes" info_font_weight="" info="Photoshop" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column][vc_custom_heading text="YOU CAN FOLLOW ME ON" font_container="tag:h6|text_align:left" use_theme_fonts="yes"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-vimeo%22%2C%22colors%22%3A%22global%22%7D%5D" social_description="Follow John"][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" css=".vc_custom_1496072947116{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/quote-section.jpg?id=2837) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_row animate_once="yes" delay="true" effect="zoomIn" delay_timer="50"][vc_column effect="none"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_text_transform="uppercase" cite_font_source="google" cite_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" cite_font_size="20" cite_font_weight="bold" cite_text_transform="uppercase" cite="Steve Jobs" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]Design is not just what it looks like and feels like.
Design is <ins>how it works.</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1495875536005{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="...DESIGNER" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495646924824{margin-bottom: 10px !important;}"][ut_header align="center" title="MY SKILLS"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create <b>websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="97" percent_font_weight="bold" title_text_font="on" title="CREATIVE THINKING" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="90" percent_font_weight="bold" title_text_font="on" title="WEB DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="82" percent_font_weight="bold" title_text_font="on" title="HTML / CSS" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="69" percent_font_weight="bold" title_text_font="on" title="UI DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page CV Section', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="DEVELOPER..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495662896183{margin-bottom: 10px !important;}"][ut_header align="center" title="I\'M JOHN <ins>BROOKLYN</ins>"]I love traveling, steaks, hot dogs and lots of blond beer. You can also find me on
<a href="http://www.yourdomain.com">Twitter</a> and <a href="http://www.yourdomain.com">Facebook.</a> I collect inspirations on <a href="http://www.yourdomain.com">Pinterest</a> and save all my pics at <a href="http://www.yourdomain.com">Instagram.</a>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column width="1/2"][vc_custom_heading text="WHO I AM?" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]<strong>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</strong>

A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to[/vc_column_text][ut_btn button_align="bklyn-btn-left" button_text="Download My CV" button_text_color="#ffffff" button_background="#151515"][/vc_column][vc_column width="1/2"][vc_custom_heading text="EXPERT IN" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][ut_probar_thin width="93" animate_once="yes" info_font_weight="" info="Dreameaver" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="62" animate_once="yes" info_font_weight="" info="Illustrator" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][ut_probar_thin width="83" animate_once="yes" info_font_weight="" info="Photoshop" percentage_bg_color="#ffbf00" color="#ffbf00" percentage_color="#151515"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column][vc_custom_heading text="YOU CAN FOLLOW ME ON" font_container="tag:h6|text_align:left" use_theme_fonts="yes"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-vimeo%22%2C%22colors%22%3A%22global%22%7D%5D" social_description="Follow John"][/vc_column][/vc_row][/vc_section]',                
        ),        
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page My Skills Section', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1495875536005{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="...DESIGNER" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495646924824{margin-bottom: 10px !important;}"][ut_header align="center" title="MY SKILLS"]We have created an <b>awesome</b> theme that will help designers, developers,
and companies create <b>websites</b> for their startups <b>quickly</b> and <b>easily.</b>[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="97" percent_font_weight="bold" title_text_font="on" title="CREATIVE THINKING" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="90" percent_font_weight="bold" title_text_font="on" title="WEB DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="82" percent_font_weight="bold" title_text_font="on" title="HTML / CSS" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][vc_column width="1/4" offset="vc_col-lg-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_progress_circle percent="69" percent_font_weight="bold" title_text_font="on" title="UI DESIGN" circle_color="#151515" stroke_color="#ffbf00" title_color="#151515" percent_color="#151515"][ut_service_column text_color="#151515"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/ut_service_column][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Personal Page Quote Section', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" css=".vc_custom_1496199043571{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_row animate_once="yes" delay="true" effect="zoomIn" delay_timer="50"][vc_column effect="none"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_text_transform="uppercase" cite_font_source="google" cite_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" cite_font_size="20" cite_font_weight="bold" cite_text_transform="uppercase" cite="Steve Jobs" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]Design is not just what it looks like and feels like.
Design is <ins>how it works.</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Product Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][vc_custom_heading text="WHAT YOU GET" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495727108289{margin-bottom: 10px !important;}"][ut_header align="center" lead_accent_font_weight="bold" title="OUR AWESOME PRODUCT" lead_accent_color="#151515"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <b>know-how</b> and <b>experience</b> in your <b>daily business.</b>[/ut_header][/vc_column][/vc_row][vc_row effect="none"][vc_column][ut_animated_image size="full" align="center" animate_once="yes" delay="true" image="3876" css=".vc_custom_1496188844815{border-bottom-width: 1px !important;padding-bottom: 80px !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;}" effect="fadeIn" delay_timer="100"][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" width="40" imageicon="3091" headline="TEMPLATE INSTALLER"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column_vertical][ut_btn button_size="bklyn-btn-mini" button_text="Learn More" button_text_color="#151515" button_text_color_hover="#ffffff" button_background_hover="#151515"][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" width="40" imageicon="3093" headline="TEMPLATE BUILDER"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column_vertical][ut_btn button_size="bklyn-btn-mini" button_text="Learn More" button_text_color="#151515" button_text_color_hover="#ffffff" button_background_hover="#151515"][/vc_column][vc_column width="1/3"][ut_service_column_vertical icon_margin_bottom="40" width="40" imageicon="3094" headline="CUSTOMIZE EVERYTHING"]All parts of Brooklyn can be customized! From header to footer and everything what’s in between![/ut_service_column_vertical][ut_btn button_size="bklyn-btn-mini" button_text="Learn More" button_text_color="#151515" button_text_color_hover="#ffffff" button_background_hover="#151515"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1495866667621{padding-bottom: 0px !important;background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="OUR PRODUCT" font_container="tag:h3|text_align:center" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495736828639{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" lead_accent_font_weight="bold" title="BECOME LEGEND"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3"][ut_service_column imageicon="3097" headline="TEMPLATE INSTALLER" text_color="#151515"]Brooklyn has made the Template Installer popular on the theme market! Innovation is our flagship![/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column imageicon="3098" headline="TEMPLATE BUILDER" text_color="#151515"]Build templates in minutes! Web design without any coding and right at your fingertips![/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column imageicon="3099" headline="CUSTOMIZE EVERYTHING" text_color="#151515"]All parts of Brooklyn can be customized! From header to footer and everything what’s in between![/ut_service_column][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_column css=".vc_custom_1495734252301{padding-top: 0px !important;}"][ut_gallery_slider type="carousel" number="4" number_tablet="2" hover_caption="on" slides="2182,2184,2185,2515,2514,2480" arrow_color="#ffffff" arrow_color_hover="#ffffff" arrow_background_color="#151515" arrow_background_color_hover="#151515" css=".vc_custom_1496188549642{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496071339643{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#151515" text_color_hover="rgba(21,21,21,0.5)"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="rgba(21,21,21,0.5)"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Service Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="WHAT YOU GET" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495742706231{margin-bottom: 10px !important;}"][ut_header align="center" lead_accent_font_weight="bold" title="OUR SERVICES" lead_accent_color="#151515"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <b>know-how</b> and <b>experience</b> in your <b>daily business.</b>[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3" bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1496073821108{padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 120px !important;padding-left: 40px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service1.jpg?id=3076) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_custom_heading text="01" font_container="tag:h6|text_align:left|color:%23ffbf00" use_theme_fonts="yes" text_transform="uppercase"][vc_custom_heading text="Branding &amp; Logo Design" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]<span style="color: #ffffff;">Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.</span>
<span style="color: #ffffff;"> Nullam bibendum porta magna.</span>[/vc_column_text][/vc_column][vc_column width="1/3" bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1496073825003{padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 120px !important;padding-left: 40px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service2.jpg?id=3077) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_custom_heading text="02" font_container="tag:h6|text_align:left|color:%23ffbf00" use_theme_fonts="yes" text_transform="uppercase"][vc_custom_heading text="APP DESIGN" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]<span style="color: #ffffff;">Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.</span>
<span style="color: #ffffff;"> Nullam bibendum porta magna.</span>[/vc_column_text][/vc_column][vc_column width="1/3" bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1496073829839{padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 120px !important;padding-left: 40px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/service3.jpg?id=3078) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_custom_heading text="03" font_container="tag:h6|text_align:left|color:%23ffbf00" use_theme_fonts="yes" text_transform="uppercase"][vc_custom_heading text="WEB DESIGN" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]<span style="color: #ffffff;">Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.</span>
<span style="color: #ffffff;"> Nullam bibendum porta magna.</span>[/vc_column_text][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column width="1/3"][ut_service_column headline="APP DEVELOPMENT" imageicon="1358" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="WEB DESIGN" imageicon="1581" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="UI DESIGN" imageicon="1362" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="250"][vc_column width="1/3"][ut_service_column headline="BRAND &amp; IDENTITY" imageicon="1590" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="CONSULTANCY" imageicon="1588" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="MARKETING" imageicon="1652" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496073722285{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#151515" text_color_hover="rgba(21,21,21,0.5)"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="rgba(21,21,21,0.5)"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Team Page', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1496021680542{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true" css=".vc_custom_1496074306437{padding-right: 0px !important;padding-left: 0px !important;}"][vc_column width="1/2" background_position="center top" background_attachment="scroll" animate_once="yes" delay="true" css=".vc_custom_1496188991525{padding-top: 400px !important;padding-bottom: 400px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/1.jpg?id=3855) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="50"][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" css=".vc_custom_1496077274685{padding-top: 80px !important;padding-right: 20px !important;padding-bottom: 80px !important;padding-left: 20px !important;}" effect="zoomIn" delay_timer="100"][vc_custom_heading text="THE FOUNDER..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651659041{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="JOHN BROOKLYN" lead_margin_top="30px"]We’re a creative agency located in <b>Brooklyn, New York.</b>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][ut_social_follow align="center" gap="40 Pixel" shape="round" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%2300aced%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(0%2C172%2C237%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%231769ff%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(23%2C105%2C255%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%23bc2a8d%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(188%2C42%2C141%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%5D" css=".vc_custom_1495659838356{margin-bottom: 0px !important;}" social_description="Johns Icons"][/vc_column][/vc_row][vc_row hide_on_desktop="true"][vc_column][ut_animated_image size="large" align="center" image="3855"][vc_custom_heading text="THE FOUNDER..." font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1496074332054{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="JOHN BROOKLYN" lead_margin_top="30px"]We’re a creative agency located in <b>Brooklyn, New York.</b>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][ut_social_follow align="center" gap="40 Pixel" shape="round" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%2300aced%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(0%2C172%2C237%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%231769ff%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(23%2C105%2C255%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%23bc2a8d%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(188%2C42%2C141%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%5D" social_description="Johns Icons"][/vc_column][/vc_row][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle" hide_on_tablet="true" hide_on_mobile="true" css=".vc_custom_1496077404388{margin-top: 0px !important;padding-top: 0px !important;padding-right: 0px !important;padding-left: 0px !important;}"][vc_column width="1/2" animate_once="yes" delay="true" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" css=".vc_custom_1496077326000{padding-top: 80px !important;padding-right: 20px !important;padding-bottom: 80px !important;padding-left: 20px !important;}" effect="zoomIn" delay_timer="150"][vc_custom_heading text="...&amp; HIS PARTNER" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651670258{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="DWAYNE RUSSEL" lead_margin_top="30px"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][ut_social_follow align="center" gap="40 Pixel" shape="round" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%233b5998%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(59%2C89%2C152%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%23ea4c89%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(234%2C76%2C137%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%236441a5%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(100%2C65%2C165%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%5D" css=".vc_custom_1495659849872{margin-bottom: 0px !important;}" social_description="Dwaynes Icons"][/vc_column][vc_column width="1/2" background_position="center top" background_attachment="scroll" animate_once="yes" delay="true" css=".vc_custom_1496189009677{padding-top: 400px !important;padding-bottom: 400px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/1.jpg?id=3855) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" effect="zoomIn" delay_timer="200"][/vc_column][/vc_row][vc_row hide_on_desktop="true"][vc_column][ut_animated_image size="large" align="center" image="3855"][vc_custom_heading text="...&amp; HIS PARTNER" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651670258{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="DWAYNE RUSSEL" lead_margin_top="30px"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][ut_social_follow align="center" gap="40 Pixel" shape="round" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%233b5998%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(59%2C89%2C152%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-dribbble%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%23ea4c89%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(234%2C76%2C137%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22colors%22%3A%22custom%22%2C%22background%22%3A%22%236441a5%22%2C%22icon_color%22%3A%22%23ffffff%22%2C%22background_hover%22%3A%22rgba(100%2C65%2C165%2C0.5)%22%2C%22icon_color_hover%22%3A%22%23ffffff%22%7D%5D" social_description="Dwaynes Icons"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496021666004{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #141618 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_fancy_link link_color="#ffffff" line_color="#ffffff" link_hover_color="#ffbf00" line_hover_color="#ffbf00" url="#hire-us"]hire us[/ut_fancy_link][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496076578102{padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_row full_width="stretch_row_content_no_spaces" animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][vc_column][ut_media_slider slider_type="carousel" number="3" number_tablet="3" hover_caption="on" slides="%5B%7B%22title%22%3A%22Slide%201%22%2C%22type%22%3A%22image%22%2C%22image%22%3A%222184%22%2C%22link_type%22%3A%22image%22%7D%2C%7B%22title%22%3A%22Slide%202%22%2C%22type%22%3A%22video%22%2C%22link_type%22%3A%22none%22%2C%22video%22%3A%22https%3A%2F%2Fyoutu.be%2FTXQT1JKCQPo%22%2C%22poster%22%3A%222182%22%7D%2C%7B%22title%22%3A%22Slide%203%22%2C%22type%22%3A%22image%22%2C%22image%22%3A%222185%22%2C%22link_type%22%3A%22image%22%7D%5D" css=".vc_custom_1496077664180{margin-bottom: 0px !important;}" arrow_color="#ffffff" arrow_color_hover="#ffffff" arrow_background_color="#151515" arrow_background_color_hover="#151515" video_icon_color="#ffffff" video_icon_bg_color="#151515" slider_description="Your Description"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496021552375{background-color: #ffbf00 !important;}" el_id="hire-us"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="150"][vc_column effect="none"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN" lead_margin_top="30px"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#151515" text_color_hover="rgba(21,21,21,0.5)"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="rgba(21,21,21,0.5)"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Contact Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column width="1/2"][vc_custom_heading text="DROP US A LINE" font_container="tag:h3|text_align:left" use_theme_fonts="yes" css=".vc_custom_1496182683445{margin-bottom: 10px !important;}"][ut_header align="left" title="LETS GET IN TOUCH"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40brooklyn.unitedthemes.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#151515" text_color_hover="#777777"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_social_follow gap="40 Pixel" size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color_hover="#777777"][/vc_column][vc_column width="1/2"][contact-form-7 id="6" title="Contact Page"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1496182346564{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="100"][vc_column][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1496182599683{margin-bottom: 10px !important;}"][ut_header title="JOIN 40.000 LOVELY CUSTOMERS AND
START BUILDING WITH BROOKLYN TRODAY"][/ut_header][ut_btn button_size="bklyn-btn-normal" button_custom_border="yes" button_border_width="4" button_text="Join To Download Brooklyn" button_text_color="#ffbf00" button_border_color="#151515" button_border_color_hover="#151515" button_link="url:http%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-creative-one-page-multipurpose-theme%2F6221179%3Flicense%3Dregular%26open_purchase_for_item_id%3D6221179%26purchasable%3Dsource||target:%20_blank|" button_background="#151515" button_text_color_hover="#ffbf00" button_background_hover="#151515"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - About Section', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="about"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header align="center" title="ABOUT BROOKLYN"]We’re a creative agency located in <b>Brooklyn, New York.</b>
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3"][ut_service_column headline="APP DEVELOPMENT" imageicon="1358" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="WEB DESIGN" imageicon="1581" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="UI DESIGN" imageicon="1362" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column width="1/3"][ut_service_column headline="BRAND &amp; IDENTITY" imageicon="1590" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="CONSULTANCY" imageicon="1588" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="MARKETING" imageicon="1652" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1495489285314{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/bklyn-section-1.jpg?id=2514) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)" effect="none"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="200"][ut_parallax_quote quotation_marks="no" quote_font_source="google" quote_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" quote_font_size="35" quote_text_transform="uppercase" cite_font_size="14" cite_text_transform="uppercase" cite="United Themes – Development Brooklyn" quote_color="#ffffff" cite_color="#ffffff" quote_ins_color="#ffbf00"]PASSION LEADS TO DESIGN, DESIGN LEADS TO PERFORMANCE,
PERFORMANCE LEADS TO <ins>SUCCESS!</ins>[/ut_parallax_quote][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Clients Section', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="clients"][vc_row][vc_column][vc_row_inner][vc_column_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][ut_header style="global" align="center" title="OUR CLIENTS"]The comments below are just a sample of the <b>25.500</b> clients worldwide
who transformed their business website with Brooklyn.[/ut_header][/vc_column_inner][/vc_row_inner][ut_qtrotator_2 effect="fadeInUp" quote_custom_font="yes" animate_once="yes" delay="true" effect_in="slideInLeft" effect_out="slideOutRight" arrow_color="#151515" arrow_color_hover="#ffbf00" quote_color="#777777" origin_color="#151515" quote_font="font_family:Open%20Sans%3A300%2C300italic%2Cregular%2Citalic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="16px" quote_line_height="32px" name_color="#151515" logo_color="#151515" delay_timer="100" css=".vc_custom_1496096940850{margin-top: 40px !important;}"][ut_qt_2 avatar="2521" author="EMCARKH" origin="LAS VEGAS, NV" icon_bklyn="BklynIcons-Rocket-Launch"]"Genuinely love this theme. So sick of trawling through endless menus and options on other themes. Brooklyn is so intuitive with where all its settings are located and is just a pleasure to use. Also, the sheer number of demos and ability to mix elements from different demos means it works well for so many purposes."[/ut_qt_2][ut_qt_2 avatar="2522" author="FLOWSTATEDESIGN" origin="HOUSTON, TX" icon_bklyn="BklynIcons-Diamond"]“Beautiful Theme! Awesome built-in features with some great built in Plug-ins! A well designed and well thought out Dashboard! 100/100 Would recommend!”[/ut_qt_2][ut_qt_2 avatar="2523" author="CODEBOUND" origin="BROOKLYN, NY" icon_bklyn="BklynIcons-Angry-Birds"]"Amazing theme – just does what it says it does. No surprises! Flexible in terms of using the features and easily tweaking different options. Things are arranged so that you can find them easily when you need them."[/ut_qt_2][ut_qt_2 avatar="2519" author="CMPHOTO" origin="MIAMI, FL" icon_bklyn="BklynIcons-Stormtrooper-2"]“Great theme with great flexibility. A lot of ready-to-go demos which can be installed with a single click. Really great support if needed. With most updates, there is a new demo added to the bundle.”[/ut_qt_2][/ut_qtrotator_2][/vc_column][/vc_row][vc_row css=".vc_custom_1495890143958{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #141618 !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="2538,2539,2537,2541,2540" delay_timer="50" effect="fadeIn"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Get In Touch Section Orange', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1496073722285{background-color: #ffbf00 !important;}"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column effect="none"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#151515" text_color_hover="rgba(21,21,21,0.5)"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="rgba(21,21,21,0.5)"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Get in Touch Section White', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_custom_heading text="WE\'RE WAITING FOR YOU" font_container="tag:h3|text_align:center|color:%23151515" use_theme_fonts="yes" text_transform="uppercase" css=".vc_custom_1495651318155{margin-bottom: 10px !important;}"][ut_header style="pt-style-4" align="center" title="GET IN TOUCH WITH BROOKLYN"]We welcome you to <b>contact us</b> for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#151515" text_color="#151515" icon_color_hover="#ffbf00" text_color_hover="#ffbf00"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495651439184{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="#ffbf00"][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Services Page Our Services Section', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][vc_column][vc_custom_heading text="WHAT YOU GET" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1495742706231{margin-bottom: 10px !important;}"][ut_header align="center" lead_accent_font_weight="bold" title="OUR SERVICES" lead_accent_color="#151515"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <b>know-how</b> and <b>experience</b> in your <b>daily business.</b>[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/3" bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1496198969469{padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 120px !important;padding-left: 40px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_custom_heading text="01" font_container="tag:h6|text_align:left|color:%23ffbf00" use_theme_fonts="yes" text_transform="uppercase"][vc_custom_heading text="Branding &amp; Logo Design" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]<span style="color: #ffffff;">Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.</span>
<span style="color: #ffffff;"> Nullam bibendum porta magna.</span>[/vc_column_text][/vc_column][vc_column width="1/3" bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1496198975321{padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 120px !important;padding-left: 40px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_custom_heading text="02" font_container="tag:h6|text_align:left|color:%23ffbf00" use_theme_fonts="yes" text_transform="uppercase"][vc_custom_heading text="APP DESIGN" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]<span style="color: #ffffff;">Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.</span>
<span style="color: #ffffff;"> Nullam bibendum porta magna.</span>[/vc_column_text][/vc_column][vc_column width="1/3" bklyn_overlay="true" background_position="center center" background_attachment="scroll" css=".vc_custom_1496198982829{padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 120px !important;padding-left: 40px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_custom_heading text="03" font_container="tag:h6|text_align:left|color:%23ffbf00" use_theme_fonts="yes" text_transform="uppercase"][vc_custom_heading text="WEB DESIGN" font_container="tag:h3|text_align:left|color:%23ffffff" use_theme_fonts="yes" text_transform="uppercase"][vc_column_text]<span style="color: #ffffff;">Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.</span>
<span style="color: #ffffff;"> Nullam bibendum porta magna.</span>[/vc_column_text][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column width="1/3"][ut_service_column headline="APP DEVELOPMENT" imageicon="1358" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="WEB DESIGN" imageicon="1581" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="UI DESIGN" imageicon="1362" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="250"][vc_column width="1/3"][ut_service_column headline="BRAND &amp; IDENTITY" imageicon="1590" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="CONSULTANCY" imageicon="1588" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column headline="MARKETING" imageicon="1652" headline_margin_bottom="20px"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus.
Nullam bibendum porta magna. [/ut_service_column][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Services Section', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="Services"][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1495994885569{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/section-services.jpg?id=1698) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_tablet="true" delay="true" effect="fadeIn" delay_timer="50"][vc_column_inner][ut_header style="global" align="center" title="OUR SERVICES" title_color="#ffffff" lead_color="#ffffff"]Our quality standards apply also in terms of service, technical expertise and advice.
Our dedicated employees are happy to assist you with <b>know-how</b> and <b>experience</b> in your <b>daily business.</b>[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="TEMPLATE INSTALLER" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Download" headline_margin_bottom="20px"]Brooklyn has made the Theme Installer popular on the market![/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="TEMPLATE BUILDER" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Computer-Network-2" headline_margin_bottom="20px"]Web design without any coding and right at your fingertips![/ut_service_box][/vc_column_inner][vc_column_inner width="1/3"][ut_service_box icon_type="bklynicons" headline="CUSTOMIZE EVERYTHING" color="#ffffff" background="rgba(0,0,0,0.15)" headline_color="#ffbf00" text_color="#ffffff" icon_bklyn="BklynIcons-Lens-1" headline_margin_bottom="20px"]From header to footer and everything what’s in between.[/ut_service_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',                
        ),        
        array(
            'name'      => esc_html__( 'Demo 27 - Team Section', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="Team"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header style="global" align="center" title="BROOKLYN\'S CREW"]We believe in a diverse range of personel to bring <b>creative skills,
thoughts,</b> and <b>ideas</b> to the table.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22title%22%3A%22Instagram%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="JOHN" avatar="2451" occupation="DEVELOPER / <b>DESIGNER</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitch%22%2C%22title%22%3A%22Twitch%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="DWAYNE" avatar="2535" occupation="DEVELOPER / <b>CODER</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-youtube%22%2C%22title%22%3A%22YouTube%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22Email%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="BRUCE" avatar="2453" occupation="STAFF / <b>SUPPORT</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][vc_column width="1/4"][ut_person_module name_font_weight="" name_font_size="17" ocupation_font_weight="" social="%5B%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-google-plus%22%2C%22title%22%3A%22Google%20Plus%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-vimeo%22%2C%22title%22%3A%22Vimeo%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" name="NICK" avatar="2454" occupation="STAFF / <b>SUPPORT</b>" name_color="#ffffff" name_decoration_line_color="#ffffff" overlay_color="rgba(20,22,24,0.9)" ocupation_color="#ffbf00" icon_color="#ffffff" link="url:http%3A%2F%2Fthemeforest.unitedthemes.com%2Fwpversions%2Fbrooklyn%2Fxml%2Fdemo1%2Fpersonal-page%2F|||"][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1495963738985{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/section-archievements-1.jpg?id=2529) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="150"][vc_column_inner][ut_header style="global" align="center" title="OUR ARCHIEVEMENTS" title_color="#ffffff" lead_color="#ffffff"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience[/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="200"][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Office-Desk-2" to="3000" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="h"]Working Hours[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Rocket-Launch" to="40000" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="+"]Customers Worldwide[/ut_number_counter][/vc_column_inner][vc_column_inner width="1/3"][ut_number_counter icon_font_size="35" counter_align="left" sep="true" caption_text_transform="uppercase" caption_font_weight="" counter_font_source="google" counter_google_fonts="font_family:Oswald%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal" icon_bklyn="BklynIcons-Mustache-1" to="17" counter_color="#ffbf00" desccolor="#ffffff" color="#ffffff" suffix="."]Design Awards[/ut_number_counter][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1495994782208{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #141618 !important;}"][vc_column animate_once="yes" delay="true" effect="fadeIn" delay_timer="250"][ut_fancy_link link_color="#ffffff" line_color="#ffffff" link_hover_color="#ffbf00" line_hover_color="#ffbf00" url="#contact-section"] Drop us a line [/ut_fancy_link][/vc_column][/vc_row][/vc_section]',                
        ),
        array(
            'name'      => esc_html__( 'Demo 27 - Work Section', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor="true" bklyn_section_anchor_id="work"][vc_row animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column][ut_header style="global" align="center" title="OUR WORK"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our <b>handmade work</b> with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row animate_once="yes" delay="true" effect="fadeInUp" delay_timer="150"][vc_column][ut_custom_shortcode css=".vc_custom_1496080035830{margin-bottom: 0px !important;}"][ut_showcase id="1637" name="Demo 1 – Front Page"][/ut_custom_shortcode][/vc_column][/vc_row][vc_row bklyn_overlay="true" bklyn_overlay_pattern="true" bklyn_overlay_pattern_style="bklyn-style-three" background_position="center center" background_attachment="fixed" css=".vc_custom_1496080103092{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo1/wp-content/uploads/2017/05/bklyn-section-2.jpg?id=2515) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(44,62,80,0.5)"][vc_column][vc_row_inner animate_once="yes" delay="true" effect="fadeIn" delay_timer="50"][vc_column_inner][ut_header style="global" align="center" title="GET CONNECTED" title_color="#ffffff" lead_color="#ffffff"]Get yourself ready for an <b>awesome experience</b> with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column_inner][/vc_row_inner][vc_row_inner animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-twitter" title="Twitter" slogan=" Follow us on Twitter " icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-facebook" title="Facebook" slogan="Join the Conversation" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-behance" title="Behance" slogan="See our latest works" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][vc_column_inner width="1/4"][ut_big_icon slogan_text_transform="uppercase" icon="fa fa-instagram" title="Instagram" slogan="Latest Images" icon_background="rgba(0,0,0,0.15)" icon_color="#ffffff" icon_hover_color="#ffffff" icon_hover_background="#ffbf00" title_color="#ffbf00" slogan_color="#ffffff"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',                
        ),
        
        
        /* Demo 28 */
        array(
            'name'      => esc_html__( 'Demo 28 - Home', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Creative Solutions And
Results That Grow Brands." lead_accent_color="#252525"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_hidden-sm vc_hidden-xs"][ut_animated_image size="full" align="center" animate_once="yes" delay="true" image="5231" css=".vc_custom_1498992412249{margin-bottom: 0px !important;}" effect="fadeInUp"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5074" headline="Dropbox Integration" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5075" headline="Google Drive" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1498845602967{margin-top: 0px !important;padding-top: 40px !important;padding-bottom: 0px !important;background-color: #0674ec !important;}"][vc_column][ut_fancy_link link_color="#ffffff" line_color="#ffffff" url="#section-contact" class="ut-scroll-to-section"]Get in touch with us![/ut_fancy_link][/vc_column][/vc_row][vc_row background_position="center center" background_attachment="scroll" hide_on_tablet="true" hide_on_mobile="true" css=".vc_custom_1499095813721{padding-top: 300px !important;padding-bottom: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg2.jpg?id=5220) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" add_box_shadow="true" css=".vc_custom_1499095778719{padding-top: 40px !important;background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" shadow_color="rgba(20,22,24,0.15)" shadow_color_hover="rgba(20,22,24,0.15)"][ut_parallax_quote icon_border_radius="50" quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="22" quote_text_transform="capitalize" cite="United Themes" icon_color="#ffffff" icon="fa fa-first-order" icon_background_color="#0674ec"]In a world of over 1 billion websites, does your website stand out?[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498909046810{background-color: #f9f9fa !important;}" bklyn_section_anchor_id="services"][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="Our Services." lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice. Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner css=".vc_custom_1498841370892{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5351" headline="Green IT"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5350" headline="Business Services"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5347" headline="Cloud Choice"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5352" headline="Cybersecurity"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_showcase_shortcode showcase_id="4272" css=".vc_custom_1498909164057{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team" css=".vc_custom_1498909250695{padding-top: 120px !important;}"][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="We Work For
Your Success." lead_accent_color="#252525"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#cccccc" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec"][/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Co-Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1499017976786{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg.jpg?id=5326) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0)"][vc_row][vc_column][ut_header style="pt-style-2" align="global" lead_accent_font_weight="bold" title="Brooklyn Designs Are The
Gasoline To Boost Your Website." lead_color="#ffffff" title_color="#ffffff" accent="#0674ec"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" css=".vc_custom_1499017926250{margin-top: 20px !important;}"][vc_column width="1/2" css=".vc_custom_1499096236307{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical imageicon="5050" headline="Application Services" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column][vc_column width="1/2" css=".vc_custom_1499096244552{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_probar_thin width="98" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Consulting Services" color="#0674ec" info_color="#292e36" percentage_color="#ffffff" percentage_bg_color="#0674ec"][ut_probar_thin width="99" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Digital Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Testing Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499018282436{padding-bottom: 160px !important;}"][vc_row][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="Let\'s Get In Touch."]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#0674ec" text_color_hover="#0674ec"][vc_custom_heading text="Follow Us" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color_hover="#0674ec" icon_color="#292e36"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][contact-form-7 id="5"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Home Alternative 1', 'ut_shortcodes' ),
            'content'   => '[vc_section css=".vc_custom_1498909046810{background-color: #f9f9fa !important;}" bklyn_section_anchor_id="services"][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="Our Services." lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice. Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner css=".vc_custom_1498841370892{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5351" headline="Green IT"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5350" headline="Business Services"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5347" headline="Cloud Choice"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5352" headline="Cybersecurity"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_showcase_shortcode showcase_id="4272" css=".vc_custom_1498909164057{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team" css=".vc_custom_1498909250695{padding-top: 120px !important;}"][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="We Work For
Your Success." lead_accent_color="#252525"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#cccccc" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec"][/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-6 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Co-Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499053395097{padding-bottom: 140px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/davide-cantelli-240809.jpg?id=5122) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_row][vc_column][ut_header style="pt-style-2" align="center" title="Let\'s Get In Touch" title_color="#ffffff" lead_color="#ffffff" accent="#0674ec"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top"][vc_column width="1/2" css=".vc_custom_1499097767286{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="Our Address" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_animated_image size="large" align="center" image="5122"][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#0674ec" text_color_hover="#0674ec"][vc_custom_heading text="Follow Us" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color_hover="#0674ec" icon_color="#292e36"][/vc_column][vc_column width="1/2" css=".vc_custom_1499097775413{padding-bottom: 40px !important;background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_custom_heading text="Drop Us A Line" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][contact-form-7 id="5"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Home Alternative 2', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="work" css=".vc_custom_1499027980212{padding-bottom: 50px !important;}"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_showcase_shortcode showcase_id="5526" css=".vc_custom_1499027775068{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498909046810{background-color: #f9f9fa !important;}" bklyn_section_anchor_id="services"][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="Our Services." lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice. Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner css=".vc_custom_1498841370892{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5351" headline="Green IT"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5350" headline="Business Services"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5347" headline="Cloud Choice"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5352" headline="Cybersecurity"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1499017976786{padding-bottom: 100px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg.jpg?id=5326) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0)"][vc_row][vc_column][ut_header style="pt-style-2" align="global" lead_accent_font_weight="bold" title="Brooklyn Designs Are The
Gasoline To Boost Your Website." lead_color="#ffffff" title_color="#ffffff" accent="#0674ec"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" css=".vc_custom_1499017926250{margin-top: 20px !important;}"][vc_column width="1/2" css=".vc_custom_1499097638736{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical imageicon="5050" headline="Application Services" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column][vc_column width="1/2" css=".vc_custom_1499097645662{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_probar_thin width="98" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Consulting Services" color="#0674ec" info_color="#292e36" percentage_color="#ffffff" percentage_bg_color="#0674ec"][ut_probar_thin width="99" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Digital Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Testing Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499018282436{padding-bottom: 160px !important;}"][vc_row][vc_column width="1/2"][ut_header align="left" title="Let\'s Get In Touch"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#0674ec" text_color_hover="#0674ec"][vc_custom_heading text="Follow Us" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][ut_social_follow size="20" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color_hover="#0674ec" icon_color="#292e36"][/vc_column][vc_column width="1/2"][contact-form-7 id="5"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Home Alternative 3', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about" css=".vc_custom_1499097395352{padding-bottom: 0px !important;}"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Creative Solutions And
Results That Grow Brands." lead_accent_color="#252525" font_size="55px"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_hidden-sm vc_hidden-xs"][ut_animated_image size="full" align="center" animate_once="yes" delay="true" image="5231" css=".vc_custom_1498992412249{margin-bottom: 0px !important;}" effect="fadeInUp"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5074" headline="Dropbox Integration" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5075" headline="Google Drive" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498909046810{background-color: #f9f9fa !important;}" bklyn_section_anchor_id="services"][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="Our Services." lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice. Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner css=".vc_custom_1498841370892{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5351" headline="Green IT"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5350" headline="Business Services"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5347" headline="Cloud Choice"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5352" headline="Cybersecurity"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_showcase_shortcode showcase_id="4272" css=".vc_custom_1498909164057{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team" css=".vc_custom_1498909250695{padding-top: 120px !important;}"][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="We Work For
Your Success." lead_accent_color="#252525"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#cccccc" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec"][/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Co-Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498923786716{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg.jpg?id=5326) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0)"][vc_row][vc_column][ut_header style="pt-style-2" align="global" lead_accent_font_weight="bold" title="Brooklyn Designs Are The
Gasoline To Boost Your Website." lead_color="#ffffff" title_color="#ffffff" accent="#0674ec"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" css=".vc_custom_1498908408467{margin-top: 0px !important;margin-bottom: 40px !important;}"][vc_column width="1/2" css=".vc_custom_1498906928427{background-color: #ffffff !important;border-radius: 10px !important;}"][ut_service_column_vertical imageicon="5050" headline="Application Services" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column][vc_column width="1/2" css=".vc_custom_1498906919286{background-color: #ffffff !important;border-radius: 10px !important;}"][ut_probar_thin width="98" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Consulting Services" color="#0674ec" info_color="#292e36" percentage_color="#ffffff" percentage_bg_color="#0674ec"][ut_probar_thin width="99" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Digital Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Testing Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][/vc_column][/vc_row][vc_row css=".vc_custom_1499097445486{background-color: #ffffff !important;}"][vc_column][ut_animated_image size="large" image_opacity="10" align="center" animate_once="yes" image="5205" effect="none"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Change Your Vision.
Create Your New lifestyle."]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="normal" button_text="Start with Brooklyn Today" button_text_color="#ffffff" button_background="#0674ec" button_text_color_hover="#ffffff" button_background_hover="#292e36" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Home CTA', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Creative Solutions And
Results That Grow Brands." lead_accent_color="#252525"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_hidden-sm vc_hidden-xs"][ut_animated_image size="full" align="center" animate_once="yes" delay="true" image="5231" css=".vc_custom_1498992412249{margin-bottom: 0px !important;}" effect="fadeInUp"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5074" headline="Dropbox Integration" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5075" headline="Google Drive" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1498845602967{margin-top: 0px !important;padding-top: 40px !important;padding-bottom: 0px !important;background-color: #0674ec !important;}"][vc_column][ut_fancy_link link_color="#ffffff" line_color="#ffffff" url="#section-contact" class="ut-scroll-to-section"]Get in touch with us![/ut_fancy_link][/vc_column][/vc_row][vc_row background_position="center center" background_attachment="scroll" hide_on_tablet="true" hide_on_mobile="true" css=".vc_custom_1499095813721{padding-top: 300px !important;padding-bottom: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg2.jpg?id=5220) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" add_box_shadow="true" css=".vc_custom_1499095778719{padding-top: 40px !important;background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" shadow_color="rgba(20,22,24,0.15)" shadow_color_hover="rgba(20,22,24,0.15)"][ut_parallax_quote icon_border_radius="50" quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="22" quote_text_transform="capitalize" cite="United Themes" icon_color="#ffffff" icon="fa fa-first-order" icon_background_color="#0674ec"]In a world of over 1 billion websites, does your website stand out?[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498909046810{background-color: #f9f9fa !important;}" bklyn_section_anchor_id="services"][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="Our Services." lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice. Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner css=".vc_custom_1498841370892{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5351" headline="Green IT"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5350" headline="Business Services"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5347" headline="Cloud Choice"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5352" headline="Cybersecurity"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_showcase_shortcode showcase_id="4272" css=".vc_custom_1498909164057{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team" css=".vc_custom_1498909250695{padding-top: 120px !important;}"][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="We Work For
Your Success." lead_accent_color="#252525"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#cccccc" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec"][/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Co-Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498923786716{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg.jpg?id=5326) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0)"][vc_row][vc_column][ut_header style="pt-style-2" align="global" lead_accent_font_weight="bold" title="Brooklyn Designs Are The
Gasoline To Boost Your Website." lead_color="#ffffff" title_color="#ffffff" accent="#0674ec"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" css=".vc_custom_1498908408467{margin-top: 0px !important;margin-bottom: 40px !important;}"][vc_column width="1/2" css=".vc_custom_1498906928427{background-color: #ffffff !important;border-radius: 10px !important;}"][ut_service_column_vertical imageicon="5050" headline="Application Services" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column][vc_column width="1/2" css=".vc_custom_1498906919286{background-color: #ffffff !important;border-radius: 10px !important;}"][ut_probar_thin width="98" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Consulting Services" color="#0674ec" info_color="#292e36" percentage_color="#ffffff" percentage_bg_color="#0674ec"][ut_probar_thin width="99" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Digital Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Testing Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][/vc_column][/vc_row][vc_row css=".vc_custom_1499050418372{background-color: #ffffff !important;}" el_id="bklyn-cta"][vc_column][ut_animated_image size="large" image_opacity="10" align="center" animate_once="yes" image="5205" effect="none"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Change Your Vision.
Create Your New lifestyle."]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="normal" button_text="Start with Brooklyn Today" button_text_color="#ffffff" button_background="#0674ec" button_text_color_hover="#ffffff" button_background_hover="#292e36" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Home Newsletter (MailChimp Required)', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="about"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Creative Solutions And
Results That Grow Brands." lead_accent_color="#252525"]We’re a creative agency located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2" offset="vc_hidden-sm vc_hidden-xs"][ut_animated_image size="full" align="center" animate_once="yes" delay="true" image="5231" css=".vc_custom_1498992412249{margin-bottom: 0px !important;}" effect="fadeInUp"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][vc_row_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5074" headline="Dropbox Integration" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2" animate_once="yes" effect="none"][ut_service_column_vertical imageicon="5075" headline="Google Drive" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=".vc_custom_1498845602967{margin-top: 0px !important;padding-top: 40px !important;padding-bottom: 0px !important;background-color: #0674ec !important;}"][vc_column][ut_fancy_link link_color="#ffffff" line_color="#ffffff" url="#section-contact" class="ut-scroll-to-section"]Get in touch with us![/ut_fancy_link][/vc_column][/vc_row][vc_row background_position="center center" background_attachment="scroll" hide_on_tablet="true" hide_on_mobile="true" css=".vc_custom_1499096842617{padding-top: 300px !important;padding-bottom: 260px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg2.jpg?id=5220) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" add_box_shadow="true" css=".vc_custom_1499096861887{padding-top: 40px !important;background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12" shadow_color="rgba(20,22,24,0.15)" shadow_color_hover="rgba(20,22,24,0.15)"][ut_parallax_quote icon_border_radius="50" quote_font_source="google" quote_google_fonts="font_family:Droid%20Serif%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal" quote_font_size="22" quote_text_transform="capitalize" cite="United Themes" icon_color="#ffffff" icon="fa fa-first-order" icon_background_color="#0674ec"]In A World Of Over 1 Billion Websites, Does Your Website Stand Out?[/ut_parallax_quote][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1498909046810{background-color: #f9f9fa !important;}" bklyn_section_anchor_id="services"][vc_row equal_height="yes" content_placement="top"][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="Our Services." lead_accent_color="#252525"]Our quality standards apply also in terms of service, technical expertise and advice. Our dedicated employees are happy to assist you with know-how and experience in your daily business.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/2" offset="vc_col-lg-6 vc_col-md-12 vc_col-sm-12 vc_col-xs-12"][vc_row_inner css=".vc_custom_1498841370892{margin-top: 0px !important;}"][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5351" headline="Green IT"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5350" headline="Business Services"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][vc_column_inner width="1/2"][ut_service_column_vertical imageicon="5347" headline="Cloud Choice"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_service_column_vertical imageicon="5352" headline="Cybersecurity"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_showcase_shortcode showcase_id="4272" css=".vc_custom_1498909164057{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team" css=".vc_custom_1498909250695{padding-top: 120px !important;}"][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="We Work For
Your Success." lead_accent_color="#252525"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#cccccc" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec"][/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Co-Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1498923786716{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg.jpg?id=5326) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0)"][vc_row][vc_column][ut_header style="pt-style-2" align="global" lead_accent_font_weight="bold" title="Brooklyn Designs Are The
Gasoline To Boost Your Website." lead_color="#ffffff" title_color="#ffffff" accent="#0674ec"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" css=".vc_custom_1499017008168{margin-top: 20px !important;margin-bottom: 100px !important;}"][vc_column width="1/2" css=".vc_custom_1499096982785{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical imageicon="5050" headline="Application Services" link="url:%23|title:Learn%20More||" link_hover_color="#292e36"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][/vc_column][vc_column width="1/2" css=".vc_custom_1499096989696{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_probar_thin width="98" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Consulting Services" color="#0674ec" info_color="#292e36" percentage_color="#ffffff" percentage_bg_color="#0674ec"][ut_probar_thin width="99" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Digital Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Testing Services" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][/vc_column][/vc_row][vc_row css=".vc_custom_1499049938262{margin-top: 0px !important;background-color: #ffffff !important;}"][vc_column][ut_animated_image size="large" image_opacity="10" align="center" animate_once="yes" image="5205" effect="fadeIn"][ut_header style="global" align="global" lead_accent_font_weight="bold" title="Change Your Vision.
Create Your New lifestyle."]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][ut_btn button_size="bklyn-btn-normal" button_border_radius="50" font_family="inherit" font_weight="normal" button_text="Start with Brooklyn Today" button_text_color="#ffffff" button_background="#0674ec" button_text_color_hover="#ffffff" button_background_hover="#292e36" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|"][/vc_column][/vc_row][/vc_section][vc_section css=".vc_custom_1499049929891{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/davide-cantelli-240809.jpg?id=5122) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="bklyn-signup"][vc_row][vc_column][ut_header style="pt-style-2" align="global" lead_accent_font_weight="bold" title="Newsletter Signup." lead_color="#ffffff" accent="#0674ec" title_color="#ffffff"]Get yourself ready for an awesome experience with Brooklyn
and be a part of the big international Brooklyn family. [/ut_header][/vc_column][/vc_row][vc_row css=".vc_custom_1499016877108{margin-top: 0px !important;}"][vc_column width="1/2" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_mail_chimp_shortcode form_id="5466"][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="5" gap="40" lightbox="no" animate_once="yes" delay_animation="true" gallery="5621,5620,5624,5622,5623" effect="zoomIn"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Home Portfolio 1 (Showcase Plugin Required)', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_showcase_shortcode showcase_id="4272" css=".vc_custom_1498909164057{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section bklyn_section_anchor_id="team" css=".vc_custom_1498909250695{padding-top: 120px !important;}"][vc_row][vc_column width="1/3"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="We Work For
Your Success." lead_accent_color="#252525"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" icon_color_hover="#292e36"][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#cccccc" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec"][/ut_team_member][/vc_column][vc_column width="1/3"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Co-Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-github%22%2C%22title%22%3A%22Github%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo28%2Fteam-single-page%2F|||"][/ut_team_member][/vc_column][/vc_row][/vc_section][vc_section bklyn_overlay="true" css=".vc_custom_1499026948883{padding-bottom: 120px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/section-bg.jpg?id=5326) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(20,22,24,0)"][vc_row][vc_column][ut_header style="pt-style-2" align="global" lead_accent_font_weight="bold" title="Brooklyn Designs Are The
Gasoline To Boost Your Website." lead_color="#ffffff" title_color="#ffffff" accent="#0674ec"]Each completed project makes us even more hungry. Hungry for more designs,
more code and at least some more twinkies. As a result we deliver a better web experience.[/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" css=".vc_custom_1499017926250{margin-top: 20px !important;}"][vc_column width="1/2" css=".vc_custom_1499041091671{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical imageicon="5575" headline="Start With Brooklyn Today" link="|title:Learn%20||" link_hover_color="#292e36" css=".vc_custom_1499081596684{margin-bottom: 20px !important;}"]Praesent faucibus nisl sit amet nulla sollicitudin pretium a sed purus. Nullam bibendum porta magna.[/ut_service_column_vertical][ut_btn button_size="bklyn-btn-small" button_border_radius="4" font_weight="normal" button_text="Download Now" button_link="url:https%3A%2F%2Fthemeforest.net%2Fitem%2Fbrooklyn-responsive-multipurpose-wordpress-theme%2F6221179||target:%20_blank|" button_text_color="#ffffff" button_background="#0674ec" button_text_color_hover="#ffffff" button_background_hover="#292e36"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Home Portfolio 2 (Showcase Plugin Required)', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="work"][vc_row][vc_column][ut_header style="global" align="global" lead_accent_font_weight="bold" title="We’ll Design Experiences,
We Do Not Copy Them." lead_accent_color="#252525"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_showcase_shortcode showcase_id="5633" css=".vc_custom_1499054680857{margin-bottom: 0px !important;}"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column][ut_header align="center" title="Get In Touch With Brooklyn."]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list list_align="center" values="%5B%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(156)%20444%2B558%2B696%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22your%40awesome-email.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Amailto%253Acontact%2540yoursite.com%7C%7C%7C%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#0674ec" text_color_hover="#0674ec"][vc_custom_heading text="Follow Us" font_container="tag:h3|text_align:center" use_theme_fonts="yes" css=".vc_custom_1499055364838{margin-bottom: 40px !important;}"][ut_social_follow align="center" gap="40 Pixel" shape="round" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#ffffff" icon_color_hover="#ffffff" background="#0674ec" background_hover="#292e36"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Portfolio A Dream Of White And Beech', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="A Dream Of
White And Beech." css=".vc_custom_1499000707552{margin-bottom: 60px !important;}"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" hover="yes" animate_once="yes" delay="true" image="5122" effect="fadeIn" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" hover="yes" animate_once="yes" delay="true" image="5121" effect="fadeIn" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title="Brooklyn Will Make You More Proud Of Your Business."]We believe our work speaks for itself. Browse our most recent projects below and enjoy our handmade work with love for every detail.
[/ut_header][/vc_column][vc_column width="1/2"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" full_height="yes" content_placement="middle" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1499010785271{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/breather-163396.jpg?id=5129) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][/vc_column][vc_column width="1/2"][ut_header align="left" title="Creative Solutions And Results That Grow Brands."]We believe our work speaks for itself. Browse our most recent projects below and enjoy our handmade work with love for every detail.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="scroll" animate_once="yes" css=".vc_custom_1499010697737{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/michelle-chiu-238396.jpg?id=5123) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="fadeIn"][vc_column][/vc_column][/vc_row][vc_row][vc_column][ut_header align="center" title="Brooklyn, A Webmaster\'s Best Friend.
Our Vision, Your Future." css=".vc_custom_1499000805030{margin-bottom: 60px !important;}"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.
[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2026%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="How We Work" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.


Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar align="center" border="true" share_text="SHARE:" icon_color="#999999" border_color="#dddddd"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Portfolio A Moment of Silence', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header title="A Moment of Silence."]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ut_gallery_slider type="carousel" number="2" number_tablet="2" autoplay="true" caption="on" caption_text_transform="capitalize" hover_caption="on" hover_caption_text_transform="capitalize" slides="5121,5125,5122,5124" hover_caption_color="#ffffff" caption_color="#292e36" arrow_color="#ffffff" arrow_color_hover="#292e36" arrow_background_color="#0674ec" arrow_background_color_hover="#ffffff" max_icon_color="#ffffff" max_icon_bg_color="#0674ec" hover_color="rgba(20,22,24,0.9)"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Door to Another World" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="Bonsai Tree" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar align="center" border="true" share_text="SHARE:" icon_color="#999999" border_color="#dddddd"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Portfolio Bonsai Tree', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row full_width="stretch_row_content"][vc_column width="1/2"][ut_header align="left" title="Bonsai Tree."]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Sennheiser%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="We love Brooklyn" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#999999" border_color="#dddddd"][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="3" gap="40" caption="yes" caption_below="yes" animate_once="yes" delay_animation="true" caption_transform="capitalize" caption_below_transform="capitalize" gallery="5122,5121,5123" effect="fadeIn" caption_below_color="#292e36" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][ut_video_player url="https://www.youtube.com/watch?v=TXQT1JKCQPo" poster="5119" caption="Relaxing Breakroom " caption_color="#ffffff" overlay_color="rgba(20,22,24,0.1)" play_color="#ffffff" play_bg_color="#0674ec"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Portfolio Bright Shutters Everywhere', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" title="Bright Shutters
Everywhere."]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Brooklyn%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][/vc_column][/vc_row][vc_row][vc_column][ut_video_player poster="5123" url="https://www.youtube.com/watch?v=TXQT1JKCQPo" caption_color="#292e36" play_color="#ffffff" play_bg_color="#0674ec" caption="Brooklyn, a Webmaster\'s Best Friend." overlay_color="rgba(20,22,24,0.1)"][ut_image_gallery thumbnail_size="full" grid="4" gap="40" caption="yes" animate_once="yes" delay_animation="true" gallery="5122,5121,5123,5125" delay_timer="50" effect="fadeIn" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)" caption_font_size="12px"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="We love Brooklyn" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar align="center" border="true" share_text="SHARE:" icon_color="#999999" border_color="#dddddd"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Portfolio Door To Another World', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title="Door To Another World."]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Stairway to Office" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="A Moment of Silence" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][/vc_row_inner][ut_social_share_bar border="true" share_text="SHARE:" border_color="#dddddd" icon_color="#999999"][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="large" grid="2" gap="40" image_border_radius="10" caption="yes" caption_content="custom" caption_below="yes" animate_once="yes" delay_animation="true" caption_transform="capitalize" caption_below_transform="capitalize" gallery="5125,5126,5123,5121" caption_below_color="#292e36" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)" custom_caption="click to enlarge" effect="fadeIn"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Portfolio Ecological System in Office', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row full_width="stretch_row_content" equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title="Ecological System in Office."]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Envato%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22October%2031%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D"][vc_row_inner][vc_column_inner width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="Way of Life" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

[/vc_column_text][/vc_column_inner][/vc_row_inner][ut_social_share_bar border="true" share_text="SHARE:" icon_color="#999999" border_color="#dddddd"][/vc_column][vc_column width="1/2"][ut_animated_image size="full" image_border_radius="10" align="center" link_type="image" hover="yes" caption_below="yes" caption_transform="capitalize" caption_below_transform="capitalize" image="5124" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)" caption_below_color="#292e36"][/vc_column][/vc_row][vc_row full_width="stretch_row_content"][vc_column][ut_image_gallery thumbnail_size="full" grid="2" gap="40" image_border_radius="10" caption="yes" caption_below="yes" animate="false" caption_transform="capitalize" caption_below_transform="capitalize" gallery="5121,5123" caption_below_color="#292e36" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Portfolio Sun Drenched Conference Room', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header align="center" lead_accent_font_weight="bold" title="Another Relaxing Breakroom."]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22PROJECT%3A%22%2C%22description%22%3A%22www.yourlink.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" title_color="#252525"][ut_social_share_bar align="center" border="true" share_text="SHARE:" icon_color="#999999" border_color="#dddddd"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Wake Up" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="I like Coffee" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="4" caption="yes" caption_content="plus" caption_below="yes" animate_once="yes" delay_animation="true" caption_below_transform="capitalize" gallery="5129,5128,5116,5117" effect="fadeIn" caption_below_color="#292e36" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][/vc_column][/vc_row][vc_row background_position="center center" background_attachment="scroll" css=".vc_custom_1498879197882{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/michelle-chiu-238396.jpg?id=5123) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-3 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_parallax_quote]In A World Of Over 1 Billion Websites, Does Your Website Stand Out?[/ut_parallax_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="Brooklyn Design" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="4" caption="yes" caption_content="plus" caption_below="yes" animate_once="yes" delay_animation="true" caption_below_transform="capitalize" gallery="5120,5119,5118,5114" effect="fadeIn" caption_below_color="#292e36" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar align="center" border="true" share_text="SHARE:" icon_color="#999999" border_color="#dddddd"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Relaxing Breakroom', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_header align="left" title="Innovation Needs To
Be Part Of Your Website."]We have created an awesome theme that will help designers, developers and companies create websites for their startups quickly and easily.[/ut_header][ut_social_share_bar border="true" share_text="SHARE:" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" animate_once="yes" delay="true" image="5149" effect="fadeIn" delay_timer="50"][/vc_column][/vc_row][vc_row][vc_column width="1/2" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="50"][ut_animated_image size="large" align="center" link_type="image" hover="yes" animate_once="yes" image="5122" effect="none" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][vc_custom_heading text="Bonsai Tree" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][ut_animated_image size="large" align="center" link_type="image" hover="yes" animate_once="yes" image="5121" effect="none" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][vc_custom_heading text="A Moment of Silence" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2" animate_once="yes" delay="true" delay_timer="50" effect="fadeInUp"][ut_animated_image size="large" align="center" link_type="image" hover="yes" animate_once="yes" image="5129" effect="none" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][vc_custom_heading text="A Dream of White and Beech" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column width="1/2" animate_once="yes" delay="true" effect="fadeInUp" delay_timer="100"][ut_animated_image size="large" align="center" link_type="image" hover="yes" animate_once="yes" image="5119" effect="none" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)"][vc_custom_heading text="Relaxing Breakroom " font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" content_placement="middle" background_position="center center" background_attachment="fixed" css=".vc_custom_1498915865825{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/philipp-berndt-173197-1.jpg?id=5125) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][ut_header align="left" title="Brooklyn Will Make You
More Proud Of Your Business." css=".vc_custom_1498999935871{margin-bottom: 60px !important;}" lead_color="#292e36"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.

[/ut_header][/vc_column][/vc_row][vc_row full_height="yes" content_placement="middle" background_position="center center" background_attachment="fixed" css=".vc_custom_1498915871062{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo28/wp-content/uploads/2016/10/michelle-chiu-238396.jpg?id=5123) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][ut_header align="right" title="Creative Solutions And
Results That Grow Brands." css=".vc_custom_1498999969248{margin-bottom: 60px !important;}" lead_color="#292e36"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.

[/ut_header][/vc_column][/vc_row][vc_row][vc_column][ut_header align="center" title="It\'s All About Turning
Great Ideas Into Websites." css=".vc_custom_1499000018230{margin-bottom: 60px !important;}"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.

[/ut_header][ut_portfolio_details style="inline" align="center" values="%5B%7B%22title%22%3A%22CLIENT%3A%22%2C%22description%22%3A%22Somebody%22%7D%2C%7B%22title%22%3A%22DATE%3A%22%2C%22description%22%3A%22July%2028%2C%202016%22%2C%22is_link%22%3A%22true%22%7D%2C%7B%22title%22%3A%22CATEGORY%3A%22%2C%22description%22%3A%22App%20Development%22%2C%22is_link%22%3A%22true%22%7D%5D" title_color="#252525"][/vc_column][/vc_row][vc_row][vc_column][ut_image_gallery thumbnail_size="full" grid="4" gap="20" caption="yes" caption_content="plus" animate_once="yes" delay_animation="true" gallery="5129,5128,5127,5126,5125,5124,5123,5122,5121,5120,5119,5118" effect="fadeInUp" caption_color="#ffffff" caption_background="rgba(6,116,236,0.9)" delay_timer="50"][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_custom_heading text="How We Build this APP" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][/vc_column][vc_column width="1/2"][vc_custom_heading text="For the People" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ut_social_share_bar align="center" border="true" share_text="SHARE:" share_text_color="#252525" icon_color="#999999" border_color="#efefef"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 28 - Team Single Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="John Brooklyn."]Hello, I\'m John Founder at Brooklyn Designs.
[/ut_header][/vc_column][/vc_row][vc_row][vc_column width="1/2"][ut_team_member align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Founder" social="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22title%22%3A%22Facebook%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22title%22%3A%22Twitter%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-behance%22%2C%22title%22%3A%22Behance%22%2C%22link%22%3A%22url%3A%2523%7C%7C%7C%22%7D%5D" icon_color="#cccccc" icon_color_hover="#0674ec" line_color="#dddddd" ocupation_color="#0674ec"][/ut_team_member][/vc_column][vc_column width="1/2"][vc_custom_heading text="My Biography" font_container="tag:h3|text_align:left" use_theme_fonts="yes"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.

At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing.[/vc_column_text][ut_probar_thin width="99" animate_once="yes" info_font_weight="" info="Project Management" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="99" animate_once="yes" info_font_weight="" info="Creative Work" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="97" animate_once="yes" info_font_weight="" info="Web Development" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][/vc_column][/vc_row][/vc_section][vc_row full_width="stretch_row_content" css=".vc_custom_1477939841961{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column css=".vc_custom_1477939807253{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_custom_heading text="My Latest Work" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][ut_showcase_shortcode showcase_id="4642" css=".vc_custom_1498914296830{margin-bottom: 0px !important;}"][/vc_column][/vc_row]',
        ),
        
        
        
        
        // Demo 29
        array(
            'name'      => esc_html__( 'Demo 29 - Contact Page 1', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499018282436{padding-bottom: 160px !important;}"][vc_row][vc_column width="1/2"][ut_animated_image size="full" image="375"][ut_header align="left"]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#c6c6c6" text_color_hover="#c6c6c6"][vc_custom_heading text="FOLLOW US" font_container="tag:h3|text_align:left" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal" css=".vc_custom_1499289400377{margin-bottom: 20px !important;}"][ut_social_follow gap="40 Pixel" size="30" socials="%5B%7B%22icon%22%3A%22fa%20fa-facebook%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-twitter%22%2C%22colors%22%3A%22global%22%7D%2C%7B%22icon%22%3A%22fa%20fa-instagram%22%2C%22colors%22%3A%22global%22%7D%5D" icon_color="#151515" icon_color_hover="#c6c6c6"][/vc_column][vc_column width="1/2"][ut_animated_image size="full" align="center" image="561"][vc_column_text css=".vc_custom_1499364364838{margin-bottom: 20px !important;}"]B&amp;S Bathrooms is open daily except between 24-26 December and on 1 January.[/vc_column_text][ut_portfolio_details style="inline" align="center" detail_spacing="0" values="%5B%7B%22title%22%3A%22Tuesday-Saturday%22%2C%22description%22%3A%229.00-17.30%22%7D%2C%7B%22title%22%3A%22Sunday-Monday%22%2C%22description%22%3A%2210.00-17.30%22%7D%2C%7B%22title%22%3A%22Last%20Admission%22%2C%22description%22%3A%2217.00%22%2C%22is_link%22%3A%22true%22%7D%5D"][contact-form-7 id="4"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Contact Page 2', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499018282436{padding-bottom: 160px !important;}"][vc_row][vc_column width="1/2"][ut_header align="left" title="We Work For
Your Success."]We welcome you to contact us for more information
about any of our products or services.[/ut_header][vc_custom_heading text="E-MAIL" font_container="tag:div|text_align:left" use_theme_fonts="yes"][vc_custom_heading text="contact@yourdomain.com" font_container="tag:div|font_size:20px|text_align:left|color:%23151515|line_height:30px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1499288609809{margin-bottom: 20px !important;}"][vc_custom_heading text="PHONE" font_container="tag:div|text_align:left" use_theme_fonts="yes"][vc_custom_heading text="(305) 555-4446" font_container="tag:div|font_size:20px|text_align:left|color:%23151515|line_height:30px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1499288653868{margin-bottom: 20px !important;}"][vc_custom_heading text="ADDRESS" font_container="tag:div|text_align:left" use_theme_fonts="yes"][vc_custom_heading text="101 Grand St
Brooklyn, NY 11211" font_container="tag:div|font_size:20px|text_align:left|color:%23151515|line_height:30px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1499289120086{margin-bottom: 20px !important;}"][/vc_column][vc_column width="1/2"][ut_animated_image size="full" align="center" image="375"][ut_animated_image size="full" align="center" image="561"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Contact Page 3', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_section_anchor_id="Contact" css=".vc_custom_1499018282436{padding-bottom: 160px !important;}"][vc_row][vc_column width="1/2"][ut_header align="left" title="We Work For
Your Success."]We welcome you to contact us for more information
about any of our products or services.[/ut_header][ut_fancy_list values="%5B%7B%22icon%22%3A%22fa%20fa-home%22%2C%22title%22%3A%22101%20Grand%20St%2C%20Brooklyn%2C%20NY%2011211%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22contact%40yourdomain.com%22%2C%22is_link%22%3A%22true%22%2C%22link%22%3A%22url%3Ahttp%253A%252F%252Fbeta.unitedthemes.com%252Fdemo_setup%252Fcontact-page%252F%7C%7C%7C%22%7D%2C%7B%22icon%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22(305)%20555-4446%22%7D%5D" icon_color="#292e36" text_color="#292e36" icon_color_hover="#0674ec" text_color_hover="#0674ec"][/vc_column][vc_column width="1/2"][vc_row_inner][vc_column_inner width="1/2"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Bathroom Architect" social="%5B%7B%7D%5D" icon_color="#cccccc" link="|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec" avatar="561" avatar_alternate="561"][/ut_team_member][/vc_column_inner][vc_column_inner width="1/2"][ut_team_member swap_avatar="on" align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Bathroom Architect" social="%5B%7B%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="|||" avatar="561" avatar_alternate="561"][/ut_team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][contact-form-7 id="4"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Portfolio Bathroom Design', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_row_inner][vc_column_inner width="1/2"][ut_header title="Bathroom Design."]We believe our work speaks for itself. Browse our most recent projects below and enjoy our handmade work with love for every detail.[/ut_header][ut_social_share_bar icon_color_hover="#c6c6c6"][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" avatar="561" title="Excellent Service" date="July 5, 2017" author="Ron Marshall" company="B&amp;S Customer" rating_color="#fec42d"]This was the first time we had visited B&amp;S Bathrooms in Brooklyn. Our questions were answered efficiently and we felt confident in placing an order.
[/ut_single_quote][/vc_column_inner][/vc_row_inner][ut_image_gallery thumbnail_size="full" grid="2" gap="40" caption="yes" lazy="true" loader="true" animate_once="yes" delay_animation="true" gallery="561,564,565,566" effect="fadeInUp" loader_color="#151515"][ut_social_share_bar icon_color_hover="#c6c6c6"][vc_row_inner css=".vc_custom_1499216949704{margin-top: 0px !important;}"][vc_column_inner width="1/2"][vc_column_text]<strong>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</strong>

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" avatar="561" title="Great Customer Service" date="July 5, 2017" author="Ron Marshall" company="B&amp;S Customer" rating_color="#fec42d"]Great customer service. When the final total came up too much for our budget, the sales rep worked really hard to find us a very similar suite in our price range. Very kind.
[/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Portfolio Deluxe Bathroom', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column width="1/2"][ut_header title="Deluxe Bathroom.
"]We believe our work speaks for itself. Browse our most recent projects below
and enjoy our handmade work with love for every detail.[/ut_header][ut_social_share_bar][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" avatar="357" title="Excellent Service" date="July 5, 2017" author="Diana Marshall" company="B&amp;S Customer" rating_color="#fec42d"]This was the first time we had visited B&amp;S Bathrooms in Brooklyn. Our questions were answered efficiently and we felt confident in placing an order.[/ut_single_quote][/vc_column][/vc_row][vc_row][vc_column width="1/2"][vc_column_text]<strong>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</strong>

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.
[/vc_column_text][/vc_column][vc_column width="1/2"][vc_column_text]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.[/vc_column_text][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Portfolio Freestanding Bath In Modern Bathroom', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_row_inner][vc_column_inner width="1/2"][ut_header title="Freestanding bath
in modern bathroom."]We believe our work speaks for itself. Browse our most recent projects below and enjoy our handmade work with love for every detail.[/ut_header][ut_social_share_bar icon_color_hover="#c6c6c6"][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" avatar="561" title="Excellent Service" date="July 5, 2017" author="Diana Marshall" company="B&S Customer" rating_color="#fec42d"]This was the first time we had visited B&S Bathrooms in Brooklyn. Our questions were answered efficiently and we felt confident in placing an order.
[/ut_single_quote][/vc_column_inner][/vc_row_inner][ut_image_gallery thumbnail_size="full" caption="yes" lazy="true" loader="true" animate_once="yes" delay_animation="true" gallery="564,565,566,561" effect="fadeInUp" loader_color="#151515"][ut_social_share_bar icon_color_hover="#c6c6c6"][ut_header align="center" title="Contact
B&amp;S Bathrooms."]No job is too small or too large for
our home improvement professionals![/ut_header][ut_btn button_size="bklyn-btn-large" button_custom_border="yes" button_border_width="4" button_text="CALL (156) 444+558+696" button_text_color="#151515" button_background="#ffffff" button_border_color="#151515" button_border_color_hover="#151515" button_link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo29%2Fcontact%2F|||"][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Portfolio Modern White Bathroom', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column width="1/2"][ut_header title="Modern white bathroom."]We believe our work speaks for itself. Browse our most recent projects below and enjoy our handmade work with love for every detail.[/ut_header][vc_column_text]<strong>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</strong>

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][ut_single_quote style="style-2" rating="5" avatar="561" title="Excellent Service" date="July 5, 2017" author="Skyler White" company="B&amp;S Customer" rating_color="#fec42d"]This was the first time we had visited B&amp;S Bathrooms in Brooklyn. Our questions were answered efficiently and we felt confident in placing an order.
[/ut_single_quote][ut_social_share_bar icon_color_hover="#c6c6c6"][/vc_column][vc_column width="1/2"][ut_image_gallery thumbnail_size="full" caption="yes" caption_content="plus" lazy="true" loader="true" delay_animation="true" gallery="561,564,565,566" delay_timer="200" effect="fadeInUp" loader_color="#151515"][/vc_column][/vc_row][/vc_section]',
        ),        
        
        array(
            'name'      => esc_html__( 'Demo 29 - Portfolio Sink in Beautiful Bathroom', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column width="1/2"][ut_header title="Sink in Beautiful Bathroom."]We believe our work speaks for itself. Browse our most recent projects below and enjoy our handmade work with love for every detail.[/ut_header][ut_social_share_bar icon_color_hover="#c6c6c6"][/vc_column][vc_column width="1/2"][ut_single_quote rating="5" avatar="561" title="Excellent Service" date="July 5, 2017" author="Ron Marshall" company="B&amp;S Customer" rating_color="#fec42d"]This was the first time we had visited B&amp;S Bathrooms in Brooklyn. Our questions were answered efficiently and we felt confident in placing an order.
[/ut_single_quote][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1499218636299{margin-top: 0px !important;}"][vc_column][ut_image_gallery thumbnail_size="full" grid="2" caption="yes" lazy="true" loader="true" animate_once="yes" delay_animation="true" gallery="561,564,565,566" effect="fadeInUp" loader_color="#151515"][/vc_column][/vc_row][vc_row css=".vc_custom_1499218564247{margin-top: 0px !important;}"][vc_column][ut_social_share_bar icon_color_hover="#c6c6c6"][vc_row_inner css=".vc_custom_1499218579605{margin-top: 0px !important;}"][vc_column_inner width="1/2"][vc_column_text]<strong>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</strong>

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" avatar="561" title="Great Customer Service" date="July 5, 2017" author="Sykler Marshall" company="B&amp;S Customer" rating_color="#fec42d"]Great customer service. When the final total came up too much for our budget, the sales rep worked really hard to find us a very similar suite in our price range. Very kind.
[/ut_single_quote][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Portfolio The Art of Home The Bathroom', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][vc_row_inner][vc_column_inner width="1/2"][ut_header title="The Art of Home
The Bathroom."]We believe our work speaks for itself. Browse our most recent projects below and enjoy our handmade work with love for every detail.[/ut_header][ut_social_share_bar][/vc_column_inner][vc_column_inner width="1/2"][ut_single_quote rating="5" avatar="561" title="Excellent Service" date="July 5, 2017" author="Ron Marshall" company="B&amp;S Customer" rating_color="#fec42d"]This was the first time we had visited B&amp;S Bathrooms in Brooklyn. Our questions were answered efficiently and we felt confident in placing an order.
[/ut_single_quote][/vc_column_inner][/vc_row_inner][ut_image_gallery thumbnail_size="full" grid="4" caption="yes" caption_content="plus" caption_below="yes" lazy="true" loader="true" animate_once="yes" delay_animation="true" gallery="561,564,565,566" effect="fadeInUp" loader_color="#151515"][vc_row_inner css=".vc_custom_1499216949704{margin-top: 0px !important;}"][vc_column_inner width="1/2"][vc_column_text]<strong>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</strong>

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][vc_column_inner width="1/2"][vc_column_text]<strong>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</strong>

Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Services Page', 'ut_shortcodes' ),
            'content'   => '[vc_section bklyn_overlay="true" css=".vc_custom_1499394026299{padding-bottom: 60px !important;background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo29/wp-content/uploads/2017/07/1.jpg?id=561) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bklyn_overlay_color="rgba(21,21,21,0.35)"][vc_row][vc_column][ut_header align="center" lead_accent_font_weight="bold" title="Our Services
B&amp;S Bathrooms.
" title_color="#ffffff" lead_color="#ffffff"]Our trusted and insured handymen can
help with any part of your remodeling project. [/ut_header][/vc_column][/vc_row][vc_row gap="40" equal_height="yes" content_placement="top" css=".vc_custom_1499017926250{margin-top: 20px !important;}"][vc_column width="1/2" css=".vc_custom_1499096236307{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_service_column_vertical link_icon_position="after" imageicon="529" headline="Bathroom Remodel &amp; Renovation" link="url:%23|title:Request%20Service||" link_hover_color="#292e36" css=".vc_custom_1499364807929{margin-bottom: 20px !important;}" link_icon_fontawesome="fa fa-chevron-circle-right" link_color="#151515" link_icon_color="#0674ec" link_icon_hover_color="#0674ec"]If you would like to upgrade the area with a renovation, you can trust in our professionals to get the job done correctly and on time.[/ut_service_column_vertical][/vc_column][vc_column width="1/2" css=".vc_custom_1499096244552{background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-6 vc_col-md-6 vc_col-sm-12 vc_col-xs-12"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Vanity &amp; Bathroom Mirror Installation" color="#0674ec" info_color="#292e36" percentage_color="#ffffff" percentage_bg_color="#0674ec"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Toilet Repair &amp; Installation" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][ut_probar_thin width="100" animate_once="yes" info_font_size="17" info_font_weight="" border_radius="30" info="Shower Door Installation &amp; Repair" color="#0674ec" percentage_color="#ffffff" percentage_bg_color="#0674ec" info_color="#292e36"][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/3"][ut_service_column link_icon="yes" link_icon_position="after" imageicon="535" headline="Bathroom Fan Installation &amp; Repair" link="url:%23|title:Request%20Service||" link_icon_fontawesome="fa fa-chevron-circle-right" link_icon_color="#0674ec" link_icon_hover_color="#0674ec" link_color="#151515" link_hover_color="#151515"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column link_icon="yes" link_icon_position="after" imageicon="532" headline="Caulking" link="url:%23|title:Request%20Service||" link_icon_fontawesome="fa fa-chevron-circle-right" link_icon_color="#0674ec" link_icon_hover_color="#0674ec" link_color="#151515" link_hover_color="#151515"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column link_icon="yes" link_icon_position="after" imageicon="531" headline="Drywall Repairs &amp; Finishing" link="url:%23|title:Request%20Service||" link_icon_fontawesome="fa fa-chevron-circle-right" link_icon_color="#0674ec" link_icon_hover_color="#0674ec" link_color="#151515" link_hover_color="#151515"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][/vc_row][vc_row][vc_column width="1/3"][ut_service_column link_icon="yes" link_icon_position="after" imageicon="536" headline="Light Fixture Installation &amp; Repair" link="url:%23|title:Request%20Service||" link_icon_fontawesome="fa fa-chevron-circle-right" link_icon_color="#0674ec" link_icon_hover_color="#0674ec" link_color="#151515" link_hover_color="#151515"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column link_icon="yes" link_icon_position="after" imageicon="530" headline="Minor Plumbing Leaks" link="url:%23|title:Request%20Service||" link_icon_fontawesome="fa fa-chevron-circle-right" link_icon_color="#0674ec" link_icon_hover_color="#0674ec" link_color="#151515" link_hover_color="#151515"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][vc_column width="1/3"][ut_service_column link_icon="yes" link_icon_position="after" imageicon="528" headline="Shower Head Servicing" link="url:%23|title:Request%20Service||" link_icon_fontawesome="fa fa-chevron-circle-right" link_icon_color="#0674ec" link_icon_hover_color="#0674ec" link_color="#151515" link_hover_color="#151515"]Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.[/ut_service_column][/vc_column][/vc_row][/vc_section][vc_section][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_header align="left" title="Contact B&amp;S Bathrooms."]No job is too small or too large for our home improvement professionals![/ut_header][ut_btn button_size="bklyn-btn-large" button_align="bklyn-btn-left" button_custom_border="yes" button_border_width="4" button_text="CALL (156) 444+558+696" button_text_color="#151515" button_background="#ffffff" button_border_color="#151515" button_border_color_hover="#151515" button_link="url:http%3A%2F%2Fbeta.unitedthemes.com%2Fbrooklyn-demo29%2Fcontact%2F|||"][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="Bathroom Architect" social="%5B%7B%7D%5D" icon_color="#cccccc" link="|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#0674ec" avatar="561"][/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="Bathroom Architect" social="%5B%7B%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#0674ec" link="|||" avatar="561"][/ut_team_member][/vc_column][/vc_row][/vc_section]',
        ),
        
        array(
            'name'      => esc_html__( 'Demo 29 - Studio Page', 'ut_shortcodes' ),
            'content'   => '[vc_section][vc_row][vc_column][ut_header title="Creative Solutions And
Results That Grow Bathrooms."]We’re a creative bathroom architects located in Brooklyn, New York.
We’ve won a ton of awards and have been featured in all of the magazines.[/ut_header][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column width="1/2"][ut_animated_image size="full" align="center" link_type="image" hover="yes" caption_content="custom" animate_once="yes" delay="true" image="561" effect="none" custom_caption="B&amp;S BATHROOMS" caption_color="#ffffff" caption_background="rgba(21,21,21,0.9)"][/vc_column][vc_column width="1/2"][ut_animated_image size="large" align="center" link_type="image" hover="yes" caption_content="custom" animate_once="yes" delay="true" image="561" effect="none" custom_caption="B&amp;S BATHROOMS" caption_color="#ffffff" caption_background="rgba(21,21,21,0.9)"][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle"][vc_column][ut_header align="center" title="B&amp;S Bathrooms Will Make You
More Proud Of Your Bathroom."]Your bathroom is one of the most highly-trafficked areas
of your home—and you deserve to have one that you love.
[/ut_header][/vc_column][/vc_row][vc_row full_width="stretch_row_content" full_height="yes" background_position="center center" background_attachment="fixed" animate_once="yes" css=".vc_custom_1499393951099{background-image: url(http://themeforest.unitedthemes.com/wpversions/brooklyn/xml/demo29/wp-content/uploads/2017/07/1.jpg?id=561) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" effect="none"][vc_column][/vc_column][/vc_row][vc_row][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-12 vc_col-xs-12"][ut_header style="global" align="left" lead_accent_font_weight="bold" title="We Work For
Your Success." lead_accent_color="#252525"]We believe in a diverse range of personel to bring creative skills, thoughts, and ideas to the table.[/ut_header][ut_custom_link align="left" icon="yes" icon_type="fontawesome" icon_position="after" icon_animation="yes" link="url:%23|title:Learn%20More||" icon_fontawesome="fa fa-chevron-circle-right" link_color="#151515" icon_color="#0674ec"][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member align="left" icon_size="18" line_width="1" name="John Brooklyn" occupation="CALL (305) 555-4446" social="%5B%7B%7D%5D" icon_color="#cccccc" link="|||" line_color="#dddddd" ocupation_color="#0674ec" icon_color_hover="#151515" avatar="561"][/ut_team_member][/vc_column][vc_column width="1/3" offset="vc_col-lg-4 vc_col-md-4 vc_col-sm-6 vc_col-xs-12"][ut_team_member align="left" icon_size="18" line_width="1" name="Will Stevens" occupation="CALL (305) 555-4447" social="%5B%7B%7D%5D" ocupation_color="#0674ec" line_color="#dddddd" icon_color="#cccccc" icon_color_hover="#151515" link="|||" avatar="561"][/ut_team_member][/vc_column][/vc_row][/vc_section]',
        ),        

    );
    
    return $templates;

}

/**
 * Add Theme Default Templates
 *
 * @return    array
 *
 * @access    private
 * @since     4.0
 *
 */
 
if( !function_exists( 'ut_add_vc_template' ) ) {
    
    function ut_add_vc_template() {
    
        foreach( ut_vc_templates() as $template ) {
 
            vc_add_default_templates( $template );
            
        }
    
    }    
    
    add_action( 'vc_load_default_templates_action', 'ut_add_vc_template', 11 ); 
    
}


